// Generated by delombok at Thu Nov 13 21:38:37 UTC 2025
package gov.cms.fiss.pricers.ipps.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithNineFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.math.RoundingMode;

@Schema(description = "The additional capital variable information from claim pricing.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPITAL-VARIABLES", value = "<structure>")}), @Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPITAL2-VARIABLES", value = "<structure>")})})
public class AdditionalCapitalVariableData {
  @BigDecimalScale(scale = 9, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital cost outlier.", example = "1234.896525245", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-CAPI-COST-OUTLIER", value = "PIC 9(07)V9(09)")})})
  @ValidDecimalOutputWithNineFractionDigits
  private BigDecimal capitalCostOutlier;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital disproportionate share hospital adjustment.", example = "90384.75", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPI-DSH-ADJ", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal capitalDisproportionateShareHospitalAdjustment;
  @BigDecimalScale(scale = 4, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital disproportionate share hospital amount.", example = "4.5045", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-CAPI-DSH", value = "PIC 9(01)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal capitalDisproportionateShareHospitalAmount;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital exception amount.", example = "150.93", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPI-EXCEPTIONS", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal capitalExceptionAmount = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4, roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("99999.9999")
  @Digits(integer = 5, fraction = 4)
  @Schema(description = "The capital federal rate.", example = "234.6789", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-CAPI-FED-RATE", value = "PIC 9(05)V9(04)")})})
  @FixedValue
  private BigDecimal capitalFederalRate;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital federal-specific portion.", example = "90384.75", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPI-FSP", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal capitalFederalSpecificPortion;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital federal-specific portion 2B.", example = "38945.76", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPI2-B-FSP", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal capitalFederalSpecificPortion2B;
  @BigDecimalScale(scale = 4, roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @Schema(description = "The capital federal-specific portion percent.", example = "4.5045", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-CAPI-FSP-PCT", value = "PIC 9(01)V9(04)")})})
  @FixedValue
  private BigDecimal capitalFederalSpecificPortionPercent;
  @BigDecimalScale(scale = 4, roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("99999.9999")
  @Digits(integer = 5, fraction = 4)
  @Schema(description = "The capital geographic adjustment factor.", example = "234.6789", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-CAPI-GAF", value = "PIC 9(05)V9(04)")})})
  @FixedValue
  private BigDecimal capitalGeographicAdjustmentFactor;
  @BigDecimalScale(scale = 4, roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @Schema(description = "The capital federal-specific portion.", example = "4.5045", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPI-HSP", value = "PIC 9(01)V9(04)")})})
  @FixedValue
  private BigDecimal capitalHospitalSpecificPortion; // this value is never set
  @BigDecimalScale(scale = 9, roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("999999.999999999")
  @Digits(integer = 6, fraction = 9)
  @Schema(description = "The capital hospital-specific portion part.", example = "783.924583092", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-CAPI-HSP-PART", value = "PIC 9(06)V9(09)")})})
  @FixedValue
  private BigDecimal capitalHospitalSpecificPortionPart;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The capital hospital-specific portion percent.", example = "4.55", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-CAPI-HSP-PCT", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal capitalHospitalSpecificPortionPercent; // this value is never set
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital indirect medical education adjustment.", example = "92378.45", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPI-IME-ADJ", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal capitalIndirectMedicalEducationAdjustment;
  @BigDecimalScale(scale = 9, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital indirect medical education amount.", example = "1234.896525245", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-WK-CAPI-IME-TEACH", value = "PIC 9(06)V9(09)")})})
  @ValidDecimalOutputWithNineFractionDigits
  private BigDecimal capitalIndirectMedicalEducationAmount;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The capital large-urban factor.", example = "1.89", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-CAPI-LARG-URBAN", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal capitalLargeUrbanFactor;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital old hold-harmless amount.", example = "1252452.89", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPI-OLD-HARM", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal capitalOldHoldHarmlessAmount;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital old hold-harmless rate.", example = "165252452.89", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-CAPI-OLD-HARMLESS", value = "PIC 9(09)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal capitalOldHoldHarmlessRate;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital outlier.", example = "654356.45", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPI-OUTLIER", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal capitalOutlier;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital outlier 2B.", example = "92378.45", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPI2-B-OUTLIER", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal capitalOutlier2B;
  @Pattern(regexp = "[ABC]", message = "must be `A`, `B` or `C`")
  @Schema(description = "The code that indicates the type of capital payment methodology for hospitals.", example = "A", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPI2-PAY-CODE", value = "PIC X(1)")})})
  private String capitalPaymentCode;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The capital total payment.", example = "8345679.23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CAPI-TOTAL-PAY", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal capitalTotalPayment;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalCostOutlier() {
    return this.capitalCostOutlier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalDisproportionateShareHospitalAdjustment() {
    return this.capitalDisproportionateShareHospitalAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalDisproportionateShareHospitalAmount() {
    return this.capitalDisproportionateShareHospitalAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalExceptionAmount() {
    return this.capitalExceptionAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalFederalRate() {
    return this.capitalFederalRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalFederalSpecificPortion() {
    return this.capitalFederalSpecificPortion;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalFederalSpecificPortion2B() {
    return this.capitalFederalSpecificPortion2B;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalFederalSpecificPortionPercent() {
    return this.capitalFederalSpecificPortionPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalGeographicAdjustmentFactor() {
    return this.capitalGeographicAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalHospitalSpecificPortion() {
    return this.capitalHospitalSpecificPortion;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalHospitalSpecificPortionPart() {
    return this.capitalHospitalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalHospitalSpecificPortionPercent() {
    return this.capitalHospitalSpecificPortionPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalIndirectMedicalEducationAdjustment() {
    return this.capitalIndirectMedicalEducationAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalIndirectMedicalEducationAmount() {
    return this.capitalIndirectMedicalEducationAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalLargeUrbanFactor() {
    return this.capitalLargeUrbanFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalOldHoldHarmlessAmount() {
    return this.capitalOldHoldHarmlessAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalOldHoldHarmlessRate() {
    return this.capitalOldHoldHarmlessRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalOutlier() {
    return this.capitalOutlier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalOutlier2B() {
    return this.capitalOutlier2B;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCapitalPaymentCode() {
    return this.capitalPaymentCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalTotalPayment() {
    return this.capitalTotalPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalCostOutlier(final BigDecimal capitalCostOutlier) {
    this.capitalCostOutlier = capitalCostOutlier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalDisproportionateShareHospitalAdjustment(final BigDecimal capitalDisproportionateShareHospitalAdjustment) {
    this.capitalDisproportionateShareHospitalAdjustment = capitalDisproportionateShareHospitalAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalDisproportionateShareHospitalAmount(final BigDecimal capitalDisproportionateShareHospitalAmount) {
    this.capitalDisproportionateShareHospitalAmount = capitalDisproportionateShareHospitalAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalExceptionAmount(final BigDecimal capitalExceptionAmount) {
    this.capitalExceptionAmount = capitalExceptionAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalFederalRate(final BigDecimal capitalFederalRate) {
    this.capitalFederalRate = capitalFederalRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalFederalSpecificPortion(final BigDecimal capitalFederalSpecificPortion) {
    this.capitalFederalSpecificPortion = capitalFederalSpecificPortion;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalFederalSpecificPortion2B(final BigDecimal capitalFederalSpecificPortion2B) {
    this.capitalFederalSpecificPortion2B = capitalFederalSpecificPortion2B;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalFederalSpecificPortionPercent(final BigDecimal capitalFederalSpecificPortionPercent) {
    this.capitalFederalSpecificPortionPercent = capitalFederalSpecificPortionPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalGeographicAdjustmentFactor(final BigDecimal capitalGeographicAdjustmentFactor) {
    this.capitalGeographicAdjustmentFactor = capitalGeographicAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalHospitalSpecificPortion(final BigDecimal capitalHospitalSpecificPortion) {
    this.capitalHospitalSpecificPortion = capitalHospitalSpecificPortion;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalHospitalSpecificPortionPart(final BigDecimal capitalHospitalSpecificPortionPart) {
    this.capitalHospitalSpecificPortionPart = capitalHospitalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalHospitalSpecificPortionPercent(final BigDecimal capitalHospitalSpecificPortionPercent) {
    this.capitalHospitalSpecificPortionPercent = capitalHospitalSpecificPortionPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalIndirectMedicalEducationAdjustment(final BigDecimal capitalIndirectMedicalEducationAdjustment) {
    this.capitalIndirectMedicalEducationAdjustment = capitalIndirectMedicalEducationAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalIndirectMedicalEducationAmount(final BigDecimal capitalIndirectMedicalEducationAmount) {
    this.capitalIndirectMedicalEducationAmount = capitalIndirectMedicalEducationAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalLargeUrbanFactor(final BigDecimal capitalLargeUrbanFactor) {
    this.capitalLargeUrbanFactor = capitalLargeUrbanFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalOldHoldHarmlessAmount(final BigDecimal capitalOldHoldHarmlessAmount) {
    this.capitalOldHoldHarmlessAmount = capitalOldHoldHarmlessAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalOldHoldHarmlessRate(final BigDecimal capitalOldHoldHarmlessRate) {
    this.capitalOldHoldHarmlessRate = capitalOldHoldHarmlessRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalOutlier(final BigDecimal capitalOutlier) {
    this.capitalOutlier = capitalOutlier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalOutlier2B(final BigDecimal capitalOutlier2B) {
    this.capitalOutlier2B = capitalOutlier2B;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalPaymentCode(final String capitalPaymentCode) {
    this.capitalPaymentCode = capitalPaymentCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalTotalPayment(final BigDecimal capitalTotalPayment) {
    this.capitalTotalPayment = capitalTotalPayment;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof AdditionalCapitalVariableData)) return false;
    final AdditionalCapitalVariableData other = (AdditionalCapitalVariableData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$capitalCostOutlier = this.getCapitalCostOutlier();
    final java.lang.Object other$capitalCostOutlier = other.getCapitalCostOutlier();
    if (this$capitalCostOutlier == null ? other$capitalCostOutlier != null : !this$capitalCostOutlier.equals(other$capitalCostOutlier)) return false;
    final java.lang.Object this$capitalDisproportionateShareHospitalAdjustment = this.getCapitalDisproportionateShareHospitalAdjustment();
    final java.lang.Object other$capitalDisproportionateShareHospitalAdjustment = other.getCapitalDisproportionateShareHospitalAdjustment();
    if (this$capitalDisproportionateShareHospitalAdjustment == null ? other$capitalDisproportionateShareHospitalAdjustment != null : !this$capitalDisproportionateShareHospitalAdjustment.equals(other$capitalDisproportionateShareHospitalAdjustment)) return false;
    final java.lang.Object this$capitalDisproportionateShareHospitalAmount = this.getCapitalDisproportionateShareHospitalAmount();
    final java.lang.Object other$capitalDisproportionateShareHospitalAmount = other.getCapitalDisproportionateShareHospitalAmount();
    if (this$capitalDisproportionateShareHospitalAmount == null ? other$capitalDisproportionateShareHospitalAmount != null : !this$capitalDisproportionateShareHospitalAmount.equals(other$capitalDisproportionateShareHospitalAmount)) return false;
    final java.lang.Object this$capitalExceptionAmount = this.getCapitalExceptionAmount();
    final java.lang.Object other$capitalExceptionAmount = other.getCapitalExceptionAmount();
    if (this$capitalExceptionAmount == null ? other$capitalExceptionAmount != null : !this$capitalExceptionAmount.equals(other$capitalExceptionAmount)) return false;
    final java.lang.Object this$capitalFederalRate = this.getCapitalFederalRate();
    final java.lang.Object other$capitalFederalRate = other.getCapitalFederalRate();
    if (this$capitalFederalRate == null ? other$capitalFederalRate != null : !this$capitalFederalRate.equals(other$capitalFederalRate)) return false;
    final java.lang.Object this$capitalFederalSpecificPortion = this.getCapitalFederalSpecificPortion();
    final java.lang.Object other$capitalFederalSpecificPortion = other.getCapitalFederalSpecificPortion();
    if (this$capitalFederalSpecificPortion == null ? other$capitalFederalSpecificPortion != null : !this$capitalFederalSpecificPortion.equals(other$capitalFederalSpecificPortion)) return false;
    final java.lang.Object this$capitalFederalSpecificPortion2B = this.getCapitalFederalSpecificPortion2B();
    final java.lang.Object other$capitalFederalSpecificPortion2B = other.getCapitalFederalSpecificPortion2B();
    if (this$capitalFederalSpecificPortion2B == null ? other$capitalFederalSpecificPortion2B != null : !this$capitalFederalSpecificPortion2B.equals(other$capitalFederalSpecificPortion2B)) return false;
    final java.lang.Object this$capitalFederalSpecificPortionPercent = this.getCapitalFederalSpecificPortionPercent();
    final java.lang.Object other$capitalFederalSpecificPortionPercent = other.getCapitalFederalSpecificPortionPercent();
    if (this$capitalFederalSpecificPortionPercent == null ? other$capitalFederalSpecificPortionPercent != null : !this$capitalFederalSpecificPortionPercent.equals(other$capitalFederalSpecificPortionPercent)) return false;
    final java.lang.Object this$capitalGeographicAdjustmentFactor = this.getCapitalGeographicAdjustmentFactor();
    final java.lang.Object other$capitalGeographicAdjustmentFactor = other.getCapitalGeographicAdjustmentFactor();
    if (this$capitalGeographicAdjustmentFactor == null ? other$capitalGeographicAdjustmentFactor != null : !this$capitalGeographicAdjustmentFactor.equals(other$capitalGeographicAdjustmentFactor)) return false;
    final java.lang.Object this$capitalHospitalSpecificPortion = this.getCapitalHospitalSpecificPortion();
    final java.lang.Object other$capitalHospitalSpecificPortion = other.getCapitalHospitalSpecificPortion();
    if (this$capitalHospitalSpecificPortion == null ? other$capitalHospitalSpecificPortion != null : !this$capitalHospitalSpecificPortion.equals(other$capitalHospitalSpecificPortion)) return false;
    final java.lang.Object this$capitalHospitalSpecificPortionPart = this.getCapitalHospitalSpecificPortionPart();
    final java.lang.Object other$capitalHospitalSpecificPortionPart = other.getCapitalHospitalSpecificPortionPart();
    if (this$capitalHospitalSpecificPortionPart == null ? other$capitalHospitalSpecificPortionPart != null : !this$capitalHospitalSpecificPortionPart.equals(other$capitalHospitalSpecificPortionPart)) return false;
    final java.lang.Object this$capitalHospitalSpecificPortionPercent = this.getCapitalHospitalSpecificPortionPercent();
    final java.lang.Object other$capitalHospitalSpecificPortionPercent = other.getCapitalHospitalSpecificPortionPercent();
    if (this$capitalHospitalSpecificPortionPercent == null ? other$capitalHospitalSpecificPortionPercent != null : !this$capitalHospitalSpecificPortionPercent.equals(other$capitalHospitalSpecificPortionPercent)) return false;
    final java.lang.Object this$capitalIndirectMedicalEducationAdjustment = this.getCapitalIndirectMedicalEducationAdjustment();
    final java.lang.Object other$capitalIndirectMedicalEducationAdjustment = other.getCapitalIndirectMedicalEducationAdjustment();
    if (this$capitalIndirectMedicalEducationAdjustment == null ? other$capitalIndirectMedicalEducationAdjustment != null : !this$capitalIndirectMedicalEducationAdjustment.equals(other$capitalIndirectMedicalEducationAdjustment)) return false;
    final java.lang.Object this$capitalIndirectMedicalEducationAmount = this.getCapitalIndirectMedicalEducationAmount();
    final java.lang.Object other$capitalIndirectMedicalEducationAmount = other.getCapitalIndirectMedicalEducationAmount();
    if (this$capitalIndirectMedicalEducationAmount == null ? other$capitalIndirectMedicalEducationAmount != null : !this$capitalIndirectMedicalEducationAmount.equals(other$capitalIndirectMedicalEducationAmount)) return false;
    final java.lang.Object this$capitalLargeUrbanFactor = this.getCapitalLargeUrbanFactor();
    final java.lang.Object other$capitalLargeUrbanFactor = other.getCapitalLargeUrbanFactor();
    if (this$capitalLargeUrbanFactor == null ? other$capitalLargeUrbanFactor != null : !this$capitalLargeUrbanFactor.equals(other$capitalLargeUrbanFactor)) return false;
    final java.lang.Object this$capitalOldHoldHarmlessAmount = this.getCapitalOldHoldHarmlessAmount();
    final java.lang.Object other$capitalOldHoldHarmlessAmount = other.getCapitalOldHoldHarmlessAmount();
    if (this$capitalOldHoldHarmlessAmount == null ? other$capitalOldHoldHarmlessAmount != null : !this$capitalOldHoldHarmlessAmount.equals(other$capitalOldHoldHarmlessAmount)) return false;
    final java.lang.Object this$capitalOldHoldHarmlessRate = this.getCapitalOldHoldHarmlessRate();
    final java.lang.Object other$capitalOldHoldHarmlessRate = other.getCapitalOldHoldHarmlessRate();
    if (this$capitalOldHoldHarmlessRate == null ? other$capitalOldHoldHarmlessRate != null : !this$capitalOldHoldHarmlessRate.equals(other$capitalOldHoldHarmlessRate)) return false;
    final java.lang.Object this$capitalOutlier = this.getCapitalOutlier();
    final java.lang.Object other$capitalOutlier = other.getCapitalOutlier();
    if (this$capitalOutlier == null ? other$capitalOutlier != null : !this$capitalOutlier.equals(other$capitalOutlier)) return false;
    final java.lang.Object this$capitalOutlier2B = this.getCapitalOutlier2B();
    final java.lang.Object other$capitalOutlier2B = other.getCapitalOutlier2B();
    if (this$capitalOutlier2B == null ? other$capitalOutlier2B != null : !this$capitalOutlier2B.equals(other$capitalOutlier2B)) return false;
    final java.lang.Object this$capitalPaymentCode = this.getCapitalPaymentCode();
    final java.lang.Object other$capitalPaymentCode = other.getCapitalPaymentCode();
    if (this$capitalPaymentCode == null ? other$capitalPaymentCode != null : !this$capitalPaymentCode.equals(other$capitalPaymentCode)) return false;
    final java.lang.Object this$capitalTotalPayment = this.getCapitalTotalPayment();
    final java.lang.Object other$capitalTotalPayment = other.getCapitalTotalPayment();
    if (this$capitalTotalPayment == null ? other$capitalTotalPayment != null : !this$capitalTotalPayment.equals(other$capitalTotalPayment)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof AdditionalCapitalVariableData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $capitalCostOutlier = this.getCapitalCostOutlier();
    result = result * PRIME + ($capitalCostOutlier == null ? 43 : $capitalCostOutlier.hashCode());
    final java.lang.Object $capitalDisproportionateShareHospitalAdjustment = this.getCapitalDisproportionateShareHospitalAdjustment();
    result = result * PRIME + ($capitalDisproportionateShareHospitalAdjustment == null ? 43 : $capitalDisproportionateShareHospitalAdjustment.hashCode());
    final java.lang.Object $capitalDisproportionateShareHospitalAmount = this.getCapitalDisproportionateShareHospitalAmount();
    result = result * PRIME + ($capitalDisproportionateShareHospitalAmount == null ? 43 : $capitalDisproportionateShareHospitalAmount.hashCode());
    final java.lang.Object $capitalExceptionAmount = this.getCapitalExceptionAmount();
    result = result * PRIME + ($capitalExceptionAmount == null ? 43 : $capitalExceptionAmount.hashCode());
    final java.lang.Object $capitalFederalRate = this.getCapitalFederalRate();
    result = result * PRIME + ($capitalFederalRate == null ? 43 : $capitalFederalRate.hashCode());
    final java.lang.Object $capitalFederalSpecificPortion = this.getCapitalFederalSpecificPortion();
    result = result * PRIME + ($capitalFederalSpecificPortion == null ? 43 : $capitalFederalSpecificPortion.hashCode());
    final java.lang.Object $capitalFederalSpecificPortion2B = this.getCapitalFederalSpecificPortion2B();
    result = result * PRIME + ($capitalFederalSpecificPortion2B == null ? 43 : $capitalFederalSpecificPortion2B.hashCode());
    final java.lang.Object $capitalFederalSpecificPortionPercent = this.getCapitalFederalSpecificPortionPercent();
    result = result * PRIME + ($capitalFederalSpecificPortionPercent == null ? 43 : $capitalFederalSpecificPortionPercent.hashCode());
    final java.lang.Object $capitalGeographicAdjustmentFactor = this.getCapitalGeographicAdjustmentFactor();
    result = result * PRIME + ($capitalGeographicAdjustmentFactor == null ? 43 : $capitalGeographicAdjustmentFactor.hashCode());
    final java.lang.Object $capitalHospitalSpecificPortion = this.getCapitalHospitalSpecificPortion();
    result = result * PRIME + ($capitalHospitalSpecificPortion == null ? 43 : $capitalHospitalSpecificPortion.hashCode());
    final java.lang.Object $capitalHospitalSpecificPortionPart = this.getCapitalHospitalSpecificPortionPart();
    result = result * PRIME + ($capitalHospitalSpecificPortionPart == null ? 43 : $capitalHospitalSpecificPortionPart.hashCode());
    final java.lang.Object $capitalHospitalSpecificPortionPercent = this.getCapitalHospitalSpecificPortionPercent();
    result = result * PRIME + ($capitalHospitalSpecificPortionPercent == null ? 43 : $capitalHospitalSpecificPortionPercent.hashCode());
    final java.lang.Object $capitalIndirectMedicalEducationAdjustment = this.getCapitalIndirectMedicalEducationAdjustment();
    result = result * PRIME + ($capitalIndirectMedicalEducationAdjustment == null ? 43 : $capitalIndirectMedicalEducationAdjustment.hashCode());
    final java.lang.Object $capitalIndirectMedicalEducationAmount = this.getCapitalIndirectMedicalEducationAmount();
    result = result * PRIME + ($capitalIndirectMedicalEducationAmount == null ? 43 : $capitalIndirectMedicalEducationAmount.hashCode());
    final java.lang.Object $capitalLargeUrbanFactor = this.getCapitalLargeUrbanFactor();
    result = result * PRIME + ($capitalLargeUrbanFactor == null ? 43 : $capitalLargeUrbanFactor.hashCode());
    final java.lang.Object $capitalOldHoldHarmlessAmount = this.getCapitalOldHoldHarmlessAmount();
    result = result * PRIME + ($capitalOldHoldHarmlessAmount == null ? 43 : $capitalOldHoldHarmlessAmount.hashCode());
    final java.lang.Object $capitalOldHoldHarmlessRate = this.getCapitalOldHoldHarmlessRate();
    result = result * PRIME + ($capitalOldHoldHarmlessRate == null ? 43 : $capitalOldHoldHarmlessRate.hashCode());
    final java.lang.Object $capitalOutlier = this.getCapitalOutlier();
    result = result * PRIME + ($capitalOutlier == null ? 43 : $capitalOutlier.hashCode());
    final java.lang.Object $capitalOutlier2B = this.getCapitalOutlier2B();
    result = result * PRIME + ($capitalOutlier2B == null ? 43 : $capitalOutlier2B.hashCode());
    final java.lang.Object $capitalPaymentCode = this.getCapitalPaymentCode();
    result = result * PRIME + ($capitalPaymentCode == null ? 43 : $capitalPaymentCode.hashCode());
    final java.lang.Object $capitalTotalPayment = this.getCapitalTotalPayment();
    result = result * PRIME + ($capitalTotalPayment == null ? 43 : $capitalTotalPayment.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "AdditionalCapitalVariableData(capitalCostOutlier=" + this.getCapitalCostOutlier() + ", capitalDisproportionateShareHospitalAdjustment=" + this.getCapitalDisproportionateShareHospitalAdjustment() + ", capitalDisproportionateShareHospitalAmount=" + this.getCapitalDisproportionateShareHospitalAmount() + ", capitalExceptionAmount=" + this.getCapitalExceptionAmount() + ", capitalFederalRate=" + this.getCapitalFederalRate() + ", capitalFederalSpecificPortion=" + this.getCapitalFederalSpecificPortion() + ", capitalFederalSpecificPortion2B=" + this.getCapitalFederalSpecificPortion2B() + ", capitalFederalSpecificPortionPercent=" + this.getCapitalFederalSpecificPortionPercent() + ", capitalGeographicAdjustmentFactor=" + this.getCapitalGeographicAdjustmentFactor() + ", capitalHospitalSpecificPortion=" + this.getCapitalHospitalSpecificPortion() + ", capitalHospitalSpecificPortionPart=" + this.getCapitalHospitalSpecificPortionPart() + ", capitalHospitalSpecificPortionPercent=" + this.getCapitalHospitalSpecificPortionPercent() + ", capitalIndirectMedicalEducationAdjustment=" + this.getCapitalIndirectMedicalEducationAdjustment() + ", capitalIndirectMedicalEducationAmount=" + this.getCapitalIndirectMedicalEducationAmount() + ", capitalLargeUrbanFactor=" + this.getCapitalLargeUrbanFactor() + ", capitalOldHoldHarmlessAmount=" + this.getCapitalOldHoldHarmlessAmount() + ", capitalOldHoldHarmlessRate=" + this.getCapitalOldHoldHarmlessRate() + ", capitalOutlier=" + this.getCapitalOutlier() + ", capitalOutlier2B=" + this.getCapitalOutlier2B() + ", capitalPaymentCode=" + this.getCapitalPaymentCode() + ", capitalTotalPayment=" + this.getCapitalTotalPayment() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AdditionalCapitalVariableData() {
  }
}
