/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.QueryConverter;
import com.newrelic.api.agent.SlowQueryDatastoreParameters;
import com.newrelic.api.agent.SlowQueryWithInputDatastoreParameters;

public class DatastoreParameters
implements ExternalParameters {
    private final String product;
    private final String collection;
    private final String operation;
    private final String host;
    private final Integer port;
    private final String pathOrId;
    private final String databaseName;

    private DatastoreParameters(String product, String collection, String operation, String host, Integer port, String pathOrId, String databaseName) {
        this.product = product;
        this.collection = collection;
        this.operation = operation;
        this.host = host;
        this.port = port;
        this.pathOrId = pathOrId;
        this.databaseName = databaseName;
    }

    protected DatastoreParameters(DatastoreParameters datastoreParameters) {
        this.product = datastoreParameters.product;
        this.collection = datastoreParameters.collection;
        this.operation = datastoreParameters.operation;
        this.host = datastoreParameters.host;
        this.port = datastoreParameters.port;
        this.pathOrId = datastoreParameters.pathOrId;
        this.databaseName = datastoreParameters.databaseName;
    }

    public String getProduct() {
        return this.product;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPathOrId() {
        return this.pathOrId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public static CollectionParameter product(String product) {
        return new Builder(product);
    }

    public static interface Build {
        public DatastoreParameters build();
    }

    public static interface SlowQueryWithInputParameter
    extends Build {
        public <T> Build slowQueryWithInput(String var1, T var2, QueryConverter<T> var3);
    }

    public static interface SlowQueryParameter
    extends Build {
        public <T> SlowQueryWithInputParameter slowQuery(T var1, QueryConverter<T> var2);

        public SlowQueryWithInputParameter noSlowQuery();
    }

    public static interface DatabaseParameter
    extends Build {
        public SlowQueryParameter databaseName(String var1);

        public SlowQueryParameter noDatabaseName();
    }

    public static interface InstanceParameter
    extends Build {
        public DatabaseParameter instance(String var1, Integer var2);

        public DatabaseParameter instance(String var1, String var2);

        public DatabaseParameter noInstance();
    }

    public static interface OperationParameter {
        public InstanceParameter operation(String var1);
    }

    public static interface CollectionParameter {
        public OperationParameter collection(String var1);
    }

    protected static class Builder
    implements CollectionParameter,
    OperationParameter,
    InstanceParameter,
    DatabaseParameter,
    SlowQueryParameter,
    SlowQueryWithInputParameter,
    Build {
        private String product;
        private String collection;
        private String operation;
        private String host = null;
        private Integer port = null;
        private String pathOrId = null;
        private String databaseName = null;
        private Object rawQuery = null;
        private QueryConverter<Object> queryConverter = null;
        private String inputQueryLabel = null;
        private Object rawInputQuery = null;
        private QueryConverter<Object> rawInputQueryConverter = null;

        public Builder(String product) {
            this.product = product;
        }

        @Override
        public OperationParameter collection(String collection) {
            this.collection = collection;
            return this;
        }

        @Override
        public InstanceParameter operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public DatabaseParameter instance(String host, Integer port) {
            this.host = host;
            this.port = port;
            return this;
        }

        @Override
        public DatabaseParameter instance(String host, String pathOrId) {
            this.host = host;
            this.pathOrId = pathOrId;
            return this;
        }

        @Override
        public DatabaseParameter noInstance() {
            return this;
        }

        @Override
        public SlowQueryParameter databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        @Override
        public DatastoreParameters build() {
            if (this.inputQueryLabel != null && this.rawInputQuery != null && this.rawInputQueryConverter != null) {
                return new SlowQueryWithInputDatastoreParameters(this.buildWithSlowQuery(), this.inputQueryLabel, this.rawInputQuery, this.rawInputQueryConverter);
            }
            if (this.rawQuery != null && this.queryConverter != null) {
                return new SlowQueryDatastoreParameters<Object>(this.buildRegular(), this.rawQuery, this.queryConverter);
            }
            return this.buildRegular();
        }

        @Override
        public SlowQueryParameter noDatabaseName() {
            return this;
        }

        @Override
        public <T> SlowQueryWithInputParameter slowQuery(T rawQuery, QueryConverter<T> queryConverter) {
            this.rawQuery = rawQuery;
            this.queryConverter = queryConverter;
            return this;
        }

        @Override
        public SlowQueryWithInputParameter noSlowQuery() {
            return this;
        }

        private DatastoreParameters buildRegular() {
            return new DatastoreParameters(this.product, this.collection, this.operation, this.host, this.port, this.pathOrId, this.databaseName);
        }

        private SlowQueryDatastoreParameters<?> buildWithSlowQuery() {
            return new SlowQueryDatastoreParameters<Object>(this.buildRegular(), this.rawQuery, this.queryConverter);
        }

        @Override
        public <T> Build slowQueryWithInput(String inputQueryLabel, T rawInputQuery, QueryConverter<T> rawInputQueryConverter) {
            this.inputQueryLabel = inputQueryLabel;
            this.rawInputQuery = rawInputQuery;
            this.rawInputQueryConverter = rawInputQueryConverter;
            return this;
        }
    }
}

