/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.AdditionalCalculationVariableData;
import gov.cms.fiss.pricers.ipps.api.v2.AdditionalCapitalVariableData;
import gov.cms.fiss.pricers.ipps.api.v2.AdditionalOperatingVariableData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;

public class SetDrgCostAdditionalVariables
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        AdditionalCalculationVariableData additionalVariables = calculationContext.getAdditionalVariables();
        AdditionalCapitalVariableData additionalCapitalVariables = additionalVariables.getAdditionalCapitalVariables();
        additionalCapitalVariables.setCapitalFederalSpecificPortionPercent(this.getValueOrNull(calculationContext.getCapitalFederalSpecificPortionPct()));
        additionalCapitalVariables.setCapitalCostOutlier(this.getValueOrNull(calculationContext.getCapitalCostOutlier()));
        additionalCapitalVariables.setCapitalDisproportionateShareHospitalAmount(this.getValueOrNull(calculationContext.getCapitalDisproportionateShareHospital()));
        additionalCapitalVariables.setCapitalOldHoldHarmlessRate(this.getValueOrNull(calculationContext.getCapitalOldHoldHarmlessRate()));
        additionalCapitalVariables.setCapitalFederalRate(calculationContext.getCapitalFederalRate());
        additionalCapitalVariables.setCapitalLargeUrbanFactor(this.getValueOrNull(calculationContext.getCapitalLargeUrbanFactor()));
        additionalCapitalVariables.setCapitalGeographicAdjustmentFactor(this.getValueOrNull(calculationContext.getCapitalGeographicAdjFactor()));
        additionalCapitalVariables.setCapitalHospitalSpecificPortionPercent(this.getValueOrNull(calculationContext.getCapitalHospitalSpecificPortionPercentage()));
        additionalCapitalVariables.setCapitalIndirectMedicalEducationAmount(this.getValueOrNull(calculationContext.getCapitalIndirectMedicalEducation()));
        additionalCapitalVariables.setCapitalHospitalSpecificPortionPart(this.getValueOrNull(calculationContext.getCapitalHospitalSpecificPortionPart()));
        AdditionalOperatingVariableData additionalOperatingVariables = additionalVariables.getAdditionalOperatingVariables();
        additionalOperatingVariables.setOperatingHospitalSpecificPortionPart(this.getValueOrNull(calculationContext.getOperatingHospitalSpecificPortionPart()));
        additionalOperatingVariables.setOperatingDisproportionateShareHospitalRatio(this.getValueOrNull(calculationContext.calculateDefaultOperatingDisproportionateShare()));
        additionalOperatingVariables.setOperatingFederalSpecificPortionPart(this.getValueOrNull(calculationContext.getOperatingFederalSpecificPortionPart()));
        additionalOperatingVariables.setOperatingIndirectMedicalEducationAmount(this.getValueOrNull(calculationContext.getOperatingIndirectMedicalEducation()));
        additionalOperatingVariables.setOperatingDisproportionateShareHospitalAmount(this.getValueOrNull(calculationContext.getOperatingDisproportionateShare()));
        additionalVariables.setWageIndex(calculationContext.getCbsaReference().getWageIndex());
        additionalVariables.setHospitalSpecificPortionPercent(this.getValueOrNull(calculationContext.getOperatingHospitalSpecificPortionPct()));
        additionalVariables.setCostThreshold(calculationContext.getCostThreshold());
        additionalVariables.setHospitalSpecificPortionRate(this.getValueOrNull(calculationContext.getHospitalSpecificPortionRate()));
        additionalVariables.setRegularPercent(this.getValueOrNull(calculationContext.getRegularPercentage()));
        additionalVariables.setNationalLaborCost(this.getValueOrNull(calculationContext.getNationalLabor()));
        additionalVariables.setNationalLaborPercent(this.getValueOrNull(calculationContext.getNationalLaborPct()));
        additionalVariables.setNationalNonLaborCost(this.getValueOrNull(calculationContext.getNationalNonLabor()));
        additionalVariables.setNationalNonLaborPercent(this.getValueOrNull(calculationContext.getNationalNonLaborPct()));
        additionalVariables.setRegularLaborCost(this.getValueOrNull(calculationContext.getNationalLabor()));
        additionalVariables.setRegularNonLaborCost(this.getValueOrNull(calculationContext.getNationalNonLabor()));
    }

    private BigDecimal getValueOrNull(BigDecimal value) {
        BigDecimal returnVal = null;
        if (!BigDecimalUtils.isZero(value)) {
            returnVal = value;
        }
        return returnVal;
    }
}

