/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CalculateValueBasedPurchasingAdjustments
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public boolean shouldExecute(IppsPricerContext calculationContext) {
        return !ArrayUtils.contains((Object[])new ResultCode[]{ResultCode.RC_65_PAY_CODE_NOT_ABC, ResultCode.RC_67_OUTLIER_LOS_GT_COVERED_DAYS, ResultCode.RC_68_INVALID_VBPF_IN_PSF}, (Object)calculationContext.getResultCode());
    }

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        calculationContext.setValueBasedPurchasingAdjustmentAmount(BigDecimal.ZERO);
        if (StringUtils.equals(providerData.getVbpParticipantIndicator(), "N")) {
            return;
        }
        if (!StringUtils.equals(providerData.getVbpParticipantIndicator(), "Y") || !StringUtils.equals(providerData.getHospitalQualityIndicator(), "1") || calculationContext.isValueBasedPurchasingInvalidState()) {
            calculationContext.applyResultCode(ResultCode.RC_68_INVALID_VBPF_IN_PSF);
            return;
        }
        if (BigDecimalUtils.isLessThan(providerData.getVbpAdjustment(), new BigDecimal(".98")) || BigDecimalUtils.isGreaterThan(providerData.getVbpAdjustment(), new BigDecimal("2"))) {
            calculationContext.applyResultCode(ResultCode.RC_68_INVALID_VBPF_IN_PSF);
            calculationContext.setValueBasedPurchasingAdjustmentAmount(BigDecimal.ZERO);
            return;
        }
        calculationContext.setValueBasedPurchasingAdjustmentAmount(providerData.getVbpAdjustment().multiply(calculationContext.getOperatingBaseDrgPayment()).subtract(calculationContext.getOperatingBaseDrgPayment()).setScale(2, RoundingMode.HALF_UP));
    }
}

