/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.tech_addons;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CapCalculatedTechAddOn
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        calculationContext.setOperatingBillCosts(calculationContext.getClaimData().getCoveredCharges().multiply(calculationContext.getOperatingCostToChargeRatio()).setScale(9, RoundingMode.HALF_UP));
        BigDecimal newTechAddOnCap = calculationContext.getBaseDrgPayment().add(calculationContext.getNewTechAddOnPayment()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal newTechAddOnCapDiff = calculationContext.getOperatingBillCosts().subtract(calculationContext.getBaseDrgPayment()).setScale(2, RoundingMode.HALF_UP);
        if (BigDecimalUtils.isLessThan(calculationContext.getOperatingBillCosts(), newTechAddOnCap) && BigDecimalUtils.isGreaterThanZero(newTechAddOnCapDiff)) {
            calculationContext.setNewTechAddOnPayment(calculationContext.getOperatingBillCosts().subtract(calculationContext.getBaseDrgPayment()).setScale(2, RoundingMode.HALF_UP));
        }
        calculationContext.setOperatingBaseDrgPayment(calculationContext.getOperatingFederalSpecificPortionPart().add(calculationContext.getNewTechAddOnPayment()).setScale(2, RoundingMode.HALF_UP));
    }
}

