/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.rules2020.wage_index;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.rules.wage_index.AdjustIndexForRuralFloor;
import gov.cms.fiss.pricers.ipps.core.tables.RuralFloorTableEntry;
import java.math.BigDecimal;

public class AdjustIndexForRuralFloor2020
extends AdjustIndexForRuralFloor {
    @Override
    protected void adjustRuralFloor(IppsPricerContext calculationContext) {
        if (calculationContext.getCbsaLocation().length() > 2) {
            CbsaReference cbsaReference;
            RuralFloorTableEntry ruralFloorTableEntry = calculationContext.getRuralFloor(calculationContext.getStateCode());
            BigDecimal ruralWi = BigDecimal.ZERO;
            if (ruralFloorTableEntry != null) {
                ruralWi = ruralFloorTableEntry.getWageIndex();
            }
            if (BigDecimalUtils.isGreaterThan(ruralWi, (cbsaReference = calculationContext.getCbsaReference()).getWageIndex())) {
                if (ruralFloorTableEntry == null) {
                    cbsaReference.setCbsa(null);
                    cbsaReference.setWageIndex(null);
                } else {
                    cbsaReference.setCbsa(ruralFloorTableEntry.getCbsa());
                    cbsaReference.setWageIndex(ruralFloorTableEntry.getWageIndex());
                }
                calculationContext.getProviderData().setSpecialPaymentIndicator("N");
                calculationContext.setCbsaLocation(calculationContext.getStateCode());
            }
        }
    }
}

