/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.rules2022.calculate_payment.totals;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.api.v2.IppsPaymentData;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.totals.CalculateElectronicHealthRecordSavings;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class CalculateElectronicHealthRecordSavings2022
extends CalculateElectronicHealthRecordSavings
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        BigDecimal marketBasketRatioEhrFull = calculationContext.getMarketBasketRatioEhrFull();
        BigDecimal marketBasketRatioEhrQualFull = calculationContext.getMarketBasketRatioEhrQualifiedFull();
        BigDecimal marketBasketRatioEhrFullPuertoRico = calculationContext.getMarketBasketRatioEhrFullPuertoRico();
        IppsPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal ehrSubtotalSavingsQuantity = BigDecimalUtils.decimalSum(paymentData.getOperatingHospitalSpecificPortionPart(), paymentData.getOperatingFederalSpecificPortionPart(), paymentData.getOperatingDisproportionateShareHospitalAdjustment(), paymentData.getOperatingIndirectMedicalEducationAdjustment(), calculationContext.getReadmissionAdjustmentAmount(), calculationContext.getValueBasedPurchasingAdjustmentAmount(), calculationContext.getBundledAdjustmentPayment()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal ehrSubtotalSavingsLowVolumePayment = BigDecimal.ZERO;
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (StringUtils.equals(providerData.getTemporaryReliefIndicator(), "Y") && BigDecimalUtils.isGreaterThanZero(providerData.getLowVolumeAdjustmentFactor()) && BigDecimalUtils.isLessThanOrEqualTo(providerData.getLowVolumeAdjustmentFactor(), new BigDecimal("0.25"))) {
            ehrSubtotalSavingsLowVolumePayment = BigDecimalUtils.decimalSum(paymentData.getOperatingHospitalSpecificPortionPart(), paymentData.getOperatingFederalSpecificPortionPart(), paymentData.getOperatingDisproportionateShareHospitalAdjustment(), paymentData.getOperatingIndirectMedicalEducationAdjustment()).multiply(providerData.getLowVolumeAdjustmentFactor()).setScale(2, RoundingMode.DOWN);
        }
        BigDecimal ehrSubtotalSavingsQuantityIncludingLowValuePayments = ehrSubtotalSavingsQuantity.add(ehrSubtotalSavingsLowVolumePayment).setScale(2, RoundingMode.DOWN);
        BigDecimal ehrRestoredFullQuantity = StringUtils.equals(providerData.getStateCode(), "40") ? ehrSubtotalSavingsQuantityIncludingLowValuePayments.multiply(marketBasketRatioEhrFullPuertoRico).setScale(2, RoundingMode.HALF_UP) : ehrSubtotalSavingsQuantityIncludingLowValuePayments.multiply(marketBasketRatioEhrFull).setScale(2, RoundingMode.HALF_UP);
        if (!StringUtils.equals(providerData.getHospitalQualityIndicator(), "1")) {
            ehrRestoredFullQuantity = ehrSubtotalSavingsQuantityIncludingLowValuePayments.multiply(marketBasketRatioEhrQualFull).setScale(2, RoundingMode.HALF_UP);
        }
        calculationContext.setElectronicHealthRecordAdjustmentAmt(ehrRestoredFullQuantity.subtract(ehrSubtotalSavingsQuantityIncludingLowValuePayments).setScale(2, RoundingMode.HALF_DOWN));
    }
}

