/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.rules2023.wage_index;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class AdjustIndexForPreviousYear2023
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (StringUtils.equals(providerData.getSupplementalWageIndexIndicator(), "1") && BigDecimalUtils.isLessThanOrEqualToZero(providerData.getSupplementalWageIndex())) {
            calculationContext.applyResultCode(ResultCode.RC_52_INVALID_WAGE_INDEX);
            return;
        }
        if (StringUtils.equals(providerData.getSupplementalWageIndexIndicator(), "1") && BigDecimalUtils.isLessThan(cbsaReference.getWageIndex().subtract(providerData.getSupplementalWageIndex()).divide(providerData.getSupplementalWageIndex(), RoundingMode.HALF_UP), calculationContext.getWageIndexPctReduction())) {
            cbsaReference.setWageIndex(providerData.getSupplementalWageIndex().multiply(calculationContext.getWageIndexPctAdj()).setScale(4, RoundingMode.HALF_UP));
        }
    }
}

