/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipps.IppsPricerConfiguration;
import gov.cms.fiss.pricers.ipps.api.v1.DrgsTableEntry;
import gov.cms.fiss.pricers.ipps.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.ipps.core.tables.CbsaWageIndexLookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.ClaimCodeTableEntryLookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.ClaimCodeType;
import gov.cms.fiss.pricers.ipps.core.tables.DrgsTableEntryLookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.MidnightTableEntry;
import gov.cms.fiss.pricers.ipps.core.tables.MidnightTableEntryLookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.NewTechnologyAmountTableEntry;
import gov.cms.fiss.pricers.ipps.core.tables.NewTechnologyAmountTableEntryLookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.OutMigrationTableEntry;
import gov.cms.fiss.pricers.ipps.core.tables.OutMigrationTableEntryLookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.PrevYearWIFY19TableEntry;
import gov.cms.fiss.pricers.ipps.core.tables.PrevYearWIFY19TableEntryLookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.RatexTableEntry;
import gov.cms.fiss.pricers.ipps.core.tables.RatexTableEntryLookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.RuralFloorTableEntry;
import gov.cms.fiss.pricers.ipps.core.tables.RuralFloorTableEntryLookupGenerator;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class DataTables {
    private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<Integer, DataTables>();
    private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
    private final Map<String, NavigableMap<LocalDate, DrgsTableEntry>> drgsTable;
    private final Map<String, MidnightTableEntry> midnightTable;
    private final Map<String, Map<ClaimCodeType, List<String>>> claimCodeTable;
    private final Map<String, NewTechnologyAmountTableEntry> newTechnologyAmountTable;
    private final Map<String, NavigableMap<LocalDate, OutMigrationTableEntry>> outMigrationTable;
    private final Map<String, PrevYearWIFY19TableEntry> prevYearWIFY19Table;
    private final Map<RatexTableEntry.RatexKey, RatexTableEntry> ratexTable;
    private final Map<String, RuralFloorTableEntry> ruralfloorTable;

    public DataTables(Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable, Map<String, NavigableMap<LocalDate, DrgsTableEntry>> drgsTable, Map<String, MidnightTableEntry> midnightTable, Map<String, Map<ClaimCodeType, List<String>>> claimCodeTable, Map<String, NewTechnologyAmountTableEntry> newTechnologyAmountTable, Map<String, NavigableMap<LocalDate, OutMigrationTableEntry>> outMigrationTable, Map<String, PrevYearWIFY19TableEntry> prevYearWIFY19Table, Map<RatexTableEntry.RatexKey, RatexTableEntry> ratexTable, Map<String, RuralFloorTableEntry> ruralfloorTable) {
        this.cbsaTable = cbsaTable;
        this.drgsTable = drgsTable;
        this.midnightTable = midnightTable;
        this.claimCodeTable = claimCodeTable;
        this.newTechnologyAmountTable = newTechnologyAmountTable;
        this.outMigrationTable = outMigrationTable;
        this.prevYearWIFY19Table = prevYearWIFY19Table;
        this.ratexTable = ratexTable;
        this.ruralfloorTable = ruralfloorTable;
    }

    public static DataTables forYear(int pricerYear) {
        return YEAR_LOOKUP.get(pricerYear);
    }

    public static void loadDataTables(IppsPricerConfiguration pricerConfiguration) {
        CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
        Map<String, MidnightTableEntry> midnightTable = new MidnightTableEntryLookupGenerator(csvIngestionConfiguration).generate();
        CbsaWageIndexLookupGenerator cbsaLookupGenerator = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
        DrgsTableEntryLookupGenerator drgsLookupGenerator = new DrgsTableEntryLookupGenerator(csvIngestionConfiguration);
        ClaimCodeTableEntryLookupGenerator claimCodeLookupGenerator = new ClaimCodeTableEntryLookupGenerator(csvIngestionConfiguration);
        NewTechnologyAmountTableEntryLookupGenerator newTechnologyAmountLookupGenerator = new NewTechnologyAmountTableEntryLookupGenerator(csvIngestionConfiguration);
        OutMigrationTableEntryLookupGenerator outMigrationLookupGenerator = new OutMigrationTableEntryLookupGenerator(csvIngestionConfiguration);
        PrevYearWIFY19TableEntryLookupGenerator prevYearWIFY19LookupGenerator = new PrevYearWIFY19TableEntryLookupGenerator(csvIngestionConfiguration);
        RatexTableEntryLookupGenerator ratexLookupGenerator = new RatexTableEntryLookupGenerator(csvIngestionConfiguration);
        RuralFloorTableEntryLookupGenerator ruralFloorLookupGenerator = new RuralFloorTableEntryLookupGenerator(csvIngestionConfiguration);
        for (int pricerYear : pricerConfiguration.getSupportedYears()) {
            YEAR_LOOKUP.put(pricerYear, new DataTables(cbsaLookupGenerator.generate(pricerYear), drgsLookupGenerator.generate(pricerYear), midnightTable, claimCodeLookupGenerator.generate(pricerYear), newTechnologyAmountLookupGenerator.generate(pricerYear), outMigrationLookupGenerator.generate(pricerYear), prevYearWIFY19LookupGenerator.generate(pricerYear), ratexLookupGenerator.generate(pricerYear), ruralFloorLookupGenerator.generate(pricerYear)));
        }
    }

    public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa, LocalDate effectiveDate) {
        NavigableMap<LocalDate, CbsaWageIndexEntry> entries = this.cbsaTable.get(cbsa);
        if (entries != null) {
            Map.Entry<LocalDate, CbsaWageIndexEntry> entry = entries.floorEntry(effectiveDate);
            return null == entry ? null : entry.getValue();
        }
        return null;
    }

    public DrgsTableEntry getDrgsEntry(String code, LocalDate effectiveDate) {
        NavigableMap<LocalDate, DrgsTableEntry> entries = this.drgsTable.get(StringUtils.leftPad(code, 3, "0"));
        if (entries != null) {
            Map.Entry<LocalDate, DrgsTableEntry> entry = entries.floorEntry(effectiveDate);
            return null == entry ? null : entry.getValue();
        }
        return null;
    }

    public MidnightTableEntry getMidnightEntry(String msa) {
        return this.midnightTable.get(msa);
    }

    public NewTechnologyAmountTableEntry getNewTechnologyAmount(String referenceName) {
        return this.newTechnologyAmountTable.get(referenceName);
    }

    public List<String> getClaimCodes(String referenceName, ClaimCodeType codeType) {
        Map<ClaimCodeType, List<String>> codeTypeReference = this.claimCodeTable.get(referenceName);
        if (null != codeTypeReference) {
            return codeTypeReference.getOrDefault((Object)codeType, new ArrayList());
        }
        return new ArrayList<String>();
    }

    public int countMatchingCodes(String referenceName, ClaimCodeType codeType, List<String> providedCodes) {
        List<String> referenceCodes = this.getClaimCodes(referenceName, codeType);
        return (int)Optional.ofNullable(providedCodes).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).collect(Collectors.toList()).stream().filter(referenceCodes::contains).count();
    }

    public int countMatchingCodesNoDuplicates(String referenceName, ClaimCodeType codeType, List<String> providedCodes) {
        List<String> referenceCodes = this.getClaimCodes(referenceName, codeType);
        return (int)Optional.ofNullable(providedCodes).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).collect(Collectors.toSet()).stream().filter(referenceCodes::contains).count();
    }

    public boolean codesMatch(String referenceName, ClaimCodeType codeType, List<String> providedCodes) {
        List<String> referenceCodes = this.getClaimCodes(referenceName, codeType);
        return Optional.ofNullable(providedCodes).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).anyMatch(referenceCodes::contains);
    }

    public boolean codesMatchAll(String referenceName, ClaimCodeType codeType, List<String> providedCodes) {
        List referenceNames = this.claimCodeTable.keySet().stream().filter(k -> k.startsWith(referenceName)).collect(Collectors.toList());
        return referenceNames.stream().allMatch(rn -> this.codesMatch((String)rn, codeType, providedCodes));
    }

    public OutMigrationTableEntry getOutMigrationEntry(String county, LocalDate dischargeDate, LocalDate fyBeginDate) {
        NavigableMap<LocalDate, OutMigrationTableEntry> entries = this.outMigrationTable.get(county);
        if (entries == null) {
            return null;
        }
        Map.Entry<LocalDate, OutMigrationTableEntry> entry = entries.floorEntry(dischargeDate);
        if (null != entry && LocalDateUtils.isAfterOrEqual(entry.getKey(), fyBeginDate)) {
            return entry.getValue();
        }
        return null;
    }

    public PrevYearWIFY19TableEntry getPrevWageIndex(String providerNumber) {
        return this.prevYearWIFY19Table.get(providerNumber);
    }

    public RatexTableEntry getRatexIndex(String table, RatexTableEntry.Scope scope, boolean isLargeUrban) {
        return this.ratexTable.get(new RatexTableEntry.RatexKey(table, scope, isLargeUrban));
    }

    public RuralFloorTableEntry getRuralFloorIndex(String cbsa) {
        return this.ruralfloorTable.get(cbsa);
    }

    @Generated
    public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
        return this.cbsaTable;
    }

    @Generated
    public Map<String, NavigableMap<LocalDate, DrgsTableEntry>> getDrgsTable() {
        return this.drgsTable;
    }
}

