/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.tables;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@JsonDeserialize(builder=NewTechnologyAmountTableEntryBuilder.class)
@JsonPropertyOrder(value={"technologyName", "amount", "adjustmentFactor"})
@Immutable
public class NewTechnologyAmountTableEntry {
    @BigDecimalScale
    @DecimalMax(value="99999999.99")
    @DecimalMin(value="0")
    @Digits(integer=8, fraction=2)
    private final @DecimalMax(value="99999999.99") @DecimalMin(value="0") @Digits(integer=8, fraction=2) BigDecimal amount;
    @BigDecimalScale
    @DecimalMax(value="1.00")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=2)
    private final @DecimalMax(value="1.00") @DecimalMin(value="0") @Digits(integer=1, fraction=2) BigDecimal adjustmentFactor;
    @Pattern(regexp="[A-Z\\d]+")
    private final @Pattern(regexp="[A-Z\\d]+") String technologyName;

    @Generated
    NewTechnologyAmountTableEntry(BigDecimal amount, BigDecimal adjustmentFactor, String technologyName) {
        this.amount = amount;
        this.adjustmentFactor = adjustmentFactor;
        this.technologyName = technologyName;
    }

    @Generated
    public static NewTechnologyAmountTableEntryBuilder builder() {
        return new NewTechnologyAmountTableEntryBuilder();
    }

    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    public BigDecimal getAdjustmentFactor() {
        return this.adjustmentFactor;
    }

    @Generated
    public String getTechnologyName() {
        return this.technologyName;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class NewTechnologyAmountTableEntryBuilder {
        @Generated
        private BigDecimal amount;
        @Generated
        private BigDecimal adjustmentFactor;
        @Generated
        private String technologyName;

        @Generated
        NewTechnologyAmountTableEntryBuilder() {
        }

        @Generated
        public NewTechnologyAmountTableEntryBuilder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        @Generated
        public NewTechnologyAmountTableEntryBuilder adjustmentFactor(BigDecimal adjustmentFactor) {
            this.adjustmentFactor = adjustmentFactor;
            return this;
        }

        @Generated
        public NewTechnologyAmountTableEntryBuilder technologyName(String technologyName) {
            this.technologyName = technologyName;
            return this;
        }

        @Generated
        public NewTechnologyAmountTableEntry build() {
            return new NewTechnologyAmountTableEntry(this.amount, this.adjustmentFactor, this.technologyName);
        }

        @Generated
        public String toString() {
            return "NewTechnologyAmountTableEntry.NewTechnologyAmountTableEntryBuilder(amount=" + this.amount + ", adjustmentFactor=" + this.adjustmentFactor + ", technologyName=" + this.technologyName + ")";
        }
    }

    @Generated
    public static final class Fields {
        public static final String AMOUNT = "amount";
        public static final String ADJUSTMENT_FACTOR = "adjustmentFactor";
        public static final String TECHNOLOGY_NAME = "technologyName";
    }
}

