/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.info;

import gov.cms.fiss.pricers.common.application.OpenApiApplicationConfiguration;
import gov.cms.fiss.pricers.common.application.info.GitInfo;
import gov.cms.fiss.pricers.common.application.info.InfoConfiguration;
import gov.cms.fiss.pricers.common.application.resources.ApplicationInfo;
import gov.cms.fiss.pricers.common.application.resources.InfoResource;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Environment;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInfoBundle
implements ConfiguredBundle<OpenApiApplicationConfiguration> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationInfoBundle.class);
    private final Map<Integer, String> versionReference = new HashMap<Integer, String>();

    public ApplicationInfoBundle(Map<Integer, String> versionReference) {
        this.versionReference.putAll(versionReference);
    }

    @Override
    public void run(OpenApiApplicationConfiguration configuration, Environment environment) throws Exception {
        ApplicationInfo applicationInfo = new ApplicationInfo();
        InfoConfiguration infoConfiguration = configuration.getInfoConfiguration();
        applicationInfo.setPricerName(infoConfiguration.getPricerName());
        for (int supportedYear : configuration.getSupportedYears()) {
            applicationInfo.getSupportedVersions().put(supportedYear, this.versionReference.getOrDefault(supportedYear, "N/A"));
        }
        Map<String, String> gitInfo = GitInfo.getInfo(environment, infoConfiguration);
        applicationInfo.setApiVersion(gitInfo.getOrDefault("git.build.version", "N/A"));
        applicationInfo.setCommitHash(gitInfo.getOrDefault("git.commit.id", "N/A"));
        LOGGER.info("Registering informational resource");
        environment.jersey().register(new InfoResource(applicationInfo));
    }
}

