/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipps.api.v1.DrgsTableEntry;
import gov.cms.fiss.pricers.ipps.api.v2.AdditionalCalculationVariableData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.api.v2.IppsPaymentData;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import gov.cms.fiss.pricers.ipps.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.ipps.core.tables.DataTables;
import gov.cms.fiss.pricers.ipps.core.tables.RuralFloorTableEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class IppsPricerContext
extends CalculationContext<IppsClaimPricingRequest, IppsClaimPricingResponse> {
    public static final String INDIAN_DEFAULT_CBSA_LOCATION = "99";
    public static final String INDIAN_PROVIDER_TYPE = "08";
    public static final String INDIAN_SPECIAL_STATE_CODE = "02";
    public static final String INDIAN_SPECIAL_CBSA_LOCATION = "98";
    public static final String CODE_COVID1 = "COVID1";
    public static final String CODE_COVID2 = "COVID2";
    public static final String CODE_COVID3 = "COVID3";
    public static final String SPECIAL_WAGE_INDEX_CBSA = "SPEC*";
    public static final BigDecimal DEFAULT_NEW_TECH_PERCENT = new BigDecimal("0.5");
    public static final String ZEROS = "00000";
    public static final String HMO_FLAG_KEY = "hmoClaim";
    public static final String COT_FLAG_KEY = "cotClaim";
    private static final String DRG_POSTACUTE_50_50 = "YY";
    private static final String DRG_POSTACUTE_PER_DIEM = "Y";
    private static final BigDecimal DEFAULT_OPER_DSH_LOW_RANGE_MIN = new BigDecimal("0.1499");
    private static final BigDecimal DEFAULT_OPER_DSH_HIGH_RANGE_MIN = new BigDecimal("0.2019");
    private static final BigDecimal DEFAULT_OPER_DSH_LOW_RANGE_MAX = new BigDecimal("0.2020");
    private static final BigDecimal DEFAULT_OPER_DSH_LIMIT = new BigDecimal("0.1200");
    private static final BigDecimal DEFAULT_OPER_DSH_SUBTRAHEND_LOW = new BigDecimal("0.15");
    private static final BigDecimal DEFAULT_OPER_DSH_SUBTRAHEND_HIGH = new BigDecimal("0.202");
    private static final BigDecimal DEFAULT_OPER_DSH_MULTIPLICAND_LOW = new BigDecimal("0.65");
    private static final BigDecimal DEFAULT_OPER_DSH_MULTIPLICAND_HIGH = new BigDecimal("0.825");
    private static final BigDecimal DEFAULT_OPER_DSH_ADDEND_LOW = new BigDecimal("0.025");
    private static final BigDecimal DEFAULT_OPER_DSH_ADDEND_HIGH = new BigDecimal(".0588");
    private static final String[] STATE_CODES_PUERTO_RICO = new String[]{"40", "84"};
    private static final String[] STATE_CODES_READ_INVALID = new String[]{"40", "84"};
    private static final String[] STATE_CODES_VALUE_BASED_PURCHASING_INVALID = new String[]{"21", "40", "80", "84"};
    private static final BigDecimal DEFAULT_CAPITAL_BASE_RATE = new BigDecimal("459.41");
    private static final BigDecimal DEFAULT_COST_THRESHOLD_BASE = new BigDecimal("25743.0");
    private static final BigDecimal DEFAULT_LABOR_PCT_WI_GT_ONE = new BigDecimal("0.683");
    private static final BigDecimal DEFAULT_NON_LABOR_PCT_WI_GT_ONE = new BigDecimal("0.317");
    private static final BigDecimal DEFAULT_LABOR_PCT_WI_LTEQ_ONE = new BigDecimal("0.62");
    private static final BigDecimal DEFAULT_NON_LABOR_PCT_WI_LTEQ_ONE = new BigDecimal("0.38");
    private static final BigDecimal DEFAULT_MARKET_BASKET_RATIO_EHR_FULL = new BigDecimal("1.02193093");
    private static final BigDecimal DEFAULT_MARKET_BASKET_RATIO_EHR_QUALIFIED_FULL = new BigDecimal("1.022092433");
    private static final BigDecimal DEFAULT_MARKET_BASKET_RATIO_EHR_FULL_PR = BigDecimal.ZERO;
    private static final BigDecimal DEFAULT_OPER_HSP_BUDGET_NEUTRAL_BASE = new BigDecimal("0.99719").setScale(6, RoundingMode.HALF_UP);
    private static final BigDecimal DEFAULT_OPER_HSP_UPDATE_NO_QUALITY_EHR = new BigDecimal("0.9845").setScale(6, RoundingMode.HALF_UP);
    private static final BigDecimal DEFAULT_OPER_HSP_UPDATE_NO_QUALITY_NO_EHR = new BigDecimal("1.00625").setScale(6, RoundingMode.HALF_UP);
    private static final BigDecimal DEFAULT_OPER_HSP_UPDATE_QUALITY_EHR = new BigDecimal("0.99175").setScale(6, RoundingMode.HALF_UP);
    private static final BigDecimal DEFAULT_OPER_HSP_UPDATE_QUALITY_NO_EHR = new BigDecimal("1.0135").setScale(6, RoundingMode.HALF_UP);
    private static final BigDecimal DEFAULT_OPER_HSP_UPDATE_NO_EHR_PR = BigDecimal.ZERO;
    private static final BigDecimal DEFAULT_OPER_HSP_UPDATE_EHR_PR = BigDecimal.ZERO;
    private static final BigDecimal DEFAULT_OPERATING_BASE_RATE = new BigDecimal("5646.08");
    private static final BigDecimal DEFAULT_WAGE_INDEX_QUARTILE_LIMIT = new BigDecimal("0.8457");
    private static final BigDecimal DEFAULT_WAGE_INDEX_PCT_REDUCTION = new BigDecimal("-0.05");
    private static final BigDecimal DEFAULT_WAGE_INDEX_PCT_ADJ = new BigDecimal("0.95");
    private static final String[] BURN_RELATED_DRGS = new String[]{"927", "928", "929", "933", "934", "935"};
    private static final String[] EACH_PROVIDER_TYPES = new String[]{"21", "22"};
    private static final String[] INVALID_PROVIDER_TYPES = new String[]{"14", "15"};
    private static final String[] SCH_REBASED_FY90_PROVIDER_TYPES = new String[]{"16", "17"};
    private static final String[] VALID_REVIEW_CODES = new String[]{"00", "03", "06", "07", "09", "11"};
    @JsonIgnore
    private final DataTables dataTables;
    private final CbsaReference cbsaReference = new CbsaReference();
    private BigDecimal baseDrgPayment;
    private BigDecimal bundledAdjustmentPayment = BigDecimal.ZERO;
    private BigDecimal capitalCostOfLivingAdjustment = BigDecimal.ONE;
    private BigDecimal capital2BFederalSpecificPortionPart = BigDecimal.ZERO;
    private BigDecimal capital2BOutlierPart = BigDecimal.ZERO;
    private String capital2PayCode;
    private BigDecimal capitalCostOutlier = BigDecimal.ZERO;
    private BigDecimal capitalOperatingCostToChargeRatio = BigDecimalUtils.ZERO;
    private BigDecimal capitalDisproportionateShareHospital = BigDecimal.ZERO;
    private BigDecimal capitalDisproportionateShareHospitalAdjustment = BigDecimalUtils.ZERO;
    private BigDecimal capitalExceptionPaymentRate = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal capitalFederalRate = BigDecimal.ZERO;
    private BigDecimal capitalFederalSpecificPortion = BigDecimalUtils.ZERO;
    private BigDecimal capitalFederalSpecificPortionPart = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal capitalFederalSpecificPortionPct = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal capitalGeographicAdjFactor = BigDecimal.ZERO;
    private BigDecimal capitalIndirectMedicalEducationAdj = BigDecimal.ZERO;
    private BigDecimal capitalIndirectMedicalEducation = new BigDecimal("1.0");
    private BigDecimal capitalOutlierPart = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal capitalPaycodePct1 = BigDecimal.ONE;
    private BigDecimal capitalOldHoldHarmless = BigDecimal.ZERO;
    private BigDecimal capitalOutlierCost = BigDecimal.ZERO;
    private BigDecimal capitalOutlierCostPart = BigDecimalUtils.ZERO;
    private BigDecimal capitalSch = BigDecimal.ZERO;
    private BigDecimal capitalShareDollarThreshold = BigDecimalUtils.ZERO;
    private BigDecimal capitalTotalPayment = BigDecimal.ZERO;
    private String cbsaLocation;
    private CbsaWageIndexEntry cbsaWageIndexEntry;
    private BigDecimal costOutlierPct = BigDecimal.ZERO;
    private BigDecimal costThreshold = BigDecimalUtils.ZERO;
    @FixedValue
    private BigDecimal covidAdjustmentFactor = BigDecimal.ONE;
    private LocalDate dischargeDate;
    private BigDecimal dischargeFraction = BigDecimal.ZERO;
    private DrgsTableEntry drgsTableEntry = DrgsTableEntry.ZERO_WEIGHT;
    private BigDecimal drgWeightFraction = BigDecimal.ZERO;
    private LocalDate effectiveDate;
    private BigDecimal electronicHealthRecordAdjustmentAmt = BigDecimal.ZERO;
    private boolean hmoClaim;
    private boolean costOutlierThresholdClaim;
    private BigDecimal hospitalAcquiredConditionAmount = BigDecimalUtils.ZERO;
    private String hrrParticipantIndicator;
    private BigDecimal hospitalReadmissionReductionAdjustment = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal isletIsolationPaymentAddOn = BigDecimal.ZERO;
    private BigDecimal lowVolumePayment = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal midnightAdjustmentFactor = new BigDecimal("1.0");
    @FixedValue
    private BigDecimal nationalPct = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal nationalLabor = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal nationalLaborPct = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal nationalNonLabor = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal nationalNonLaborPct = BigDecimal.ZERO;
    private BigDecimal newTechAddOnPayment = BigDecimal.ZERO;
    private BigDecimal newCovid19TreatmentsAddOnPayment = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal noCostProductAdjustmentFactor = BigDecimal.ONE;
    private BigDecimal operatingBaseDrgPayment = BigDecimal.ZERO;
    private BigDecimal operatingBillCosts = BigDecimalUtils.ZERO;
    private BigDecimal operatingCostToChargeRatio = BigDecimalUtils.ZERO;
    private BigDecimal operatingCostOfLivingAdjustment = BigDecimal.ONE;
    private BigDecimal operatingCostOutlier = BigDecimalUtils.ZERO;
    private BigDecimal operatingDisproportionateShare = BigDecimalUtils.ZERO;
    private BigDecimal operatingDollarThreshold = BigDecimal.ZERO;
    private BigDecimal operatingChargeThreshold = BigDecimal.ZERO;
    private BigDecimal operatingFederalSpecificPortionPart = BigDecimalUtils.ZERO;
    @FixedValue
    private BigDecimal operatingFederalSpecificPortionPct = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal operatingHospitalSpecificPortionPct = BigDecimalUtils.ZERO;
    private BigDecimal operatingHospitalSpecificPortionPart = BigDecimalUtils.ZERO;
    private BigDecimal operatingOutlierCostPart = BigDecimalUtils.ZERO;
    private BigDecimal operatingOutlierPart = BigDecimalUtils.ZERO;
    private BigDecimal operatingShareDollarThreshold = BigDecimalUtils.ZERO;
    private BigDecimal operatingIndirectMedicalEducation = new BigDecimal("1.0");
    private BigDecimal hospitalSpecificPortionRate = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal capitalHospitalSpecificPortionPart = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal capitalHospitalSpecificPortionPercentage = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal regularPercentage = BigDecimal.ZERO;
    private BigDecimal capitalOldHoldHarmlessRate = BigDecimal.ZERO;
    private boolean outlierAdjustmentEnabled = false;
    private BigDecimal outMigrationAdjustment = BigDecimal.ZERO;
    private boolean outlierReconciliation;
    private BigDecimal passthroughAmountPlusMisc = BigDecimalUtils.ZERO;
    private BigDecimal perDiemDays;
    private String ratexTable = "tab1";
    private BigDecimal readmissionAdjustmentAmount = BigDecimal.ZERO;
    private int regularDays = 0;
    private BigDecimal standardAllowedAmount = BigDecimal.ZERO;
    private String stateCode;
    private BigDecimal transferAdjustment = BigDecimal.ZERO;
    private BigDecimal uncompensatedCareAmount = BigDecimal.ZERO;
    private BigDecimal valueBasedPurchasingAdjustment = BigDecimal.ZERO;
    private BigDecimal valueBasedPurchasingAdjustmentAmount = BigDecimal.ZERO;
    private String valueBasedPurchasingParticipant;

    protected IppsPricerContext(IppsClaimPricingRequest input, IppsClaimPricingResponse output, DataTables dataTables) {
        super(input, output);
        this.dataTables = dataTables;
        this.initializeContext();
    }

    protected void initializeContext() {
        IppsClaimPricingResponse output = (IppsClaimPricingResponse)this.getOutput();
        output.setCalculationVersion(this.getCalculationVersion());
        IppsPaymentData paymentData = new IppsPaymentData();
        paymentData.setTotalPayment(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
        paymentData.setFinalWageIndex(BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP));
        output.setPaymentData(paymentData);
        output.setReturnCodeData(ResultCode.RC_00_OK.toReturnCodeData());
        InpatientProviderData providerData = this.getProviderData();
        output.setAdditionalCalculationVariables(new AdditionalCalculationVariableData());
        this.dischargeDate = this.getClaimData().getDischargeDate();
        this.effectiveDate = providerData.getEffectiveDate();
    }

    public abstract String getCalculationVersion();

    @JsonIgnore
    public IppsClaimData getClaimData() {
        return (IppsClaimData)((IppsClaimPricingRequest)this.getInput()).getClaimData();
    }

    @JsonIgnore
    public InpatientProviderData getProviderData() {
        return (InpatientProviderData)((IppsClaimPricingRequest)this.getInput()).getProviderData();
    }

    @JsonIgnore
    public IppsPaymentData getPaymentData() {
        return (IppsPaymentData)((IppsClaimPricingResponse)this.getOutput()).getPaymentData();
    }

    @JsonIgnore
    public AdditionalCalculationVariableData getAdditionalVariables() {
        return ((IppsClaimPricingResponse)this.getOutput()).getAdditionalCalculationVariables();
    }

    public void applyResultCode(ResultCode resultCode) {
        ((IppsClaimPricingResponse)this.getOutput()).setReturnCodeData(resultCode.toReturnCodeData());
    }

    public void adjustResultCodeForOutliers() {
        ReturnCodeData returnCodeData = ((IppsClaimPricingResponse)this.getOutput()).getReturnCodeData();
        int code = Integer.parseInt(returnCodeData.getCode());
        returnCodeData.setCode(String.valueOf(code + 30));
        returnCodeData.setDescription(returnCodeData.getDescription() + " (Outlier)");
    }

    public BigDecimal calculateDefaultOperatingDisproportionateShare() {
        InpatientProviderData providerData = this.getProviderData();
        return providerData.getSupplementalSecurityIncomeRatio().add(providerData.getMedicaidRatio());
    }

    public void clearContextState() {
        this.bundledAdjustmentPayment = BigDecimal.ZERO;
        this.capital2BFederalSpecificPortionPart = BigDecimal.ZERO;
        this.capital2PayCode = null;
        this.capital2BOutlierPart = BigDecimal.ZERO;
        this.capitalOperatingCostToChargeRatio = BigDecimal.ZERO;
        this.capitalCostOutlier = BigDecimal.ZERO;
        this.capitalCostOfLivingAdjustment = BigDecimal.ZERO;
        this.capitalDisproportionateShareHospitalAdjustment = BigDecimal.ZERO;
        this.capitalExceptionPaymentRate = BigDecimal.ZERO;
        this.capitalFederalRate = BigDecimal.ZERO;
        this.capitalFederalSpecificPortion = BigDecimal.ZERO;
        this.capitalFederalSpecificPortionPart = BigDecimal.ZERO;
        this.capitalGeographicAdjFactor = BigDecimal.ZERO;
        this.capitalHospitalSpecificPortionPart = BigDecimal.ZERO;
        this.capitalIndirectMedicalEducationAdj = BigDecimal.ZERO;
        this.capitalOldHoldHarmless = BigDecimal.ZERO;
        this.capitalOutlierCostPart = BigDecimal.ZERO;
        this.capitalOutlierPart = BigDecimal.ZERO;
        this.capitalShareDollarThreshold = BigDecimal.ZERO;
        this.capitalTotalPayment = BigDecimal.ZERO;
        this.costThreshold = BigDecimal.ZERO;
        this.dischargeFraction = BigDecimal.ZERO;
        this.drgsTableEntry = DrgsTableEntry.ZERO_WEIGHT;
        this.drgWeightFraction = BigDecimal.ZERO;
        this.electronicHealthRecordAdjustmentAmt = BigDecimal.ZERO;
        this.hrrParticipantIndicator = null;
        this.hospitalReadmissionReductionAdjustment = BigDecimal.ZERO;
        this.isletIsolationPaymentAddOn = BigDecimal.ZERO;
        this.nationalLaborPct = BigDecimal.ZERO;
        this.nationalNonLaborPct = BigDecimal.ZERO;
        this.nationalPct = BigDecimal.ZERO;
        this.newTechAddOnPayment = BigDecimal.ZERO;
        this.newCovid19TreatmentsAddOnPayment = BigDecimal.ZERO;
        this.operatingBaseDrgPayment = BigDecimal.ZERO;
        this.operatingChargeThreshold = BigDecimal.ZERO;
        this.operatingCostToChargeRatio = BigDecimal.ZERO;
        this.operatingDisproportionateShare = BigDecimal.ZERO;
        this.operatingFederalSpecificPortionPart = BigDecimal.ZERO;
        this.operatingFederalSpecificPortionPct = BigDecimal.ZERO;
        this.operatingHospitalSpecificPortionPart = BigDecimal.ZERO;
        this.operatingIndirectMedicalEducation = BigDecimal.ZERO;
        this.operatingOutlierCostPart = BigDecimal.ZERO;
        this.operatingOutlierPart = BigDecimal.ZERO;
        this.operatingShareDollarThreshold = BigDecimal.ZERO;
        this.perDiemDays = BigDecimal.ZERO;
        this.readmissionAdjustmentAmount = BigDecimal.ZERO;
        this.regularDays = 0;
        this.standardAllowedAmount = BigDecimal.ZERO;
        this.valueBasedPurchasingAdjustment = BigDecimal.ZERO;
        this.valueBasedPurchasingAdjustmentAmount = BigDecimal.ZERO;
        this.valueBasedPurchasingParticipant = null;
        this.clearAdditionalVariablesContextState();
    }

    public void clearAdditionalVariablesContextState() {
        this.getAdditionalVariables().getAdditionalCapitalVariables().setCapitalFederalSpecificPortionPercent(BigDecimal.ZERO);
        this.getAdditionalVariables().getAdditionalCapitalVariables().setCapitalCostOutlier(BigDecimal.ZERO);
        this.getAdditionalVariables().getAdditionalOperatingVariables().setOperatingHospitalSpecificPortionPart(BigDecimal.ZERO);
        this.getAdditionalVariables().setHospitalSpecificPortionRate(BigDecimal.ZERO);
    }

    public LocalDate fiscalYearEnd() {
        return LocalDateUtils.fiscalYearEnd(this.effectiveDate);
    }

    public LocalDate fiscalYearStart() {
        return LocalDateUtils.fiscalYearStart(this.effectiveDate);
    }

    public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa) {
        return this.dataTables.getCbsaWageIndexEntry(cbsa, this.effectiveDate);
    }

    public String getProviderState() {
        return StringUtils.left(this.getProviderData().getProviderCcn(), 2);
    }

    public RuralFloorTableEntry getRuralFloor(String cbsa) {
        return this.dataTables.getRuralFloorIndex(cbsa);
    }

    public ResultCode getResultCode() {
        String code = ((IppsClaimPricingResponse)this.getOutput()).getReturnCodeData().getCode();
        return ResultCode.fromCode(Integer.parseInt(code));
    }

    public boolean isErrorResult() {
        String code = ((IppsClaimPricingResponse)this.getOutput()).getReturnCodeData().getCode();
        return ResultCode.isErrorCode(Integer.parseInt(code));
    }

    public void zeroResponse() {
        IppsPaymentData paymentData = this.getPaymentData();
        paymentData.setOperatingFederalSpecificPortionPart(BigDecimal.ZERO);
        paymentData.setOperatingHospitalSpecificPortionPart(BigDecimal.ZERO);
        paymentData.setOperatingIndirectMedicalEducationAdjustment(BigDecimal.ZERO);
        paymentData.setOperatingOutlierPaymentPart(BigDecimal.ZERO);
        paymentData.setOperatingDisproportionateShareHospitalAdjustment(BigDecimal.ZERO);
        paymentData.setOutlierDays(0);
        paymentData.setRegularDaysUsed(0);
        paymentData.setLifetimeReserveDaysUsed(0);
        paymentData.setTotalPayment(BigDecimal.ZERO);
        this.clearContextState();
    }

    public BigDecimal getBudgetNeutralBase() {
        return DEFAULT_OPER_HSP_BUDGET_NEUTRAL_BASE;
    }

    public String[] getBurnRelatedDrgs() {
        return BURN_RELATED_DRGS;
    }

    public @FixedValue BigDecimal getCapitalLargeUrbanFactor() {
        return BigDecimal.ONE;
    }

    public @FixedValue BigDecimal getCapitalBaseRate() {
        return DEFAULT_CAPITAL_BASE_RATE;
    }

    public @FixedValue BigDecimal getCostThresholdBase() {
        return DEFAULT_COST_THRESHOLD_BASE;
    }

    public @FixedValue BigDecimal getNationalLaborPctWageIndexGtOne() {
        return DEFAULT_LABOR_PCT_WI_GT_ONE;
    }

    public @FixedValue BigDecimal getNationalNonLaborPctWageIndexGtOne() {
        return DEFAULT_NON_LABOR_PCT_WI_GT_ONE;
    }

    public @FixedValue BigDecimal getNationalLaborPctWageIndexLtEqOne() {
        return DEFAULT_LABOR_PCT_WI_LTEQ_ONE;
    }

    public @FixedValue BigDecimal getNationalNonLaborPctWageIndexLtEqOne() {
        return DEFAULT_NON_LABOR_PCT_WI_LTEQ_ONE;
    }

    public @FixedValue BigDecimal getCovidAdjustmentFactorValue() {
        return BigDecimal.ONE;
    }

    public @FixedValue BigDecimal getNoCostProductAdjustmentFactorValue() {
        return BigDecimal.ONE;
    }

    public BigDecimal getFederalSpecificPortionPercent() {
        return BigDecimal.ONE;
    }

    public BigDecimal getHospitalSpecificPortionUpdateFactorWithQualityAndNoEhrReduction() {
        return DEFAULT_OPER_HSP_UPDATE_QUALITY_NO_EHR;
    }

    public BigDecimal getHospitalSpecificPortionUpdateFactorWithNoQualityAndNoEhrReduction() {
        return DEFAULT_OPER_HSP_UPDATE_NO_QUALITY_NO_EHR;
    }

    public BigDecimal getHospitalSpecificPortionUpdateFactorWithQualityAndEhrReduction() {
        return DEFAULT_OPER_HSP_UPDATE_QUALITY_EHR;
    }

    public BigDecimal getHospitalSpecificPortionUpdateFactorWithNoQualityAndEhrReduction() {
        return DEFAULT_OPER_HSP_UPDATE_NO_QUALITY_EHR;
    }

    public BigDecimal getHospitalSpecificPortionUpdateFactorWithNoEhrReductionPuertoRico() {
        return DEFAULT_OPER_HSP_UPDATE_NO_EHR_PR;
    }

    public BigDecimal getHospitalSpecificPortionUpdateFactorWithEhrReductionPuertoRico() {
        return DEFAULT_OPER_HSP_UPDATE_EHR_PR;
    }

    public BigDecimal getMarketBasketRatioEhrFull() {
        return DEFAULT_MARKET_BASKET_RATIO_EHR_FULL;
    }

    public BigDecimal getMarketBasketRatioEhrQualifiedFull() {
        return DEFAULT_MARKET_BASKET_RATIO_EHR_QUALIFIED_FULL;
    }

    public BigDecimal getMarketBasketRatioEhrFullPuertoRico() {
        return DEFAULT_MARKET_BASKET_RATIO_EHR_FULL_PR;
    }

    public BigDecimal getOperatingDisproportionateShareLowRangeMax() {
        return DEFAULT_OPER_DSH_LOW_RANGE_MAX;
    }

    public BigDecimal getOperatingDisproportionateShareLowRangeMin() {
        return DEFAULT_OPER_DSH_LOW_RANGE_MIN;
    }

    public BigDecimal getOperatingDisproportionateShareHighRangeMin() {
        return DEFAULT_OPER_DSH_HIGH_RANGE_MIN;
    }

    public BigDecimal getOperatingDisproportionateShareLimit() {
        return DEFAULT_OPER_DSH_LIMIT;
    }

    public BigDecimal getOperatingDisproportionateShareAddendLow() {
        return DEFAULT_OPER_DSH_ADDEND_LOW;
    }

    public BigDecimal getOperatingDisproportionateShareAddendHigh() {
        return DEFAULT_OPER_DSH_ADDEND_HIGH;
    }

    public BigDecimal getOperatingDisproportionateShareMultiplicandLow() {
        return DEFAULT_OPER_DSH_MULTIPLICAND_LOW;
    }

    public BigDecimal getOperatingDisproportionateShareMultiplicandHigh() {
        return DEFAULT_OPER_DSH_MULTIPLICAND_HIGH;
    }

    public BigDecimal getOperatingDisproportionateShareSubtrahendLow() {
        return DEFAULT_OPER_DSH_SUBTRAHEND_LOW;
    }

    public BigDecimal getOperatingDisproportionateShareSubtrahendHigh() {
        return DEFAULT_OPER_DSH_SUBTRAHEND_HIGH;
    }

    public @FixedValue BigDecimal getOperatingBaseRate() {
        return DEFAULT_OPERATING_BASE_RATE;
    }

    public BigDecimal getPriorYearHospitalSpecificPortionUpdateFactor() {
        return BigDecimal.ONE;
    }

    protected String[] getValidReviewCodes() {
        return VALID_REVIEW_CODES;
    }

    public BigDecimal getWageIndexQuartileLimit() {
        return DEFAULT_WAGE_INDEX_QUARTILE_LIMIT;
    }

    public BigDecimal getWageIndexPctReduction() {
        return DEFAULT_WAGE_INDEX_PCT_REDUCTION;
    }

    public BigDecimal getWageIndexPctAdj() {
        return DEFAULT_WAGE_INDEX_PCT_ADJ;
    }

    public List<String> getProvidedDemoCodes() {
        IppsClaimData claimData = this.getClaimData();
        List<String> demoCodeList = claimData.getDemoCodes();
        if (null != demoCodeList && !demoCodeList.isEmpty()) {
            return demoCodeList;
        }
        return null;
    }

    public List<String> getProvidedNationalDrugCodes() {
        IppsClaimData claimData = this.getClaimData();
        List<String> nationalDrugCodeList = claimData.getNationalDrugCodes();
        if (null != nationalDrugCodeList && !nationalDrugCodeList.isEmpty()) {
            return nationalDrugCodeList;
        }
        return null;
    }

    public boolean isInvalidReviewCode() {
        return !ArrayUtils.contains(this.getValidReviewCodes(), this.getClaimData().getReviewCode());
    }

    public boolean isPayPerDiemDays() {
        return StringUtils.equals(this.getClaimData().getReviewCode(), "03");
    }

    public boolean isPayTransferNoCost() {
        return StringUtils.equals(this.getClaimData().getReviewCode(), "06");
    }

    public boolean isPayTransferSpecialDrug() {
        return ArrayUtils.contains(new String[]{"09", "11"}, this.getClaimData().getReviewCode());
    }

    public boolean isPayTransferSpecialDrugNoCost() {
        return StringUtils.equals(this.getClaimData().getReviewCode(), "11");
    }

    public boolean isPayWithoutCost() {
        return StringUtils.equals(this.getClaimData().getReviewCode(), "07");
    }

    public boolean isCbsaSpecialPaymentIndicatorEmpty() {
        String specialPaymentIndicator = this.getProviderData().getSpecialPaymentIndicator();
        return StringUtils.isEmpty(specialPaymentIndicator);
    }

    public boolean isCbsaSpecialPaymentIndicatorReclassified() {
        return !this.isCbsaSpecialPaymentIndicatorEmpty() && StringUtils.equals(this.getProviderData().getSpecialPaymentIndicator(), DRG_POSTACUTE_PER_DIEM);
    }

    public boolean isCbsaSpecialPaymentIndicatorDual() {
        return !this.isCbsaSpecialPaymentIndicatorEmpty() && StringUtils.equals(this.getProviderData().getSpecialPaymentIndicator(), "D");
    }

    public boolean isCbsaSpecialPaymentIndicatorSpecial() {
        return !this.isCbsaSpecialPaymentIndicatorEmpty() && StringUtils.equalsAny(this.getProviderData().getSpecialPaymentIndicator(), "1", "2");
    }

    public void initializeDrgEntry() {
        this.drgsTableEntry = this.dataTables.getDrgsEntry(this.getClaimData().getDiagnosisRelatedGroup(), this.getEffectiveDate());
    }

    public boolean isDrgPostacute5050() {
        return DRG_POSTACUTE_50_50.equals(this.drgsTableEntry.getPostAcuteCare() + this.drgsTableEntry.getSpecialPaymentPostAcuteCare());
    }

    public boolean isDrgPostacutePerDiem() {
        return DRG_POSTACUTE_PER_DIEM.equals(this.drgsTableEntry.getPostAcuteCare() + this.drgsTableEntry.getSpecialPaymentPostAcuteCare());
    }

    public String getMidnightAdjustmentGeolocation() {
        return ((IppsClaimData)((IppsClaimPricingRequest)this.getInput()).getClaimData()).getMidnightAdjustmentGeolocation();
    }

    public int getGeolocationAsInt() {
        return NumberUtils.toInt(this.getMidnightAdjustmentGeolocation(), -1);
    }

    public boolean isEachProviderType() {
        return StringUtils.equalsAny(this.getProviderData().getProviderType(), EACH_PROVIDER_TYPES);
    }

    public boolean isInvalidProviderType() {
        return StringUtils.equalsAny(this.getProviderData().getProviderType(), INVALID_PROVIDER_TYPES);
    }

    public boolean isStatePuertoRico() {
        return StringUtils.equalsAny(this.getProviderState(), STATE_CODES_PUERTO_RICO);
    }

    public boolean isReadInvalidState() {
        return StringUtils.equalsAny(this.getProviderState(), STATE_CODES_READ_INVALID);
    }

    public boolean isSchRebasedFy90ProviderType() {
        return StringUtils.equalsAny(this.getProviderData().getProviderType(), SCH_REBASED_FY90_PROVIDER_TYPES);
    }

    public LocalDate getTerminationDate() {
        return this.getProviderData().getTerminationDate();
    }

    public boolean isValueBasedPurchasingInvalidState() {
        return StringUtils.equalsAny(this.getProviderState(), STATE_CODES_VALUE_BASED_PURCHASING_INVALID);
    }

    public boolean isWaiverEnabled() {
        return StringUtils.equals(this.getProviderData().getWaiverIndicator(), DRG_POSTACUTE_PER_DIEM);
    }

    @Generated
    public DataTables getDataTables() {
        return this.dataTables;
    }

    @Generated
    public CbsaReference getCbsaReference() {
        return this.cbsaReference;
    }

    @Generated
    public BigDecimal getBaseDrgPayment() {
        return this.baseDrgPayment;
    }

    @Generated
    public void setBaseDrgPayment(BigDecimal baseDrgPayment) {
        this.baseDrgPayment = baseDrgPayment;
    }

    @Generated
    public BigDecimal getBundledAdjustmentPayment() {
        return this.bundledAdjustmentPayment;
    }

    @Generated
    public void setBundledAdjustmentPayment(BigDecimal bundledAdjustmentPayment) {
        this.bundledAdjustmentPayment = bundledAdjustmentPayment;
    }

    @Generated
    public BigDecimal getCapitalCostOfLivingAdjustment() {
        return this.capitalCostOfLivingAdjustment;
    }

    @Generated
    public void setCapitalCostOfLivingAdjustment(BigDecimal capitalCostOfLivingAdjustment) {
        this.capitalCostOfLivingAdjustment = capitalCostOfLivingAdjustment;
    }

    @Generated
    public BigDecimal getCapital2BFederalSpecificPortionPart() {
        return this.capital2BFederalSpecificPortionPart;
    }

    @Generated
    public void setCapital2BFederalSpecificPortionPart(BigDecimal capital2BFederalSpecificPortionPart) {
        this.capital2BFederalSpecificPortionPart = capital2BFederalSpecificPortionPart;
    }

    @Generated
    public BigDecimal getCapital2BOutlierPart() {
        return this.capital2BOutlierPart;
    }

    @Generated
    public void setCapital2BOutlierPart(BigDecimal capital2BOutlierPart) {
        this.capital2BOutlierPart = capital2BOutlierPart;
    }

    @Generated
    public String getCapital2PayCode() {
        return this.capital2PayCode;
    }

    @Generated
    public void setCapital2PayCode(String capital2PayCode) {
        this.capital2PayCode = capital2PayCode;
    }

    @Generated
    public BigDecimal getCapitalCostOutlier() {
        return this.capitalCostOutlier;
    }

    @Generated
    public void setCapitalCostOutlier(BigDecimal capitalCostOutlier) {
        this.capitalCostOutlier = capitalCostOutlier;
    }

    @Generated
    public BigDecimal getCapitalOperatingCostToChargeRatio() {
        return this.capitalOperatingCostToChargeRatio;
    }

    @Generated
    public void setCapitalOperatingCostToChargeRatio(BigDecimal capitalOperatingCostToChargeRatio) {
        this.capitalOperatingCostToChargeRatio = capitalOperatingCostToChargeRatio;
    }

    @Generated
    public BigDecimal getCapitalDisproportionateShareHospital() {
        return this.capitalDisproportionateShareHospital;
    }

    @Generated
    public void setCapitalDisproportionateShareHospital(BigDecimal capitalDisproportionateShareHospital) {
        this.capitalDisproportionateShareHospital = capitalDisproportionateShareHospital;
    }

    @Generated
    public BigDecimal getCapitalDisproportionateShareHospitalAdjustment() {
        return this.capitalDisproportionateShareHospitalAdjustment;
    }

    @Generated
    public void setCapitalDisproportionateShareHospitalAdjustment(BigDecimal capitalDisproportionateShareHospitalAdjustment) {
        this.capitalDisproportionateShareHospitalAdjustment = capitalDisproportionateShareHospitalAdjustment;
    }

    @Generated
    public BigDecimal getCapitalExceptionPaymentRate() {
        return this.capitalExceptionPaymentRate;
    }

    @Generated
    public void setCapitalExceptionPaymentRate(BigDecimal capitalExceptionPaymentRate) {
        this.capitalExceptionPaymentRate = capitalExceptionPaymentRate;
    }

    @Generated
    public BigDecimal getCapitalFederalRate() {
        return this.capitalFederalRate;
    }

    @Generated
    public void setCapitalFederalRate(BigDecimal capitalFederalRate) {
        this.capitalFederalRate = capitalFederalRate;
    }

    @Generated
    public BigDecimal getCapitalFederalSpecificPortion() {
        return this.capitalFederalSpecificPortion;
    }

    @Generated
    public void setCapitalFederalSpecificPortion(BigDecimal capitalFederalSpecificPortion) {
        this.capitalFederalSpecificPortion = capitalFederalSpecificPortion;
    }

    @Generated
    public BigDecimal getCapitalFederalSpecificPortionPart() {
        return this.capitalFederalSpecificPortionPart;
    }

    @Generated
    public void setCapitalFederalSpecificPortionPart(BigDecimal capitalFederalSpecificPortionPart) {
        this.capitalFederalSpecificPortionPart = capitalFederalSpecificPortionPart;
    }

    @Generated
    public BigDecimal getCapitalFederalSpecificPortionPct() {
        return this.capitalFederalSpecificPortionPct;
    }

    @Generated
    public void setCapitalFederalSpecificPortionPct(BigDecimal capitalFederalSpecificPortionPct) {
        this.capitalFederalSpecificPortionPct = capitalFederalSpecificPortionPct;
    }

    @Generated
    public BigDecimal getCapitalGeographicAdjFactor() {
        return this.capitalGeographicAdjFactor;
    }

    @Generated
    public void setCapitalGeographicAdjFactor(BigDecimal capitalGeographicAdjFactor) {
        this.capitalGeographicAdjFactor = capitalGeographicAdjFactor;
    }

    @Generated
    public BigDecimal getCapitalIndirectMedicalEducationAdj() {
        return this.capitalIndirectMedicalEducationAdj;
    }

    @Generated
    public void setCapitalIndirectMedicalEducationAdj(BigDecimal capitalIndirectMedicalEducationAdj) {
        this.capitalIndirectMedicalEducationAdj = capitalIndirectMedicalEducationAdj;
    }

    @Generated
    public BigDecimal getCapitalIndirectMedicalEducation() {
        return this.capitalIndirectMedicalEducation;
    }

    @Generated
    public void setCapitalIndirectMedicalEducation(BigDecimal capitalIndirectMedicalEducation) {
        this.capitalIndirectMedicalEducation = capitalIndirectMedicalEducation;
    }

    @Generated
    public BigDecimal getCapitalOutlierPart() {
        return this.capitalOutlierPart;
    }

    @Generated
    public void setCapitalOutlierPart(BigDecimal capitalOutlierPart) {
        this.capitalOutlierPart = capitalOutlierPart;
    }

    @Generated
    public BigDecimal getCapitalPaycodePct1() {
        return this.capitalPaycodePct1;
    }

    @Generated
    public void setCapitalPaycodePct1(BigDecimal capitalPaycodePct1) {
        this.capitalPaycodePct1 = capitalPaycodePct1;
    }

    @Generated
    public BigDecimal getCapitalOldHoldHarmless() {
        return this.capitalOldHoldHarmless;
    }

    @Generated
    public void setCapitalOldHoldHarmless(BigDecimal capitalOldHoldHarmless) {
        this.capitalOldHoldHarmless = capitalOldHoldHarmless;
    }

    @Generated
    public BigDecimal getCapitalOutlierCost() {
        return this.capitalOutlierCost;
    }

    @Generated
    public void setCapitalOutlierCost(BigDecimal capitalOutlierCost) {
        this.capitalOutlierCost = capitalOutlierCost;
    }

    @Generated
    public BigDecimal getCapitalOutlierCostPart() {
        return this.capitalOutlierCostPart;
    }

    @Generated
    public void setCapitalOutlierCostPart(BigDecimal capitalOutlierCostPart) {
        this.capitalOutlierCostPart = capitalOutlierCostPart;
    }

    @Generated
    public BigDecimal getCapitalSch() {
        return this.capitalSch;
    }

    @Generated
    public void setCapitalSch(BigDecimal capitalSch) {
        this.capitalSch = capitalSch;
    }

    @Generated
    public BigDecimal getCapitalShareDollarThreshold() {
        return this.capitalShareDollarThreshold;
    }

    @Generated
    public void setCapitalShareDollarThreshold(BigDecimal capitalShareDollarThreshold) {
        this.capitalShareDollarThreshold = capitalShareDollarThreshold;
    }

    @Generated
    public BigDecimal getCapitalTotalPayment() {
        return this.capitalTotalPayment;
    }

    @Generated
    public void setCapitalTotalPayment(BigDecimal capitalTotalPayment) {
        this.capitalTotalPayment = capitalTotalPayment;
    }

    @Generated
    public String getCbsaLocation() {
        return this.cbsaLocation;
    }

    @Generated
    public void setCbsaLocation(String cbsaLocation) {
        this.cbsaLocation = cbsaLocation;
    }

    @Generated
    public CbsaWageIndexEntry getCbsaWageIndexEntry() {
        return this.cbsaWageIndexEntry;
    }

    @Generated
    public void setCbsaWageIndexEntry(CbsaWageIndexEntry cbsaWageIndexEntry) {
        this.cbsaWageIndexEntry = cbsaWageIndexEntry;
    }

    @Generated
    public BigDecimal getCostOutlierPct() {
        return this.costOutlierPct;
    }

    @Generated
    public void setCostOutlierPct(BigDecimal costOutlierPct) {
        this.costOutlierPct = costOutlierPct;
    }

    @Generated
    public BigDecimal getCostThreshold() {
        return this.costThreshold;
    }

    @Generated
    public void setCostThreshold(BigDecimal costThreshold) {
        this.costThreshold = costThreshold;
    }

    @Generated
    public BigDecimal getCovidAdjustmentFactor() {
        return this.covidAdjustmentFactor;
    }

    @Generated
    public void setCovidAdjustmentFactor(BigDecimal covidAdjustmentFactor) {
        this.covidAdjustmentFactor = covidAdjustmentFactor;
    }

    @Generated
    public LocalDate getDischargeDate() {
        return this.dischargeDate;
    }

    @Generated
    public BigDecimal getDischargeFraction() {
        return this.dischargeFraction;
    }

    @Generated
    public void setDischargeFraction(BigDecimal dischargeFraction) {
        this.dischargeFraction = dischargeFraction;
    }

    @Generated
    public DrgsTableEntry getDrgsTableEntry() {
        return this.drgsTableEntry;
    }

    @Generated
    public BigDecimal getDrgWeightFraction() {
        return this.drgWeightFraction;
    }

    @Generated
    public void setDrgWeightFraction(BigDecimal drgWeightFraction) {
        this.drgWeightFraction = drgWeightFraction;
    }

    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @Generated
    public BigDecimal getElectronicHealthRecordAdjustmentAmt() {
        return this.electronicHealthRecordAdjustmentAmt;
    }

    @Generated
    public void setElectronicHealthRecordAdjustmentAmt(BigDecimal electronicHealthRecordAdjustmentAmt) {
        this.electronicHealthRecordAdjustmentAmt = electronicHealthRecordAdjustmentAmt;
    }

    @Generated
    public boolean isHmoClaim() {
        return this.hmoClaim;
    }

    @Generated
    public void setHmoClaim(boolean hmoClaim) {
        this.hmoClaim = hmoClaim;
    }

    @Generated
    public boolean isCostOutlierThresholdClaim() {
        return this.costOutlierThresholdClaim;
    }

    @Generated
    public void setCostOutlierThresholdClaim(boolean costOutlierThresholdClaim) {
        this.costOutlierThresholdClaim = costOutlierThresholdClaim;
    }

    @Generated
    public BigDecimal getHospitalAcquiredConditionAmount() {
        return this.hospitalAcquiredConditionAmount;
    }

    @Generated
    public void setHospitalAcquiredConditionAmount(BigDecimal hospitalAcquiredConditionAmount) {
        this.hospitalAcquiredConditionAmount = hospitalAcquiredConditionAmount;
    }

    @Generated
    public String getHrrParticipantIndicator() {
        return this.hrrParticipantIndicator;
    }

    @Generated
    public void setHrrParticipantIndicator(String hrrParticipantIndicator) {
        this.hrrParticipantIndicator = hrrParticipantIndicator;
    }

    @Generated
    public BigDecimal getHospitalReadmissionReductionAdjustment() {
        return this.hospitalReadmissionReductionAdjustment;
    }

    @Generated
    public void setHospitalReadmissionReductionAdjustment(BigDecimal hospitalReadmissionReductionAdjustment) {
        this.hospitalReadmissionReductionAdjustment = hospitalReadmissionReductionAdjustment;
    }

    @Generated
    public BigDecimal getIsletIsolationPaymentAddOn() {
        return this.isletIsolationPaymentAddOn;
    }

    @Generated
    public void setIsletIsolationPaymentAddOn(BigDecimal isletIsolationPaymentAddOn) {
        this.isletIsolationPaymentAddOn = isletIsolationPaymentAddOn;
    }

    @Generated
    public BigDecimal getLowVolumePayment() {
        return this.lowVolumePayment;
    }

    @Generated
    public void setLowVolumePayment(BigDecimal lowVolumePayment) {
        this.lowVolumePayment = lowVolumePayment;
    }

    @Generated
    public BigDecimal getMidnightAdjustmentFactor() {
        return this.midnightAdjustmentFactor;
    }

    @Generated
    public void setMidnightAdjustmentFactor(BigDecimal midnightAdjustmentFactor) {
        this.midnightAdjustmentFactor = midnightAdjustmentFactor;
    }

    @Generated
    public BigDecimal getNationalPct() {
        return this.nationalPct;
    }

    @Generated
    public void setNationalPct(BigDecimal nationalPct) {
        this.nationalPct = nationalPct;
    }

    @Generated
    public BigDecimal getNationalLabor() {
        return this.nationalLabor;
    }

    @Generated
    public void setNationalLabor(BigDecimal nationalLabor) {
        this.nationalLabor = nationalLabor;
    }

    @Generated
    public BigDecimal getNationalLaborPct() {
        return this.nationalLaborPct;
    }

    @Generated
    public void setNationalLaborPct(BigDecimal nationalLaborPct) {
        this.nationalLaborPct = nationalLaborPct;
    }

    @Generated
    public BigDecimal getNationalNonLabor() {
        return this.nationalNonLabor;
    }

    @Generated
    public void setNationalNonLabor(BigDecimal nationalNonLabor) {
        this.nationalNonLabor = nationalNonLabor;
    }

    @Generated
    public BigDecimal getNationalNonLaborPct() {
        return this.nationalNonLaborPct;
    }

    @Generated
    public void setNationalNonLaborPct(BigDecimal nationalNonLaborPct) {
        this.nationalNonLaborPct = nationalNonLaborPct;
    }

    @Generated
    public BigDecimal getNewTechAddOnPayment() {
        return this.newTechAddOnPayment;
    }

    @Generated
    public void setNewTechAddOnPayment(BigDecimal newTechAddOnPayment) {
        this.newTechAddOnPayment = newTechAddOnPayment;
    }

    @Generated
    public BigDecimal getNewCovid19TreatmentsAddOnPayment() {
        return this.newCovid19TreatmentsAddOnPayment;
    }

    @Generated
    public void setNewCovid19TreatmentsAddOnPayment(BigDecimal newCovid19TreatmentsAddOnPayment) {
        this.newCovid19TreatmentsAddOnPayment = newCovid19TreatmentsAddOnPayment;
    }

    @Generated
    public BigDecimal getNoCostProductAdjustmentFactor() {
        return this.noCostProductAdjustmentFactor;
    }

    @Generated
    public void setNoCostProductAdjustmentFactor(BigDecimal noCostProductAdjustmentFactor) {
        this.noCostProductAdjustmentFactor = noCostProductAdjustmentFactor;
    }

    @Generated
    public BigDecimal getOperatingBaseDrgPayment() {
        return this.operatingBaseDrgPayment;
    }

    @Generated
    public void setOperatingBaseDrgPayment(BigDecimal operatingBaseDrgPayment) {
        this.operatingBaseDrgPayment = operatingBaseDrgPayment;
    }

    @Generated
    public BigDecimal getOperatingBillCosts() {
        return this.operatingBillCosts;
    }

    @Generated
    public void setOperatingBillCosts(BigDecimal operatingBillCosts) {
        this.operatingBillCosts = operatingBillCosts;
    }

    @Generated
    public BigDecimal getOperatingCostToChargeRatio() {
        return this.operatingCostToChargeRatio;
    }

    @Generated
    public void setOperatingCostToChargeRatio(BigDecimal operatingCostToChargeRatio) {
        this.operatingCostToChargeRatio = operatingCostToChargeRatio;
    }

    @Generated
    public BigDecimal getOperatingCostOfLivingAdjustment() {
        return this.operatingCostOfLivingAdjustment;
    }

    @Generated
    public void setOperatingCostOfLivingAdjustment(BigDecimal operatingCostOfLivingAdjustment) {
        this.operatingCostOfLivingAdjustment = operatingCostOfLivingAdjustment;
    }

    @Generated
    public BigDecimal getOperatingCostOutlier() {
        return this.operatingCostOutlier;
    }

    @Generated
    public void setOperatingCostOutlier(BigDecimal operatingCostOutlier) {
        this.operatingCostOutlier = operatingCostOutlier;
    }

    @Generated
    public BigDecimal getOperatingDisproportionateShare() {
        return this.operatingDisproportionateShare;
    }

    @Generated
    public void setOperatingDisproportionateShare(BigDecimal operatingDisproportionateShare) {
        this.operatingDisproportionateShare = operatingDisproportionateShare;
    }

    @Generated
    public BigDecimal getOperatingDollarThreshold() {
        return this.operatingDollarThreshold;
    }

    @Generated
    public void setOperatingDollarThreshold(BigDecimal operatingDollarThreshold) {
        this.operatingDollarThreshold = operatingDollarThreshold;
    }

    @Generated
    public BigDecimal getOperatingChargeThreshold() {
        return this.operatingChargeThreshold;
    }

    @Generated
    public void setOperatingChargeThreshold(BigDecimal operatingChargeThreshold) {
        this.operatingChargeThreshold = operatingChargeThreshold;
    }

    @Generated
    public BigDecimal getOperatingFederalSpecificPortionPart() {
        return this.operatingFederalSpecificPortionPart;
    }

    @Generated
    public void setOperatingFederalSpecificPortionPart(BigDecimal operatingFederalSpecificPortionPart) {
        this.operatingFederalSpecificPortionPart = operatingFederalSpecificPortionPart;
    }

    @Generated
    public BigDecimal getOperatingFederalSpecificPortionPct() {
        return this.operatingFederalSpecificPortionPct;
    }

    @Generated
    public void setOperatingFederalSpecificPortionPct(BigDecimal operatingFederalSpecificPortionPct) {
        this.operatingFederalSpecificPortionPct = operatingFederalSpecificPortionPct;
    }

    @Generated
    public BigDecimal getOperatingHospitalSpecificPortionPct() {
        return this.operatingHospitalSpecificPortionPct;
    }

    @Generated
    public void setOperatingHospitalSpecificPortionPct(BigDecimal operatingHospitalSpecificPortionPct) {
        this.operatingHospitalSpecificPortionPct = operatingHospitalSpecificPortionPct;
    }

    @Generated
    public BigDecimal getOperatingHospitalSpecificPortionPart() {
        return this.operatingHospitalSpecificPortionPart;
    }

    @Generated
    public void setOperatingHospitalSpecificPortionPart(BigDecimal operatingHospitalSpecificPortionPart) {
        this.operatingHospitalSpecificPortionPart = operatingHospitalSpecificPortionPart;
    }

    @Generated
    public BigDecimal getOperatingOutlierCostPart() {
        return this.operatingOutlierCostPart;
    }

    @Generated
    public void setOperatingOutlierCostPart(BigDecimal operatingOutlierCostPart) {
        this.operatingOutlierCostPart = operatingOutlierCostPart;
    }

    @Generated
    public BigDecimal getOperatingOutlierPart() {
        return this.operatingOutlierPart;
    }

    @Generated
    public void setOperatingOutlierPart(BigDecimal operatingOutlierPart) {
        this.operatingOutlierPart = operatingOutlierPart;
    }

    @Generated
    public BigDecimal getOperatingShareDollarThreshold() {
        return this.operatingShareDollarThreshold;
    }

    @Generated
    public void setOperatingShareDollarThreshold(BigDecimal operatingShareDollarThreshold) {
        this.operatingShareDollarThreshold = operatingShareDollarThreshold;
    }

    @Generated
    public BigDecimal getOperatingIndirectMedicalEducation() {
        return this.operatingIndirectMedicalEducation;
    }

    @Generated
    public void setOperatingIndirectMedicalEducation(BigDecimal operatingIndirectMedicalEducation) {
        this.operatingIndirectMedicalEducation = operatingIndirectMedicalEducation;
    }

    @Generated
    public BigDecimal getHospitalSpecificPortionRate() {
        return this.hospitalSpecificPortionRate;
    }

    @Generated
    public void setHospitalSpecificPortionRate(BigDecimal hospitalSpecificPortionRate) {
        this.hospitalSpecificPortionRate = hospitalSpecificPortionRate;
    }

    @Generated
    public BigDecimal getCapitalHospitalSpecificPortionPart() {
        return this.capitalHospitalSpecificPortionPart;
    }

    @Generated
    public void setCapitalHospitalSpecificPortionPart(BigDecimal capitalHospitalSpecificPortionPart) {
        this.capitalHospitalSpecificPortionPart = capitalHospitalSpecificPortionPart;
    }

    @Generated
    public BigDecimal getCapitalHospitalSpecificPortionPercentage() {
        return this.capitalHospitalSpecificPortionPercentage;
    }

    @Generated
    public void setCapitalHospitalSpecificPortionPercentage(BigDecimal capitalHospitalSpecificPortionPercentage) {
        this.capitalHospitalSpecificPortionPercentage = capitalHospitalSpecificPortionPercentage;
    }

    @Generated
    public BigDecimal getRegularPercentage() {
        return this.regularPercentage;
    }

    @Generated
    public void setRegularPercentage(BigDecimal regularPercentage) {
        this.regularPercentage = regularPercentage;
    }

    @Generated
    public BigDecimal getCapitalOldHoldHarmlessRate() {
        return this.capitalOldHoldHarmlessRate;
    }

    @Generated
    public void setCapitalOldHoldHarmlessRate(BigDecimal capitalOldHoldHarmlessRate) {
        this.capitalOldHoldHarmlessRate = capitalOldHoldHarmlessRate;
    }

    @Generated
    public boolean isOutlierAdjustmentEnabled() {
        return this.outlierAdjustmentEnabled;
    }

    @Generated
    public void setOutlierAdjustmentEnabled(boolean outlierAdjustmentEnabled) {
        this.outlierAdjustmentEnabled = outlierAdjustmentEnabled;
    }

    @Generated
    public BigDecimal getOutMigrationAdjustment() {
        return this.outMigrationAdjustment;
    }

    @Generated
    public void setOutMigrationAdjustment(BigDecimal outMigrationAdjustment) {
        this.outMigrationAdjustment = outMigrationAdjustment;
    }

    @Generated
    public boolean isOutlierReconciliation() {
        return this.outlierReconciliation;
    }

    @Generated
    public void setOutlierReconciliation(boolean outlierReconciliation) {
        this.outlierReconciliation = outlierReconciliation;
    }

    @Generated
    public BigDecimal getPassthroughAmountPlusMisc() {
        return this.passthroughAmountPlusMisc;
    }

    @Generated
    public void setPassthroughAmountPlusMisc(BigDecimal passthroughAmountPlusMisc) {
        this.passthroughAmountPlusMisc = passthroughAmountPlusMisc;
    }

    @Generated
    public BigDecimal getPerDiemDays() {
        return this.perDiemDays;
    }

    @Generated
    public void setPerDiemDays(BigDecimal perDiemDays) {
        this.perDiemDays = perDiemDays;
    }

    @Generated
    public String getRatexTable() {
        return this.ratexTable;
    }

    @Generated
    public void setRatexTable(String ratexTable) {
        this.ratexTable = ratexTable;
    }

    @Generated
    public BigDecimal getReadmissionAdjustmentAmount() {
        return this.readmissionAdjustmentAmount;
    }

    @Generated
    public void setReadmissionAdjustmentAmount(BigDecimal readmissionAdjustmentAmount) {
        this.readmissionAdjustmentAmount = readmissionAdjustmentAmount;
    }

    @Generated
    public int getRegularDays() {
        return this.regularDays;
    }

    @Generated
    public void setRegularDays(int regularDays) {
        this.regularDays = regularDays;
    }

    @Generated
    public BigDecimal getStandardAllowedAmount() {
        return this.standardAllowedAmount;
    }

    @Generated
    public void setStandardAllowedAmount(BigDecimal standardAllowedAmount) {
        this.standardAllowedAmount = standardAllowedAmount;
    }

    @Generated
    public String getStateCode() {
        return this.stateCode;
    }

    @Generated
    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    @Generated
    public BigDecimal getTransferAdjustment() {
        return this.transferAdjustment;
    }

    @Generated
    public void setTransferAdjustment(BigDecimal transferAdjustment) {
        this.transferAdjustment = transferAdjustment;
    }

    @Generated
    public BigDecimal getUncompensatedCareAmount() {
        return this.uncompensatedCareAmount;
    }

    @Generated
    public void setUncompensatedCareAmount(BigDecimal uncompensatedCareAmount) {
        this.uncompensatedCareAmount = uncompensatedCareAmount;
    }

    @Generated
    public BigDecimal getValueBasedPurchasingAdjustment() {
        return this.valueBasedPurchasingAdjustment;
    }

    @Generated
    public void setValueBasedPurchasingAdjustment(BigDecimal valueBasedPurchasingAdjustment) {
        this.valueBasedPurchasingAdjustment = valueBasedPurchasingAdjustment;
    }

    @Generated
    public BigDecimal getValueBasedPurchasingAdjustmentAmount() {
        return this.valueBasedPurchasingAdjustmentAmount;
    }

    @Generated
    public void setValueBasedPurchasingAdjustmentAmount(BigDecimal valueBasedPurchasingAdjustmentAmount) {
        this.valueBasedPurchasingAdjustmentAmount = valueBasedPurchasingAdjustmentAmount;
    }

    @Generated
    public String getValueBasedPurchasingParticipant() {
        return this.valueBasedPurchasingParticipant;
    }

    @Generated
    public void setValueBasedPurchasingParticipant(String valueBasedPurchasingParticipant) {
        this.valueBasedPurchasingParticipant = valueBasedPurchasingParticipant;
    }
}

