/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v1.DrgsTableEntry;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CalculateAdditionalHospitalSpecificPortion
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public boolean shouldExecute(IppsPricerContext calculationContext) {
        return !ArrayUtils.contains((Object[])new ResultCode[]{ResultCode.RC_65_PAY_CODE_NOT_ABC, ResultCode.RC_67_OUTLIER_LOS_GT_COVERED_DAYS, ResultCode.RC_68_INVALID_VBPF_IN_PSF}, (Object)calculationContext.getResultCode());
    }

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        if (calculationContext.isSchRebasedFy90ProviderType() || calculationContext.isEachProviderType() || calculationContext.isInvalidProviderType()) {
            this.calculateAdditionalHsp(calculationContext);
        }
    }

    protected void calculateAdditionalHsp(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        BigDecimal updateFactor = this.calculateUpdateFactor(calculationContext);
        BigDecimal hspRate = this.getHspRate(calculationContext, updateFactor);
        calculationContext.setHospitalSpecificPortionRate(hspRate);
        BigDecimal fspRate = this.getFspRate(calculationContext);
        BigDecimal adjustedFspRate = fspRate.add(calculationContext.getUncompensatedCareAmount());
        if (BigDecimalUtils.isGreaterThan(hspRate, adjustedFspRate)) {
            calculationContext.setOperatingHospitalSpecificPortionPart(hspRate.subtract(adjustedFspRate).setScale(9, RoundingMode.HALF_UP));
        }
        if (BigDecimalUtils.isGreaterThan(hspRate, adjustedFspRate) && StringUtils.equalsAny(providerData.getProviderType(), "14", "15")) {
            calculationContext.setOperatingHospitalSpecificPortionPart(hspRate.subtract(adjustedFspRate).multiply(new BigDecimal("0.75")).setScale(9, RoundingMode.HALF_UP));
        }
    }

    protected BigDecimal getFspRate(IppsPricerContext calculationContext) {
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        return calculationContext.getNationalPct().multiply(calculationContext.getNationalLabor().multiply(cbsaReference.getWageIndex()).add(calculationContext.getNationalNonLabor().multiply(calculationContext.getOperatingCostOfLivingAdjustment()))).multiply(calculationContext.getDrgWeightFraction()).multiply(calculationContext.getMidnightAdjustmentFactor()).multiply(BigDecimal.ONE.add(calculationContext.getOperatingIndirectMedicalEducation()).add(calculationContext.getOperatingDisproportionateShare().multiply(new BigDecimal(".25")))).add(calculationContext.getOperatingOutlierPart()).setScale(9, RoundingMode.HALF_UP);
    }

    protected BigDecimal getHspRate(IppsPricerContext calculationContext, BigDecimal updateFactor) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        DrgsTableEntry drgsTableEntry = calculationContext.getDrgsTableEntry();
        return providerData.getPpsFacilitySpecificRate().multiply(updateFactor.multiply(drgsTableEntry.getWeight())).setScale(9, RoundingMode.HALF_UP);
    }

    protected BigDecimal calculateUpdateFactor(IppsPricerContext calculationContext) {
        BigDecimal currentYearUpdateFactor = this.calculateCurrentYearUpdateFactor(calculationContext);
        return currentYearUpdateFactor.multiply(calculationContext.getPriorYearHospitalSpecificPortionUpdateFactor()).multiply(calculationContext.getBudgetNeutralBase()).multiply(calculationContext.getMidnightAdjustmentFactor()).setScale(5, RoundingMode.HALF_UP);
    }

    protected BigDecimal calculateCurrentYearUpdateFactor(IppsPricerContext calculationContext) {
        BigDecimal currentYearUpdateFactor = BigDecimal.ONE;
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (StringUtils.equals(providerData.getHospitalQualityIndicator(), "1") && StringUtils.isBlank(providerData.getEhrReductionIndicator())) {
            currentYearUpdateFactor = calculationContext.getHospitalSpecificPortionUpdateFactorWithQualityAndNoEhrReduction();
        }
        if (StringUtils.equals(providerData.getHospitalQualityIndicator(), "1") && StringUtils.equals(providerData.getEhrReductionIndicator(), "Y")) {
            currentYearUpdateFactor = calculationContext.getHospitalSpecificPortionUpdateFactorWithQualityAndEhrReduction();
        }
        if (!StringUtils.equals(providerData.getHospitalQualityIndicator(), "1") && StringUtils.isBlank(providerData.getEhrReductionIndicator())) {
            currentYearUpdateFactor = calculationContext.getHospitalSpecificPortionUpdateFactorWithNoQualityAndNoEhrReduction();
        }
        if (!StringUtils.equals(providerData.getHospitalQualityIndicator(), "1") && StringUtils.equals(providerData.getEhrReductionIndicator(), "Y")) {
            currentYearUpdateFactor = calculationContext.getHospitalSpecificPortionUpdateFactorWithNoQualityAndEhrReduction();
        }
        return currentYearUpdateFactor;
    }
}

