/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v1.DrgsTableEntry;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class CalculatePerDiemAmounts
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        BigDecimal perDiemDays = calculationContext.getPerDiemDays();
        IppsClaimData claimData = calculationContext.getClaimData();
        DrgsTableEntry drgsTableEntry = calculationContext.getDrgsTableEntry();
        if (calculationContext.isPayPerDiemDays() && BigDecimalUtils.isLessThan(perDiemDays, drgsTableEntry.getGeometricMeanLengthOfStay()) && !StringUtils.equals(claimData.getDiagnosisRelatedGroup(), "789")) {
            this.calculatePerDiemAmount(calculationContext);
            calculationContext.applyResultCode(ResultCode.RC_03_TRANSFER_PAID_PERDIEM_DAYS);
        }
        if (calculationContext.isPayTransferSpecialDrug() && BigDecimalUtils.isLessThan(perDiemDays, drgsTableEntry.getGeometricMeanLengthOfStay()) && !StringUtils.equals(claimData.getDiagnosisRelatedGroup(), "789")) {
            this.continueCalcPerDiemAmt(calculationContext);
        }
        if (calculationContext.isPayTransferNoCost()) {
            calculationContext.applyResultCode(ResultCode.RC_00_OK);
            if (BigDecimalUtils.isLessThan(perDiemDays, drgsTableEntry.getGeometricMeanLengthOfStay()) && !StringUtils.equals(claimData.getDiagnosisRelatedGroup(), "789")) {
                this.calculatePerDiemAmount(calculationContext);
                calculationContext.applyResultCode(ResultCode.RC_06_PAY_XFER_NO_COST);
            }
        }
    }

    protected void calculatePerDiemAmount(IppsPricerContext calculationContext) {
        calculationContext.setOperatingFederalSpecificPortionPart(calculationContext.getOperatingFederalSpecificPortionPart().multiply(calculationContext.getTransferAdjustment()).setScale(9, RoundingMode.HALF_UP));
        calculationContext.setCapitalFederalSpecificPortionPart(calculationContext.getCapitalFederalSpecificPortionPart().multiply(calculationContext.getTransferAdjustment()).setScale(9, RoundingMode.HALF_UP));
        calculationContext.setCapitalOldHoldHarmless(calculationContext.getCapitalOldHoldHarmless().multiply(calculationContext.getTransferAdjustment()).setScale(2, RoundingMode.HALF_UP));
        calculationContext.getAdditionalVariables().getAdditionalCapitalVariables().setCapitalOldHoldHarmlessRate(calculationContext.getCapitalOldHoldHarmless());
    }

    protected void continueCalcPerDiemAmt(IppsPricerContext calculationContext) {
        if (calculationContext.isDrgPostacute5050()) {
            calculationContext.applyResultCode(ResultCode.RC_10_POST_ACUTE_XFER);
            calculationContext.setOperatingFederalSpecificPortionPart(calculationContext.getOperatingFederalSpecificPortionPart().multiply(calculationContext.getDischargeFraction()).setScale(9, RoundingMode.HALF_UP));
        }
        if (calculationContext.isDrgPostacutePerDiem()) {
            calculationContext.applyResultCode(ResultCode.RC_12_POST_ACUTE_XFER_WITH_DRGS);
            calculationContext.setOperatingFederalSpecificPortionPart(calculationContext.getOperatingFederalSpecificPortionPart().multiply(calculationContext.getTransferAdjustment()).setScale(9, RoundingMode.HALF_UP));
        }
        if (calculationContext.isDrgPostacute5050()) {
            calculationContext.applyResultCode(ResultCode.RC_10_POST_ACUTE_XFER);
            calculationContext.setCapitalFederalSpecificPortionPart(calculationContext.getCapitalFederalSpecificPortionPart().multiply(calculationContext.getDischargeFraction()).setScale(9, RoundingMode.HALF_UP));
        }
        if (calculationContext.isDrgPostacutePerDiem()) {
            calculationContext.applyResultCode(ResultCode.RC_12_POST_ACUTE_XFER_WITH_DRGS);
            calculationContext.setCapitalFederalSpecificPortionPart(calculationContext.getCapitalFederalSpecificPortionPart().multiply(calculationContext.getTransferAdjustment()).setScale(9, RoundingMode.HALF_UP));
        }
        if (calculationContext.isDrgPostacute5050()) {
            calculationContext.applyResultCode(ResultCode.RC_10_POST_ACUTE_XFER);
            calculationContext.setCapitalOldHoldHarmless(calculationContext.getCapitalOldHoldHarmless().multiply(calculationContext.getDischargeFraction()).setScale(2, RoundingMode.HALF_UP));
            calculationContext.getAdditionalVariables().getAdditionalCapitalVariables().setCapitalOldHoldHarmlessRate(calculationContext.getCapitalOldHoldHarmless());
        }
        if (calculationContext.isDrgPostacutePerDiem()) {
            calculationContext.applyResultCode(ResultCode.RC_12_POST_ACUTE_XFER_WITH_DRGS);
            calculationContext.setCapitalOldHoldHarmless(calculationContext.getCapitalOldHoldHarmless().multiply(calculationContext.getTransferAdjustment()).setScale(2, RoundingMode.HALF_UP));
            calculationContext.getAdditionalVariables().getAdditionalCapitalVariables().setCapitalOldHoldHarmlessRate(calculationContext.getCapitalOldHoldHarmless());
        }
    }
}

