/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.totals;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;

public class CalculateHmoTotals
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public boolean shouldExecute(IppsPricerContext calculationContext) {
        return calculationContext.isWebPricerRequest();
    }

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (calculationContext.isHmoClaim()) {
            calculationContext.setPassthroughAmountPlusMisc(providerData.getPassThroughTotalAmount().subtract(providerData.getPassThroughAmountForOrganAcquisition().add(providerData.getPassThroughAmountForDirectMedicalEducation()).add(providerData.getPassThroughAmountForAllogenicStemCellAcquisition())).multiply(BigDecimal.valueOf(calculationContext.getClaimData().getLengthOfStay().intValue())));
            calculationContext.getPaymentData().setOperatingIndirectMedicalEducationAdjustment(BigDecimalUtils.ZERO);
        } else {
            calculationContext.setPassthroughAmountPlusMisc(providerData.getPassThroughTotalAmount().multiply(BigDecimal.valueOf(calculationContext.getClaimData().getLengthOfStay().intValue())));
        }
        ((IppsClaimPricingResponse)calculationContext.getOutput()).getAdditionalCalculationVariables().setPassthroughTotalPlusMisc(calculationContext.getPassthroughAmountPlusMisc());
    }
}

