/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.rules2021.assemble_variables;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.tables.ClaimCodeType;
import gov.cms.fiss.pricers.ipps.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;

public class DetermineNewCovid19TreatmentsAddOnPayment2021
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        boolean isNctap2021;
        IppsClaimData claimData;
        DataTables dataTables = calculationContext.getDataTables();
        boolean isNctapEarlyNov2020 = dataTables.codesMatch("COVID1", ClaimCodeType.PROC, (claimData = calculationContext.getClaimData()).getProcedureCodes()) && LocalDateUtils.inRange(calculationContext.getDischargeDate(), LocalDate.of(2020, 11, 2), LocalDate.of(2020, 11, 18));
        boolean isNctapRemainder2020 = (dataTables.codesMatch("COVID1", ClaimCodeType.PROC, claimData.getProcedureCodes()) || dataTables.codesMatch("COVID2", ClaimCodeType.PROC, claimData.getProcedureCodes())) && LocalDateUtils.inRange(calculationContext.getDischargeDate(), LocalDate.of(2020, 11, 19), LocalDate.of(2020, 12, 31));
        boolean bl = isNctap2021 = (dataTables.codesMatch("COVID1", ClaimCodeType.PROC, claimData.getProcedureCodes()) || dataTables.codesMatch("COVID3", ClaimCodeType.PROC, claimData.getProcedureCodes())) && LocalDateUtils.isAfterOrEqual(calculationContext.getDischargeDate(), LocalDate.of(2021, 1, 1));
        if (dataTables.codesMatch("COVID2", ClaimCodeType.DIAG, claimData.getDiagnosisCodes()) && !dataTables.codesMatch("COVID1", ClaimCodeType.COND, claimData.getConditionCodes()) && (isNctapEarlyNov2020 || isNctapRemainder2020 || isNctap2021)) {
            this.newCovid19TreatmentsAddOnPaymentValue(calculationContext);
        }
        calculationContext.setOperatingBaseDrgPayment(calculationContext.getOperatingBaseDrgPayment().add(calculationContext.getNewCovid19TreatmentsAddOnPayment()).setScale(2, RoundingMode.HALF_UP));
        calculationContext.setNewTechAddOnPayment(calculationContext.getNewTechAddOnPayment().add(calculationContext.getNewCovid19TreatmentsAddOnPayment()).setScale(2, RoundingMode.HALF_UP));
    }

    protected void newCovid19TreatmentsAddOnPaymentValue(IppsPricerContext calculationContext) {
        BigDecimal lesserNCTAP1 = calculationContext.getOperatingDollarThreshold().multiply(new BigDecimal("0.65"));
        BigDecimal lesserNCTAP2 = calculationContext.getOperatingBillCosts().subtract(calculationContext.getOperatingCostOutlier().subtract(calculationContext.getOperatingDollarThreshold())).multiply(new BigDecimal("0.65"));
        if (BigDecimalUtils.isGreaterThan(calculationContext.getOperatingBillCosts(), calculationContext.getOperatingCostOutlier().subtract(calculationContext.getOperatingDollarThreshold()))) {
            if (BigDecimalUtils.isLessThan(lesserNCTAP1, lesserNCTAP2)) {
                calculationContext.setNewCovid19TreatmentsAddOnPayment(lesserNCTAP1);
            } else {
                calculationContext.setNewCovid19TreatmentsAddOnPayment(lesserNCTAP2);
            }
        }
    }
}

