/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.wage_index;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;

public class ValidateSpecialWageIndex
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (calculationContext.isCbsaSpecialPaymentIndicatorSpecial() && (providerData.getSpecialWageIndex() == null || BigDecimalUtils.isZero(providerData.getSpecialWageIndex()))) {
            calculationContext.applyResultCode(ResultCode.RC_52_INVALID_WAGE_INDEX);
            return;
        }
        if (calculationContext.isCbsaSpecialPaymentIndicatorSpecial() && !LocalDateUtils.inRange(calculationContext.getEffectiveDate(), calculationContext.fiscalYearStart(), calculationContext.fiscalYearEnd())) {
            calculationContext.applyResultCode(ResultCode.RC_52_INVALID_WAGE_INDEX);
            return;
        }
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        if (calculationContext.isCbsaSpecialPaymentIndicatorSpecial()) {
            cbsaReference.setCbsa("SPEC*");
            cbsaReference.setEffectiveDate(calculationContext.getEffectiveDate());
            cbsaReference.setWageIndex(providerData.getSpecialWageIndex());
        }
    }
}

