// Generated by delombok at Thu Nov 13 21:39:03 UTC 2025
package gov.cms.fiss.pricers.ipps.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipps.api.v1.DrgsTableEntry;
import gov.cms.fiss.pricers.ipps.api.v2.AdditionalCalculationVariableData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.api.v2.IppsPaymentData;
import gov.cms.fiss.pricers.ipps.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.ipps.core.tables.DataTables;
import gov.cms.fiss.pricers.ipps.core.tables.RuralFloorTableEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class IppsPricerContext extends CalculationContext<IppsClaimPricingRequest, IppsClaimPricingResponse> {
  // Calculation constants
  public static final String INDIAN_DEFAULT_CBSA_LOCATION = "99";
  public static final String INDIAN_PROVIDER_TYPE = "08";
  public static final String INDIAN_SPECIAL_STATE_CODE = "02";
  public static final String INDIAN_SPECIAL_CBSA_LOCATION = "98";
  public static final String CODE_COVID1 = "COVID1";
  public static final String CODE_COVID2 = "COVID2";
  public static final String CODE_COVID3 = "COVID3";
  public static final String SPECIAL_WAGE_INDEX_CBSA = "SPEC*";
  public static final BigDecimal DEFAULT_NEW_TECH_PERCENT = new BigDecimal("0.5");
  public static final String ZEROS = "00000";
  // Web pricer parameters
  public static final String HMO_FLAG_KEY = "hmoClaim";
  public static final String COT_FLAG_KEY = "cotClaim";
  private static final String DRG_POSTACUTE_50_50 = "YY";
  private static final String DRG_POSTACUTE_PER_DIEM = "Y";
  private static final BigDecimal DEFAULT_OPER_DSH_LOW_RANGE_MIN = new BigDecimal("0.1499");
  private static final BigDecimal DEFAULT_OPER_DSH_HIGH_RANGE_MIN = new BigDecimal("0.2019");
  private static final BigDecimal DEFAULT_OPER_DSH_LOW_RANGE_MAX = new BigDecimal("0.2020");
  private static final BigDecimal DEFAULT_OPER_DSH_LIMIT = new BigDecimal("0.1200");
  private static final BigDecimal DEFAULT_OPER_DSH_SUBTRAHEND_LOW = new BigDecimal("0.15");
  private static final BigDecimal DEFAULT_OPER_DSH_SUBTRAHEND_HIGH = new BigDecimal("0.202");
  private static final BigDecimal DEFAULT_OPER_DSH_MULTIPLICAND_LOW = new BigDecimal("0.65");
  private static final BigDecimal DEFAULT_OPER_DSH_MULTIPLICAND_HIGH = new BigDecimal("0.825");
  private static final BigDecimal DEFAULT_OPER_DSH_ADDEND_LOW = new BigDecimal("0.025");
  private static final BigDecimal DEFAULT_OPER_DSH_ADDEND_HIGH = new BigDecimal(".0588");
  private static final String[] STATE_CODES_PUERTO_RICO = new String[] {"40", "84"};
  private static final String[] STATE_CODES_READ_INVALID = new String[] {"40", "84"};
  private static final String[] STATE_CODES_VALUE_BASED_PURCHASING_INVALID = new String[] {"21", "40", "80", "84"};
  // Per-Year constants
  private static final BigDecimal DEFAULT_CAPITAL_BASE_RATE = new BigDecimal("459.41");
  private static final BigDecimal DEFAULT_COST_THRESHOLD_BASE = new BigDecimal("25743.0");
  private static final BigDecimal DEFAULT_LABOR_PCT_WI_GT_ONE = new BigDecimal("0.683");
  private static final BigDecimal DEFAULT_NON_LABOR_PCT_WI_GT_ONE = new BigDecimal("0.317");
  private static final BigDecimal DEFAULT_LABOR_PCT_WI_LTEQ_ONE = new BigDecimal("0.62");
  private static final BigDecimal DEFAULT_NON_LABOR_PCT_WI_LTEQ_ONE = new BigDecimal("0.38");
  private static final BigDecimal DEFAULT_MARKET_BASKET_RATIO_EHR_FULL = new BigDecimal("1.02193093");
  private static final BigDecimal DEFAULT_MARKET_BASKET_RATIO_EHR_QUALIFIED_FULL = new BigDecimal("1.022092433");
  private static final BigDecimal DEFAULT_MARKET_BASKET_RATIO_EHR_FULL_PR = BigDecimal.ZERO;
  private static final BigDecimal DEFAULT_OPER_HSP_BUDGET_NEUTRAL_BASE = new BigDecimal("0.99719").setScale(6, RoundingMode.HALF_UP);
  private static final BigDecimal DEFAULT_OPER_HSP_UPDATE_NO_QUALITY_EHR = new BigDecimal("0.9845").setScale(6, RoundingMode.HALF_UP);
  private static final BigDecimal DEFAULT_OPER_HSP_UPDATE_NO_QUALITY_NO_EHR = new BigDecimal("1.00625").setScale(6, RoundingMode.HALF_UP);
  private static final BigDecimal DEFAULT_OPER_HSP_UPDATE_QUALITY_EHR = new BigDecimal("0.99175").setScale(6, RoundingMode.HALF_UP);
  private static final BigDecimal DEFAULT_OPER_HSP_UPDATE_QUALITY_NO_EHR = new BigDecimal("1.0135").setScale(6, RoundingMode.HALF_UP);
  private static final BigDecimal DEFAULT_OPER_HSP_UPDATE_NO_EHR_PR = BigDecimal.ZERO;
  private static final BigDecimal DEFAULT_OPER_HSP_UPDATE_EHR_PR = BigDecimal.ZERO;
  private static final BigDecimal DEFAULT_OPERATING_BASE_RATE = new BigDecimal("5646.08");
  private static final BigDecimal DEFAULT_WAGE_INDEX_QUARTILE_LIMIT = new BigDecimal("0.8457");
  private static final BigDecimal DEFAULT_WAGE_INDEX_PCT_REDUCTION = new BigDecimal("-0.05");
  private static final BigDecimal DEFAULT_WAGE_INDEX_PCT_ADJ = new BigDecimal("0.95");
  // Other constants
  private static final String[] BURN_RELATED_DRGS = new String[] {"927", "928", "929", "933", "934", "935"};
  private static final String[] EACH_PROVIDER_TYPES = {"21", "22"};
  private static final String[] INVALID_PROVIDER_TYPES = {"14", "15"};
  private static final String[] SCH_REBASED_FY90_PROVIDER_TYPES = {"16", "17"};
  private static final String[] VALID_REVIEW_CODES = {"00", "03", "06", "07", "09", "11"};
  // Lookup content
  @JsonIgnore
  private final DataTables dataTables;
  private final CbsaReference cbsaReference = new CbsaReference();
  // State variables
  private BigDecimal baseDrgPayment;
  private BigDecimal bundledAdjustmentPayment = BigDecimal.ZERO;
  private BigDecimal capitalCostOfLivingAdjustment = BigDecimal.ONE;
  private BigDecimal capital2BFederalSpecificPortionPart = BigDecimal.ZERO;
  private BigDecimal capital2BOutlierPart = BigDecimal.ZERO;
  private String capital2PayCode;
  private BigDecimal capitalCostOutlier = BigDecimal.ZERO;
  private BigDecimal capitalOperatingCostToChargeRatio = BigDecimalUtils.ZERO;
  private BigDecimal capitalDisproportionateShareHospital = BigDecimal.ZERO;
  private BigDecimal capitalDisproportionateShareHospitalAdjustment = BigDecimalUtils.ZERO;
  private BigDecimal capitalExceptionPaymentRate = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal capitalFederalRate = BigDecimal.ZERO;
  private BigDecimal capitalFederalSpecificPortion = BigDecimalUtils.ZERO;
  private BigDecimal capitalFederalSpecificPortionPart = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal capitalFederalSpecificPortionPct = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal capitalGeographicAdjFactor = BigDecimal.ZERO;
  private BigDecimal capitalIndirectMedicalEducationAdj = BigDecimal.ZERO;
  private BigDecimal capitalIndirectMedicalEducation = new BigDecimal("1.0");
  private BigDecimal capitalOutlierPart = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal capitalPaycodePct1 = BigDecimal.ONE;
  private BigDecimal capitalOldHoldHarmless = BigDecimal.ZERO;
  private BigDecimal capitalOutlierCost = BigDecimal.ZERO;
  private BigDecimal capitalOutlierCostPart = BigDecimalUtils.ZERO;
  private BigDecimal capitalSch = BigDecimal.ZERO;
  private BigDecimal capitalShareDollarThreshold = BigDecimalUtils.ZERO;
  private BigDecimal capitalTotalPayment = BigDecimal.ZERO;
  /**
   * Corresponds to {@code HOLD-PROV-CBSA PIC X(5)} from the COBOL source.
   */
  private String cbsaLocation;
  private CbsaWageIndexEntry cbsaWageIndexEntry;
  private BigDecimal costOutlierPct = BigDecimal.ZERO;
  private BigDecimal costThreshold = BigDecimalUtils.ZERO;
  @FixedValue
  private BigDecimal covidAdjustmentFactor = BigDecimal.ONE;
  private LocalDate dischargeDate;
  private BigDecimal dischargeFraction = BigDecimal.ZERO;
  private DrgsTableEntry drgsTableEntry = DrgsTableEntry.ZERO_WEIGHT;
  private BigDecimal drgWeightFraction = BigDecimal.ZERO;
  private LocalDate effectiveDate;
  private BigDecimal electronicHealthRecordAdjustmentAmt = BigDecimal.ZERO;
  private boolean hmoClaim;
  /**
   * Corresponds to {@code PPS-PC-COT-FLAG PIC X(01)} from the COBOL source.
   */
  private boolean costOutlierThresholdClaim;
  private BigDecimal hospitalAcquiredConditionAmount = BigDecimalUtils.ZERO;
  private String hrrParticipantIndicator;
  private BigDecimal hospitalReadmissionReductionAdjustment = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal isletIsolationPaymentAddOn = BigDecimal.ZERO;
  private BigDecimal lowVolumePayment = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal midnightAdjustmentFactor = new BigDecimal("1.0");
  @FixedValue
  private BigDecimal nationalPct = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal nationalLabor = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal nationalLaborPct = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal nationalNonLabor = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal nationalNonLaborPct = BigDecimal.ZERO;
  private BigDecimal newTechAddOnPayment = BigDecimal.ZERO;
  private BigDecimal newCovid19TreatmentsAddOnPayment = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal noCostProductAdjustmentFactor = BigDecimal.ONE;
  private BigDecimal operatingBaseDrgPayment = BigDecimal.ZERO;
  private BigDecimal operatingBillCosts = BigDecimalUtils.ZERO;
  private BigDecimal operatingCostToChargeRatio = BigDecimalUtils.ZERO;
  private BigDecimal operatingCostOfLivingAdjustment = BigDecimal.ONE;
  private BigDecimal operatingCostOutlier = BigDecimalUtils.ZERO;
  private BigDecimal operatingDisproportionateShare = BigDecimalUtils.ZERO;
  private BigDecimal operatingDollarThreshold = BigDecimal.ZERO;
  private BigDecimal operatingChargeThreshold = BigDecimal.ZERO;
  private BigDecimal operatingFederalSpecificPortionPart = BigDecimalUtils.ZERO;
  @FixedValue
  private BigDecimal operatingFederalSpecificPortionPct = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal operatingHospitalSpecificPortionPct = BigDecimalUtils.ZERO;
  private BigDecimal operatingHospitalSpecificPortionPart = BigDecimalUtils.ZERO;
  private BigDecimal operatingOutlierCostPart = BigDecimalUtils.ZERO;
  private BigDecimal operatingOutlierPart = BigDecimalUtils.ZERO;
  private BigDecimal operatingShareDollarThreshold = BigDecimalUtils.ZERO;
  private BigDecimal operatingIndirectMedicalEducation = new BigDecimal("1.0");
  /**
   * Corresponds to {@code H-HSP-RATE PIC 9(08)V9(09) } from the COBOL source.
   */
  private BigDecimal hospitalSpecificPortionRate = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-CAPI-HSP-PART PIC 9(06)V9(09)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal capitalHospitalSpecificPortionPart = BigDecimal.ZERO;
  // this value is never set
  /**
   * Corresponds to {@code H-CAPI-HSP-PCT PIC 9(01)V9(02)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal capitalHospitalSpecificPortionPercentage = BigDecimal.ZERO;
  // this value is never set
  /**
   * Corresponds to {@code PPS-REG-PCT PIC 9(01)V9(02)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal regularPercentage = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-CAPI-OLD-HARMLESS PIC 9(09)V9(02)} from the COBOL source.
   */
  private BigDecimal capitalOldHoldHarmlessRate = BigDecimal.ZERO;
  private boolean outlierAdjustmentEnabled = false;
  private BigDecimal outMigrationAdjustment = BigDecimal.ZERO;
  private boolean outlierReconciliation;
  private BigDecimal passthroughAmountPlusMisc = BigDecimalUtils.ZERO;
  private BigDecimal perDiemDays;
  private String ratexTable = "tab1";
  private BigDecimal readmissionAdjustmentAmount = BigDecimal.ZERO;
  private int regularDays = 0;
  private BigDecimal standardAllowedAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-CBSA-RURAL-STATE PIC X(2)} from the COBOL source.
   */
  private String stateCode;
  private BigDecimal transferAdjustment = BigDecimal.ZERO;
  private BigDecimal uncompensatedCareAmount = BigDecimal.ZERO;
  private BigDecimal valueBasedPurchasingAdjustment = BigDecimal.ZERO;
  private BigDecimal valueBasedPurchasingAdjustmentAmount = BigDecimal.ZERO;
  private String valueBasedPurchasingParticipant;

  protected IppsPricerContext(IppsClaimPricingRequest input, IppsClaimPricingResponse output, DataTables dataTables) {
    super(input, output);
    this.dataTables = dataTables;
    initializeContext();
  }

  protected void initializeContext() {
    final IppsClaimPricingResponse output = getOutput();
    output.setCalculationVersion(getCalculationVersion());
    final IppsPaymentData paymentData = new IppsPaymentData();
    paymentData.setTotalPayment(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
    paymentData.setFinalWageIndex(BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP));
    output.setPaymentData(paymentData);
    output.setReturnCodeData(ResultCode.RC_00_OK.toReturnCodeData());
    final InpatientProviderData providerData = getProviderData();
    output.setAdditionalCalculationVariables(new AdditionalCalculationVariableData());
    dischargeDate = getClaimData().getDischargeDate();
    effectiveDate = providerData.getEffectiveDate();
  }

  public abstract String getCalculationVersion();

  // Access to request content
  @JsonIgnore
  public IppsClaimData getClaimData() {
    return getInput().getClaimData();
  }

  @JsonIgnore
  public InpatientProviderData getProviderData() {
    return getInput().getProviderData();
  }

  @JsonIgnore
  public IppsPaymentData getPaymentData() {
    return getOutput().getPaymentData();
  }

  @JsonIgnore
  public AdditionalCalculationVariableData getAdditionalVariables() {
    return getOutput().getAdditionalCalculationVariables();
  }

  // Calculation data
  public void applyResultCode(ResultCode resultCode) {
    getOutput().setReturnCodeData(resultCode.toReturnCodeData());
  }

  public void adjustResultCodeForOutliers() {
    final ReturnCodeData returnCodeData = getOutput().getReturnCodeData();
    final int code = Integer.parseInt(returnCodeData.getCode());
    returnCodeData.setCode(String.valueOf(code + 30));
    returnCodeData.setDescription(returnCodeData.getDescription() + " (Outlier)");
  }

  public BigDecimal calculateDefaultOperatingDisproportionateShare() {
    final InpatientProviderData providerData = getProviderData();
    return providerData.getSupplementalSecurityIncomeRatio().add(providerData.getMedicaidRatio());
  }

  /**
   * Clears context-internal state if an error is encountered in processing the claim, or if
   * switching to the outlier pricing pass.
   */
  public void clearContextState() {
    bundledAdjustmentPayment = BigDecimal.ZERO;
    capital2BFederalSpecificPortionPart = BigDecimal.ZERO;
    capital2PayCode = null;
    capital2BOutlierPart = BigDecimal.ZERO;
    capitalOperatingCostToChargeRatio = BigDecimal.ZERO;
    capitalCostOutlier = BigDecimal.ZERO;
    capitalCostOfLivingAdjustment = BigDecimal.ZERO;
    capitalDisproportionateShareHospitalAdjustment = BigDecimal.ZERO;
    capitalExceptionPaymentRate = BigDecimal.ZERO;
    capitalFederalRate = BigDecimal.ZERO;
    capitalFederalSpecificPortion = BigDecimal.ZERO;
    capitalFederalSpecificPortionPart = BigDecimal.ZERO;
    capitalGeographicAdjFactor = BigDecimal.ZERO;
    capitalHospitalSpecificPortionPart = BigDecimal.ZERO;
    capitalIndirectMedicalEducationAdj = BigDecimal.ZERO;
    capitalOldHoldHarmless = BigDecimal.ZERO;
    capitalOutlierCostPart = BigDecimal.ZERO;
    capitalOutlierPart = BigDecimal.ZERO;
    capitalShareDollarThreshold = BigDecimal.ZERO;
    capitalTotalPayment = BigDecimal.ZERO;
    costThreshold = BigDecimal.ZERO;
    dischargeFraction = BigDecimal.ZERO;
    drgsTableEntry = DrgsTableEntry.ZERO_WEIGHT;
    drgWeightFraction = BigDecimal.ZERO;
    electronicHealthRecordAdjustmentAmt = BigDecimal.ZERO;
    hrrParticipantIndicator = null;
    hospitalReadmissionReductionAdjustment = BigDecimal.ZERO;
    isletIsolationPaymentAddOn = BigDecimal.ZERO;
    nationalLaborPct = BigDecimal.ZERO;
    nationalNonLaborPct = BigDecimal.ZERO;
    nationalPct = BigDecimal.ZERO;
    newTechAddOnPayment = BigDecimal.ZERO;
    newCovid19TreatmentsAddOnPayment = BigDecimal.ZERO;
    operatingBaseDrgPayment = BigDecimal.ZERO;
    operatingChargeThreshold = BigDecimal.ZERO;
    operatingCostToChargeRatio = BigDecimal.ZERO;
    operatingDisproportionateShare = BigDecimal.ZERO;
    operatingFederalSpecificPortionPart = BigDecimal.ZERO;
    operatingFederalSpecificPortionPct = BigDecimal.ZERO;
    operatingHospitalSpecificPortionPart = BigDecimal.ZERO;
    operatingIndirectMedicalEducation = BigDecimal.ZERO;
    operatingOutlierCostPart = BigDecimal.ZERO;
    operatingOutlierPart = BigDecimal.ZERO;
    operatingShareDollarThreshold = BigDecimal.ZERO;
    perDiemDays = BigDecimal.ZERO;
    readmissionAdjustmentAmount = BigDecimal.ZERO;
    regularDays = 0;
    standardAllowedAmount = BigDecimal.ZERO;
    valueBasedPurchasingAdjustment = BigDecimal.ZERO;
    valueBasedPurchasingAdjustmentAmount = BigDecimal.ZERO;
    valueBasedPurchasingParticipant = null;
    clearAdditionalVariablesContextState();
  }

  public void clearAdditionalVariablesContextState() {
    getAdditionalVariables().getAdditionalCapitalVariables().setCapitalFederalSpecificPortionPercent(BigDecimal.ZERO);
    getAdditionalVariables().getAdditionalCapitalVariables().setCapitalCostOutlier(BigDecimal.ZERO);
    getAdditionalVariables().getAdditionalOperatingVariables().setOperatingHospitalSpecificPortionPart(BigDecimal.ZERO);
    getAdditionalVariables().setHospitalSpecificPortionRate(BigDecimal.ZERO);
  }

  public LocalDate fiscalYearEnd() {
    return LocalDateUtils.fiscalYearEnd(effectiveDate);
  }

  public LocalDate fiscalYearStart() {
    return LocalDateUtils.fiscalYearStart(effectiveDate);
  }

  public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa) {
    return dataTables.getCbsaWageIndexEntry(cbsa, effectiveDate);
  }

  public String getProviderState() {
    return StringUtils.left(getProviderData().getProviderCcn(), 2);
  }

  public RuralFloorTableEntry getRuralFloor(String cbsa) {
    return dataTables.getRuralFloorIndex(cbsa);
  }

  public ResultCode getResultCode() {
    final String code = getOutput().getReturnCodeData().getCode();
    return ResultCode.fromCode(Integer.parseInt(code));
  }

  public boolean isErrorResult() {
    final String code = getOutput().getReturnCodeData().getCode();
    return ResultCode.isErrorCode(Integer.parseInt(code));
  }

  /**
   * Discards calculation data in the event of error return codes.
   */
  public void zeroResponse() {
    final IppsPaymentData paymentData = getPaymentData();
    paymentData.setOperatingFederalSpecificPortionPart(BigDecimal.ZERO);
    paymentData.setOperatingHospitalSpecificPortionPart(BigDecimal.ZERO);
    paymentData.setOperatingIndirectMedicalEducationAdjustment(BigDecimal.ZERO);
    paymentData.setOperatingOutlierPaymentPart(BigDecimal.ZERO);
    paymentData.setOperatingDisproportionateShareHospitalAdjustment(BigDecimal.ZERO);
    paymentData.setOutlierDays(0);
    paymentData.setRegularDaysUsed(0);
    paymentData.setLifetimeReserveDaysUsed(0);
    paymentData.setTotalPayment(BigDecimal.ZERO);
    clearContextState();
  }

  // Per-year value retrieval
  public BigDecimal getBudgetNeutralBase() {
    return DEFAULT_OPER_HSP_BUDGET_NEUTRAL_BASE;
  }

  public String[] getBurnRelatedDrgs() {
    return BURN_RELATED_DRGS;
  }

  @FixedValue
  public BigDecimal getCapitalLargeUrbanFactor() {
    return BigDecimal.ONE;
  }

  @FixedValue
  public BigDecimal getCapitalBaseRate() {
    return DEFAULT_CAPITAL_BASE_RATE;
  }

  @FixedValue
  public BigDecimal getCostThresholdBase() {
    return DEFAULT_COST_THRESHOLD_BASE;
  }

  @FixedValue
  public BigDecimal getNationalLaborPctWageIndexGtOne() {
    return DEFAULT_LABOR_PCT_WI_GT_ONE;
  }

  @FixedValue
  public BigDecimal getNationalNonLaborPctWageIndexGtOne() {
    return DEFAULT_NON_LABOR_PCT_WI_GT_ONE;
  }

  @FixedValue
  public BigDecimal getNationalLaborPctWageIndexLtEqOne() {
    return DEFAULT_LABOR_PCT_WI_LTEQ_ONE;
  }

  @FixedValue
  public BigDecimal getNationalNonLaborPctWageIndexLtEqOne() {
    return DEFAULT_NON_LABOR_PCT_WI_LTEQ_ONE;
  }

  @FixedValue
  public BigDecimal getCovidAdjustmentFactorValue() {
    return BigDecimal.ONE;
  }

  @FixedValue
  public BigDecimal getNoCostProductAdjustmentFactorValue() {
    return BigDecimal.ONE;
  }

  public BigDecimal getFederalSpecificPortionPercent() {
    return BigDecimal.ONE;
  }

  public BigDecimal getHospitalSpecificPortionUpdateFactorWithQualityAndNoEhrReduction() {
    return DEFAULT_OPER_HSP_UPDATE_QUALITY_NO_EHR;
  }

  public BigDecimal getHospitalSpecificPortionUpdateFactorWithNoQualityAndNoEhrReduction() {
    return DEFAULT_OPER_HSP_UPDATE_NO_QUALITY_NO_EHR;
  }

  public BigDecimal getHospitalSpecificPortionUpdateFactorWithQualityAndEhrReduction() {
    return DEFAULT_OPER_HSP_UPDATE_QUALITY_EHR;
  }

  public BigDecimal getHospitalSpecificPortionUpdateFactorWithNoQualityAndEhrReduction() {
    return DEFAULT_OPER_HSP_UPDATE_NO_QUALITY_EHR;
  }

  public BigDecimal getHospitalSpecificPortionUpdateFactorWithNoEhrReductionPuertoRico() {
    return DEFAULT_OPER_HSP_UPDATE_NO_EHR_PR;
  }

  public BigDecimal getHospitalSpecificPortionUpdateFactorWithEhrReductionPuertoRico() {
    return DEFAULT_OPER_HSP_UPDATE_EHR_PR;
  }

  public BigDecimal getMarketBasketRatioEhrFull() {
    return DEFAULT_MARKET_BASKET_RATIO_EHR_FULL;
  }

  public BigDecimal getMarketBasketRatioEhrQualifiedFull() {
    return DEFAULT_MARKET_BASKET_RATIO_EHR_QUALIFIED_FULL;
  }

  public BigDecimal getMarketBasketRatioEhrFullPuertoRico() {
    return DEFAULT_MARKET_BASKET_RATIO_EHR_FULL_PR;
  }

  public BigDecimal getOperatingDisproportionateShareLowRangeMax() {
    return DEFAULT_OPER_DSH_LOW_RANGE_MAX;
  }

  public BigDecimal getOperatingDisproportionateShareLowRangeMin() {
    return DEFAULT_OPER_DSH_LOW_RANGE_MIN;
  }

  public BigDecimal getOperatingDisproportionateShareHighRangeMin() {
    return DEFAULT_OPER_DSH_HIGH_RANGE_MIN;
  }

  public BigDecimal getOperatingDisproportionateShareLimit() {
    return DEFAULT_OPER_DSH_LIMIT;
  }

  public BigDecimal getOperatingDisproportionateShareAddendLow() {
    return DEFAULT_OPER_DSH_ADDEND_LOW;
  }

  public BigDecimal getOperatingDisproportionateShareAddendHigh() {
    return DEFAULT_OPER_DSH_ADDEND_HIGH;
  }

  public BigDecimal getOperatingDisproportionateShareMultiplicandLow() {
    return DEFAULT_OPER_DSH_MULTIPLICAND_LOW;
  }

  public BigDecimal getOperatingDisproportionateShareMultiplicandHigh() {
    return DEFAULT_OPER_DSH_MULTIPLICAND_HIGH;
  }

  public BigDecimal getOperatingDisproportionateShareSubtrahendLow() {
    return DEFAULT_OPER_DSH_SUBTRAHEND_LOW;
  }

  public BigDecimal getOperatingDisproportionateShareSubtrahendHigh() {
    return DEFAULT_OPER_DSH_SUBTRAHEND_HIGH;
  }

  @FixedValue
  public BigDecimal getOperatingBaseRate() {
    return DEFAULT_OPERATING_BASE_RATE;
  }

  public BigDecimal getPriorYearHospitalSpecificPortionUpdateFactor() {
    return BigDecimal.ONE;
  }

  protected String[] getValidReviewCodes() {
    return VALID_REVIEW_CODES;
  }

  public BigDecimal getWageIndexQuartileLimit() {
    return DEFAULT_WAGE_INDEX_QUARTILE_LIMIT;
  }

  public BigDecimal getWageIndexPctReduction() {
    return DEFAULT_WAGE_INDEX_PCT_REDUCTION;
  }

  public BigDecimal getWageIndexPctAdj() {
    return DEFAULT_WAGE_INDEX_PCT_ADJ;
  }

  // Billing record business methods
  /**
   * Get the provided demo codes.
   */
  public List<String> getProvidedDemoCodes() {
    final IppsClaimData claimData = getClaimData();
    final List<String> demoCodeList = claimData.getDemoCodes();
    if (null != demoCodeList && !demoCodeList.isEmpty()) {
      return demoCodeList;
    }
    return null;
  }

  /**
   * Get the provided NDCs.
   */
  public List<String> getProvidedNationalDrugCodes() {
    final IppsClaimData claimData = getClaimData();
    final List<String> nationalDrugCodeList = claimData.getNationalDrugCodes();
    if (null != nationalDrugCodeList && !nationalDrugCodeList.isEmpty()) {
      return nationalDrugCodeList;
    }
    return null;
  }

  public boolean isInvalidReviewCode() {
    return !ArrayUtils.contains(getValidReviewCodes(), getClaimData().getReviewCode());
  }

  public boolean isPayPerDiemDays() {
    return StringUtils.equals(getClaimData().getReviewCode(), "03");
  }

  public boolean isPayTransferNoCost() {
    return StringUtils.equals(getClaimData().getReviewCode(), "06");
  }

  public boolean isPayTransferSpecialDrug() {
    return ArrayUtils.contains(new String[] {"09", "11"}, getClaimData().getReviewCode());
  }

  public boolean isPayTransferSpecialDrugNoCost() {
    return StringUtils.equals(getClaimData().getReviewCode(), "11");
  }

  public boolean isPayWithoutCost() {
    return StringUtils.equals(getClaimData().getReviewCode(), "07");
  }

  // Request CBSA business methods
  public boolean isCbsaSpecialPaymentIndicatorEmpty() {
    final String specialPaymentIndicator = getProviderData().getSpecialPaymentIndicator();
    return StringUtils.isEmpty(specialPaymentIndicator);
  }

  public boolean isCbsaSpecialPaymentIndicatorReclassified() {
    return !isCbsaSpecialPaymentIndicatorEmpty() && StringUtils.equals(getProviderData().getSpecialPaymentIndicator(), "Y");
  }

  public boolean isCbsaSpecialPaymentIndicatorDual() {
    return !isCbsaSpecialPaymentIndicatorEmpty() && StringUtils.equals(getProviderData().getSpecialPaymentIndicator(), "D");
  }

  public boolean isCbsaSpecialPaymentIndicatorSpecial() {
    return !isCbsaSpecialPaymentIndicatorEmpty() && StringUtils.equalsAny(getProviderData().getSpecialPaymentIndicator(), "1", "2");
  }

  // DRG business methods
  public void initializeDrgEntry() {
    drgsTableEntry = dataTables.getDrgsEntry(getClaimData().getDiagnosisRelatedGroup(), getEffectiveDate());
  }

  public boolean isDrgPostacute5050() {
    return DRG_POSTACUTE_50_50.equals(drgsTableEntry.getPostAcuteCare() + drgsTableEntry.getSpecialPaymentPostAcuteCare());
  }

  public boolean isDrgPostacutePerDiem() {
    return DRG_POSTACUTE_PER_DIEM.equals(drgsTableEntry.getPostAcuteCare() + drgsTableEntry.getSpecialPaymentPostAcuteCare());
  }

  // Request MSA business methods
  public String getMidnightAdjustmentGeolocation() {
    return getInput().getClaimData().getMidnightAdjustmentGeolocation();
  }

  public int getGeolocationAsInt() {
    return NumberUtils.toInt(getMidnightAdjustmentGeolocation(), -1);
  }

  // Provider record business methods
  public boolean isEachProviderType() {
    return StringUtils.equalsAny(getProviderData().getProviderType(), EACH_PROVIDER_TYPES);
  }

  public boolean isInvalidProviderType() {
    return StringUtils.equalsAny(getProviderData().getProviderType(), INVALID_PROVIDER_TYPES);
  }

  public boolean isStatePuertoRico() {
    return StringUtils.equalsAny(getProviderState(), STATE_CODES_PUERTO_RICO);
  }

  public boolean isReadInvalidState() {
    return StringUtils.equalsAny(getProviderState(), STATE_CODES_READ_INVALID);
  }

  public boolean isSchRebasedFy90ProviderType() {
    return StringUtils.equalsAny(getProviderData().getProviderType(), SCH_REBASED_FY90_PROVIDER_TYPES);
  }

  public LocalDate getTerminationDate() {
    return getProviderData().getTerminationDate();
  }

  public boolean isValueBasedPurchasingInvalidState() {
    return StringUtils.equalsAny(getProviderState(), STATE_CODES_VALUE_BASED_PURCHASING_INVALID);
  }

  public boolean isWaiverEnabled() {
    return StringUtils.equals(getProviderData().getWaiverIndicator(), "Y");
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DataTables getDataTables() {
    return this.dataTables;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CbsaReference getCbsaReference() {
    return this.cbsaReference;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBaseDrgPayment() {
    return this.baseDrgPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBaseDrgPayment(final BigDecimal baseDrgPayment) {
    this.baseDrgPayment = baseDrgPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledAdjustmentPayment() {
    return this.bundledAdjustmentPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledAdjustmentPayment(final BigDecimal bundledAdjustmentPayment) {
    this.bundledAdjustmentPayment = bundledAdjustmentPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalCostOfLivingAdjustment() {
    return this.capitalCostOfLivingAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalCostOfLivingAdjustment(final BigDecimal capitalCostOfLivingAdjustment) {
    this.capitalCostOfLivingAdjustment = capitalCostOfLivingAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapital2BFederalSpecificPortionPart() {
    return this.capital2BFederalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapital2BFederalSpecificPortionPart(final BigDecimal capital2BFederalSpecificPortionPart) {
    this.capital2BFederalSpecificPortionPart = capital2BFederalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapital2BOutlierPart() {
    return this.capital2BOutlierPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapital2BOutlierPart(final BigDecimal capital2BOutlierPart) {
    this.capital2BOutlierPart = capital2BOutlierPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCapital2PayCode() {
    return this.capital2PayCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapital2PayCode(final String capital2PayCode) {
    this.capital2PayCode = capital2PayCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalCostOutlier() {
    return this.capitalCostOutlier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalCostOutlier(final BigDecimal capitalCostOutlier) {
    this.capitalCostOutlier = capitalCostOutlier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalOperatingCostToChargeRatio() {
    return this.capitalOperatingCostToChargeRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalOperatingCostToChargeRatio(final BigDecimal capitalOperatingCostToChargeRatio) {
    this.capitalOperatingCostToChargeRatio = capitalOperatingCostToChargeRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalDisproportionateShareHospital() {
    return this.capitalDisproportionateShareHospital;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalDisproportionateShareHospital(final BigDecimal capitalDisproportionateShareHospital) {
    this.capitalDisproportionateShareHospital = capitalDisproportionateShareHospital;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalDisproportionateShareHospitalAdjustment() {
    return this.capitalDisproportionateShareHospitalAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalDisproportionateShareHospitalAdjustment(final BigDecimal capitalDisproportionateShareHospitalAdjustment) {
    this.capitalDisproportionateShareHospitalAdjustment = capitalDisproportionateShareHospitalAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalExceptionPaymentRate() {
    return this.capitalExceptionPaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalExceptionPaymentRate(final BigDecimal capitalExceptionPaymentRate) {
    this.capitalExceptionPaymentRate = capitalExceptionPaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalFederalRate() {
    return this.capitalFederalRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalFederalRate(final BigDecimal capitalFederalRate) {
    this.capitalFederalRate = capitalFederalRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalFederalSpecificPortion() {
    return this.capitalFederalSpecificPortion;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalFederalSpecificPortion(final BigDecimal capitalFederalSpecificPortion) {
    this.capitalFederalSpecificPortion = capitalFederalSpecificPortion;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalFederalSpecificPortionPart() {
    return this.capitalFederalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalFederalSpecificPortionPart(final BigDecimal capitalFederalSpecificPortionPart) {
    this.capitalFederalSpecificPortionPart = capitalFederalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalFederalSpecificPortionPct() {
    return this.capitalFederalSpecificPortionPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalFederalSpecificPortionPct(final BigDecimal capitalFederalSpecificPortionPct) {
    this.capitalFederalSpecificPortionPct = capitalFederalSpecificPortionPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalGeographicAdjFactor() {
    return this.capitalGeographicAdjFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalGeographicAdjFactor(final BigDecimal capitalGeographicAdjFactor) {
    this.capitalGeographicAdjFactor = capitalGeographicAdjFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalIndirectMedicalEducationAdj() {
    return this.capitalIndirectMedicalEducationAdj;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalIndirectMedicalEducationAdj(final BigDecimal capitalIndirectMedicalEducationAdj) {
    this.capitalIndirectMedicalEducationAdj = capitalIndirectMedicalEducationAdj;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalIndirectMedicalEducation() {
    return this.capitalIndirectMedicalEducation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalIndirectMedicalEducation(final BigDecimal capitalIndirectMedicalEducation) {
    this.capitalIndirectMedicalEducation = capitalIndirectMedicalEducation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalOutlierPart() {
    return this.capitalOutlierPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalOutlierPart(final BigDecimal capitalOutlierPart) {
    this.capitalOutlierPart = capitalOutlierPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalPaycodePct1() {
    return this.capitalPaycodePct1;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalPaycodePct1(final BigDecimal capitalPaycodePct1) {
    this.capitalPaycodePct1 = capitalPaycodePct1;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalOldHoldHarmless() {
    return this.capitalOldHoldHarmless;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalOldHoldHarmless(final BigDecimal capitalOldHoldHarmless) {
    this.capitalOldHoldHarmless = capitalOldHoldHarmless;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalOutlierCost() {
    return this.capitalOutlierCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalOutlierCost(final BigDecimal capitalOutlierCost) {
    this.capitalOutlierCost = capitalOutlierCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalOutlierCostPart() {
    return this.capitalOutlierCostPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalOutlierCostPart(final BigDecimal capitalOutlierCostPart) {
    this.capitalOutlierCostPart = capitalOutlierCostPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalSch() {
    return this.capitalSch;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalSch(final BigDecimal capitalSch) {
    this.capitalSch = capitalSch;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalShareDollarThreshold() {
    return this.capitalShareDollarThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalShareDollarThreshold(final BigDecimal capitalShareDollarThreshold) {
    this.capitalShareDollarThreshold = capitalShareDollarThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalTotalPayment() {
    return this.capitalTotalPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalTotalPayment(final BigDecimal capitalTotalPayment) {
    this.capitalTotalPayment = capitalTotalPayment;
  }

  /**
   * Corresponds to {@code HOLD-PROV-CBSA PIC X(5)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCbsaLocation() {
    return this.cbsaLocation;
  }

  /**
   * Corresponds to {@code HOLD-PROV-CBSA PIC X(5)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCbsaLocation(final String cbsaLocation) {
    this.cbsaLocation = cbsaLocation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CbsaWageIndexEntry getCbsaWageIndexEntry() {
    return this.cbsaWageIndexEntry;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCbsaWageIndexEntry(final CbsaWageIndexEntry cbsaWageIndexEntry) {
    this.cbsaWageIndexEntry = cbsaWageIndexEntry;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCostOutlierPct() {
    return this.costOutlierPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCostOutlierPct(final BigDecimal costOutlierPct) {
    this.costOutlierPct = costOutlierPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCostThreshold() {
    return this.costThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCostThreshold(final BigDecimal costThreshold) {
    this.costThreshold = costThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCovidAdjustmentFactor() {
    return this.covidAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCovidAdjustmentFactor(final BigDecimal covidAdjustmentFactor) {
    this.covidAdjustmentFactor = covidAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getDischargeDate() {
    return this.dischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDischargeFraction() {
    return this.dischargeFraction;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDischargeFraction(final BigDecimal dischargeFraction) {
    this.dischargeFraction = dischargeFraction;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DrgsTableEntry getDrgsTableEntry() {
    return this.drgsTableEntry;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDrgWeightFraction() {
    return this.drgWeightFraction;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDrgWeightFraction(final BigDecimal drgWeightFraction) {
    this.drgWeightFraction = drgWeightFraction;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getEffectiveDate() {
    return this.effectiveDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getElectronicHealthRecordAdjustmentAmt() {
    return this.electronicHealthRecordAdjustmentAmt;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setElectronicHealthRecordAdjustmentAmt(final BigDecimal electronicHealthRecordAdjustmentAmt) {
    this.electronicHealthRecordAdjustmentAmt = electronicHealthRecordAdjustmentAmt;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isHmoClaim() {
    return this.hmoClaim;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHmoClaim(final boolean hmoClaim) {
    this.hmoClaim = hmoClaim;
  }

  /**
   * Corresponds to {@code PPS-PC-COT-FLAG PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isCostOutlierThresholdClaim() {
    return this.costOutlierThresholdClaim;
  }

  /**
   * Corresponds to {@code PPS-PC-COT-FLAG PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCostOutlierThresholdClaim(final boolean costOutlierThresholdClaim) {
    this.costOutlierThresholdClaim = costOutlierThresholdClaim;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHospitalAcquiredConditionAmount() {
    return this.hospitalAcquiredConditionAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHospitalAcquiredConditionAmount(final BigDecimal hospitalAcquiredConditionAmount) {
    this.hospitalAcquiredConditionAmount = hospitalAcquiredConditionAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHrrParticipantIndicator() {
    return this.hrrParticipantIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHrrParticipantIndicator(final String hrrParticipantIndicator) {
    this.hrrParticipantIndicator = hrrParticipantIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHospitalReadmissionReductionAdjustment() {
    return this.hospitalReadmissionReductionAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHospitalReadmissionReductionAdjustment(final BigDecimal hospitalReadmissionReductionAdjustment) {
    this.hospitalReadmissionReductionAdjustment = hospitalReadmissionReductionAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getIsletIsolationPaymentAddOn() {
    return this.isletIsolationPaymentAddOn;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIsletIsolationPaymentAddOn(final BigDecimal isletIsolationPaymentAddOn) {
    this.isletIsolationPaymentAddOn = isletIsolationPaymentAddOn;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowVolumePayment() {
    return this.lowVolumePayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowVolumePayment(final BigDecimal lowVolumePayment) {
    this.lowVolumePayment = lowVolumePayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getMidnightAdjustmentFactor() {
    return this.midnightAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMidnightAdjustmentFactor(final BigDecimal midnightAdjustmentFactor) {
    this.midnightAdjustmentFactor = midnightAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalPct() {
    return this.nationalPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalPct(final BigDecimal nationalPct) {
    this.nationalPct = nationalPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalLabor() {
    return this.nationalLabor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalLabor(final BigDecimal nationalLabor) {
    this.nationalLabor = nationalLabor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalLaborPct() {
    return this.nationalLaborPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalLaborPct(final BigDecimal nationalLaborPct) {
    this.nationalLaborPct = nationalLaborPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalNonLabor() {
    return this.nationalNonLabor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalNonLabor(final BigDecimal nationalNonLabor) {
    this.nationalNonLabor = nationalNonLabor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalNonLaborPct() {
    return this.nationalNonLaborPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalNonLaborPct(final BigDecimal nationalNonLaborPct) {
    this.nationalNonLaborPct = nationalNonLaborPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNewTechAddOnPayment() {
    return this.newTechAddOnPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNewTechAddOnPayment(final BigDecimal newTechAddOnPayment) {
    this.newTechAddOnPayment = newTechAddOnPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNewCovid19TreatmentsAddOnPayment() {
    return this.newCovid19TreatmentsAddOnPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNewCovid19TreatmentsAddOnPayment(final BigDecimal newCovid19TreatmentsAddOnPayment) {
    this.newCovid19TreatmentsAddOnPayment = newCovid19TreatmentsAddOnPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNoCostProductAdjustmentFactor() {
    return this.noCostProductAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNoCostProductAdjustmentFactor(final BigDecimal noCostProductAdjustmentFactor) {
    this.noCostProductAdjustmentFactor = noCostProductAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingBaseDrgPayment() {
    return this.operatingBaseDrgPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingBaseDrgPayment(final BigDecimal operatingBaseDrgPayment) {
    this.operatingBaseDrgPayment = operatingBaseDrgPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingBillCosts() {
    return this.operatingBillCosts;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingBillCosts(final BigDecimal operatingBillCosts) {
    this.operatingBillCosts = operatingBillCosts;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingCostToChargeRatio() {
    return this.operatingCostToChargeRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingCostToChargeRatio(final BigDecimal operatingCostToChargeRatio) {
    this.operatingCostToChargeRatio = operatingCostToChargeRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingCostOfLivingAdjustment() {
    return this.operatingCostOfLivingAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingCostOfLivingAdjustment(final BigDecimal operatingCostOfLivingAdjustment) {
    this.operatingCostOfLivingAdjustment = operatingCostOfLivingAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingCostOutlier() {
    return this.operatingCostOutlier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingCostOutlier(final BigDecimal operatingCostOutlier) {
    this.operatingCostOutlier = operatingCostOutlier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingDisproportionateShare() {
    return this.operatingDisproportionateShare;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingDisproportionateShare(final BigDecimal operatingDisproportionateShare) {
    this.operatingDisproportionateShare = operatingDisproportionateShare;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingDollarThreshold() {
    return this.operatingDollarThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingDollarThreshold(final BigDecimal operatingDollarThreshold) {
    this.operatingDollarThreshold = operatingDollarThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingChargeThreshold() {
    return this.operatingChargeThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingChargeThreshold(final BigDecimal operatingChargeThreshold) {
    this.operatingChargeThreshold = operatingChargeThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingFederalSpecificPortionPart() {
    return this.operatingFederalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingFederalSpecificPortionPart(final BigDecimal operatingFederalSpecificPortionPart) {
    this.operatingFederalSpecificPortionPart = operatingFederalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingFederalSpecificPortionPct() {
    return this.operatingFederalSpecificPortionPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingFederalSpecificPortionPct(final BigDecimal operatingFederalSpecificPortionPct) {
    this.operatingFederalSpecificPortionPct = operatingFederalSpecificPortionPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingHospitalSpecificPortionPct() {
    return this.operatingHospitalSpecificPortionPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingHospitalSpecificPortionPct(final BigDecimal operatingHospitalSpecificPortionPct) {
    this.operatingHospitalSpecificPortionPct = operatingHospitalSpecificPortionPct;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingHospitalSpecificPortionPart() {
    return this.operatingHospitalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingHospitalSpecificPortionPart(final BigDecimal operatingHospitalSpecificPortionPart) {
    this.operatingHospitalSpecificPortionPart = operatingHospitalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingOutlierCostPart() {
    return this.operatingOutlierCostPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingOutlierCostPart(final BigDecimal operatingOutlierCostPart) {
    this.operatingOutlierCostPart = operatingOutlierCostPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingOutlierPart() {
    return this.operatingOutlierPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingOutlierPart(final BigDecimal operatingOutlierPart) {
    this.operatingOutlierPart = operatingOutlierPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingShareDollarThreshold() {
    return this.operatingShareDollarThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingShareDollarThreshold(final BigDecimal operatingShareDollarThreshold) {
    this.operatingShareDollarThreshold = operatingShareDollarThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingIndirectMedicalEducation() {
    return this.operatingIndirectMedicalEducation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingIndirectMedicalEducation(final BigDecimal operatingIndirectMedicalEducation) {
    this.operatingIndirectMedicalEducation = operatingIndirectMedicalEducation;
  }

  /**
   * Corresponds to {@code H-HSP-RATE PIC 9(08)V9(09) } from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHospitalSpecificPortionRate() {
    return this.hospitalSpecificPortionRate;
  }

  /**
   * Corresponds to {@code H-HSP-RATE PIC 9(08)V9(09) } from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHospitalSpecificPortionRate(final BigDecimal hospitalSpecificPortionRate) {
    this.hospitalSpecificPortionRate = hospitalSpecificPortionRate;
  }

  /**
   * Corresponds to {@code H-CAPI-HSP-PART PIC 9(06)V9(09)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalHospitalSpecificPortionPart() {
    return this.capitalHospitalSpecificPortionPart;
  }

  /**
   * Corresponds to {@code H-CAPI-HSP-PART PIC 9(06)V9(09)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalHospitalSpecificPortionPart(final BigDecimal capitalHospitalSpecificPortionPart) {
    this.capitalHospitalSpecificPortionPart = capitalHospitalSpecificPortionPart;
  }

  /**
   * Corresponds to {@code H-CAPI-HSP-PCT PIC 9(01)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalHospitalSpecificPortionPercentage() {
    return this.capitalHospitalSpecificPortionPercentage;
  }

  /**
   * Corresponds to {@code H-CAPI-HSP-PCT PIC 9(01)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalHospitalSpecificPortionPercentage(final BigDecimal capitalHospitalSpecificPortionPercentage) {
    this.capitalHospitalSpecificPortionPercentage = capitalHospitalSpecificPortionPercentage;
  }

  /**
   * Corresponds to {@code PPS-REG-PCT PIC 9(01)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRegularPercentage() {
    return this.regularPercentage;
  }

  /**
   * Corresponds to {@code PPS-REG-PCT PIC 9(01)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRegularPercentage(final BigDecimal regularPercentage) {
    this.regularPercentage = regularPercentage;
  }

  /**
   * Corresponds to {@code H-CAPI-OLD-HARMLESS PIC 9(09)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalOldHoldHarmlessRate() {
    return this.capitalOldHoldHarmlessRate;
  }

  /**
   * Corresponds to {@code H-CAPI-OLD-HARMLESS PIC 9(09)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalOldHoldHarmlessRate(final BigDecimal capitalOldHoldHarmlessRate) {
    this.capitalOldHoldHarmlessRate = capitalOldHoldHarmlessRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isOutlierAdjustmentEnabled() {
    return this.outlierAdjustmentEnabled;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierAdjustmentEnabled(final boolean outlierAdjustmentEnabled) {
    this.outlierAdjustmentEnabled = outlierAdjustmentEnabled;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutMigrationAdjustment() {
    return this.outMigrationAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutMigrationAdjustment(final BigDecimal outMigrationAdjustment) {
    this.outMigrationAdjustment = outMigrationAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isOutlierReconciliation() {
    return this.outlierReconciliation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierReconciliation(final boolean outlierReconciliation) {
    this.outlierReconciliation = outlierReconciliation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPassthroughAmountPlusMisc() {
    return this.passthroughAmountPlusMisc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPassthroughAmountPlusMisc(final BigDecimal passthroughAmountPlusMisc) {
    this.passthroughAmountPlusMisc = passthroughAmountPlusMisc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPerDiemDays() {
    return this.perDiemDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPerDiemDays(final BigDecimal perDiemDays) {
    this.perDiemDays = perDiemDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRatexTable() {
    return this.ratexTable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRatexTable(final String ratexTable) {
    this.ratexTable = ratexTable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getReadmissionAdjustmentAmount() {
    return this.readmissionAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReadmissionAdjustmentAmount(final BigDecimal readmissionAdjustmentAmount) {
    this.readmissionAdjustmentAmount = readmissionAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getRegularDays() {
    return this.regularDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRegularDays(final int regularDays) {
    this.regularDays = regularDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getStandardAllowedAmount() {
    return this.standardAllowedAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStandardAllowedAmount(final BigDecimal standardAllowedAmount) {
    this.standardAllowedAmount = standardAllowedAmount;
  }

  /**
   * Corresponds to {@code H-CBSA-RURAL-STATE PIC X(2)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStateCode() {
    return this.stateCode;
  }

  /**
   * Corresponds to {@code H-CBSA-RURAL-STATE PIC X(2)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStateCode(final String stateCode) {
    this.stateCode = stateCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTransferAdjustment() {
    return this.transferAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferAdjustment(final BigDecimal transferAdjustment) {
    this.transferAdjustment = transferAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getUncompensatedCareAmount() {
    return this.uncompensatedCareAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUncompensatedCareAmount(final BigDecimal uncompensatedCareAmount) {
    this.uncompensatedCareAmount = uncompensatedCareAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getValueBasedPurchasingAdjustment() {
    return this.valueBasedPurchasingAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setValueBasedPurchasingAdjustment(final BigDecimal valueBasedPurchasingAdjustment) {
    this.valueBasedPurchasingAdjustment = valueBasedPurchasingAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getValueBasedPurchasingAdjustmentAmount() {
    return this.valueBasedPurchasingAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setValueBasedPurchasingAdjustmentAmount(final BigDecimal valueBasedPurchasingAdjustmentAmount) {
    this.valueBasedPurchasingAdjustmentAmount = valueBasedPurchasingAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getValueBasedPurchasingParticipant() {
    return this.valueBasedPurchasingParticipant;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setValueBasedPurchasingParticipant(final String valueBasedPurchasingParticipant) {
    this.valueBasedPurchasingParticipant = valueBasedPurchasingParticipant;
  }
}
