package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.tech_addons.technology.nt2026;

import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.tech_addons.technology.CalculateTechnologyAddOnCost;
import gov.cms.fiss.pricers.ipps.core.tables.ClaimCodeType;
import gov.cms.fiss.pricers.ipps.core.tables.DataTables;

/**
 * Applies add-on costs for Alfapump System if the technology was indicated in the claim.
 *
 * @since 2026
 */
public class CalculateAlfapumpAddOnCost extends CalculateTechnologyAddOnCost {

  @Override
  public void calculate(IppsPricerContext calculationContext) {
    final DataTables dataTables = calculationContext.getDataTables();

    if (dataTables.codesMatch(
            "ALFAPUMP1", ClaimCodeType.PROC, calculationContext.getClaimData().getProcedureCodes())
        && dataTables.codesMatch(
            "ALFAPUMP2",
            ClaimCodeType.PROC,
            calculationContext.getClaimData().getProcedureCodes())) {
      aggregateNewTechCost(calculationContext, dataTables.getNewTechnologyAmount("ALFAPUMP"));
    }
  }
}
