/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.api.v1;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import gov.cms.fiss.pricers.common.api.serialization.StrictIsoLocalDateSerializer;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@JsonDeserialize(builder=DrgsTableEntryBuilder.class)
@JsonPropertyOrder(value={"diagnosticRelatedGroup", "effectiveDate", "weight", "geometricMeanLengthOfStay", "lowVolumeDrg", "arithmeticMeanLengthOfStay", "postAcuteCare", "specialPaymentPostAcuteCare", "description"})
@Schema(description="The diagnostic-related group (DRG) information.")
@Immutable
public class DrgsTableEntry {
    public static final DrgsTableEntry ZERO_WEIGHT = DrgsTableEntry.builder().weight(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP)).build();
    @DecimalMax(value="99.9")
    @DecimalMin(value="0")
    @Digits(integer=2, fraction=1)
    @NotNull
    @Schema(description="Arithmetic mean length of stay.", example="1.2", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="DRG-ARITH-ALOS", value="PIC 9(02)V9(01)")})})
    private final @DecimalMax(value="99.9") @DecimalMin(value="0") @Digits(integer=2, fraction=1) @NotNull BigDecimal arithmeticMeanLengthOfStay;
    @NotNull
    @Pattern(regexp="\\d{3}")
    @Schema(description="Diagnostic-related group.", example="077", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="WK-DRG-DRGX", value="PIC X(03)")})})
    private final @NotNull @Pattern(regexp="\\d{3}") String diagnosticRelatedGroup;
    @NotNull
    @Schema(description="Group description.", example="TRANSIENT ISCHEMIA W/O THR", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="DRG-DESC", value="PIC X(26)")})})
    private final String description;
    @JsonSerialize(using=StrictIsoLocalDateSerializer.class)
    @NotNull
    @Schema(description="Effective date of DRG information.", example="2018-10-01")
    private final LocalDate effectiveDate;
    @DecimalMax(value="99.9")
    @DecimalMin(value="0")
    @Digits(integer=2, fraction=1)
    @Schema(description="Geometric mean length of stay.", example="23.4", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="DRG-GMALOS", value="PIC 9(02)V9(01)")})})
    private final @DecimalMax(value="99.9") @DecimalMin(value="0") @Digits(integer=2, fraction=1) BigDecimal geometricMeanLengthOfStay;
    @Schema(description="Low-volume diagnostic-related group indicator.", example="077", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="DRG-LOW", value="PIC X(01)")})})
    private final String lowVolumeDrg;
    @Pattern(regexp="Y?")
    @Schema(description="Post-acute care indicator.", example="Y", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="DRG-PAC", value="PIC X(01)")})})
    private final @Pattern(regexp="Y?") String postAcuteCare;
    @Pattern(regexp="Y?")
    @Schema(description="Special payment post-acute care indicator.", example="Y", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="DRG-SPPAC", value="PIC X(01)")})})
    private final @Pattern(regexp="Y?") String specialPaymentPostAcuteCare;
    @DecimalMax(value="99.9999")
    @DecimalMin(value="0")
    @Digits(integer=2, fraction=4)
    @Schema(description="Group weight.", example="3.3326", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="DRG-WEIGHT", value="PIC 9(02)V9(04)")})})
    private final @DecimalMax(value="99.9999") @DecimalMin(value="0") @Digits(integer=2, fraction=4) BigDecimal weight;

    public DrgsTableEntryBuilder copyBuilder() {
        return DrgsTableEntry.builder().arithmeticMeanLengthOfStay(this.getArithmeticMeanLengthOfStay()).diagnosticRelatedGroup(this.getDiagnosticRelatedGroup()).description(this.getDescription()).effectiveDate(this.getEffectiveDate()).geometricMeanLengthOfStay(this.getGeometricMeanLengthOfStay()).lowVolumeDrg(this.getLowVolumeDrg()).postAcuteCare(this.getPostAcuteCare()).specialPaymentPostAcuteCare(this.getSpecialPaymentPostAcuteCare()).weight(this.getWeight());
    }

    @Generated
    DrgsTableEntry(BigDecimal arithmeticMeanLengthOfStay, String diagnosticRelatedGroup, String description, LocalDate effectiveDate, BigDecimal geometricMeanLengthOfStay, String lowVolumeDrg, String postAcuteCare, String specialPaymentPostAcuteCare, BigDecimal weight) {
        this.arithmeticMeanLengthOfStay = arithmeticMeanLengthOfStay;
        this.diagnosticRelatedGroup = diagnosticRelatedGroup;
        this.description = description;
        this.effectiveDate = effectiveDate;
        this.geometricMeanLengthOfStay = geometricMeanLengthOfStay;
        this.lowVolumeDrg = lowVolumeDrg;
        this.postAcuteCare = postAcuteCare;
        this.specialPaymentPostAcuteCare = specialPaymentPostAcuteCare;
        this.weight = weight;
    }

    @Generated
    public static DrgsTableEntryBuilder builder() {
        return new DrgsTableEntryBuilder();
    }

    @Generated
    public BigDecimal getArithmeticMeanLengthOfStay() {
        return this.arithmeticMeanLengthOfStay;
    }

    @Generated
    public String getDiagnosticRelatedGroup() {
        return this.diagnosticRelatedGroup;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @Generated
    public BigDecimal getGeometricMeanLengthOfStay() {
        return this.geometricMeanLengthOfStay;
    }

    @Generated
    public String getLowVolumeDrg() {
        return this.lowVolumeDrg;
    }

    @Generated
    public String getPostAcuteCare() {
        return this.postAcuteCare;
    }

    @Generated
    public String getSpecialPaymentPostAcuteCare() {
        return this.specialPaymentPostAcuteCare;
    }

    @Generated
    public BigDecimal getWeight() {
        return this.weight;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class DrgsTableEntryBuilder {
        @Generated
        private BigDecimal arithmeticMeanLengthOfStay;
        @Generated
        private String diagnosticRelatedGroup;
        @Generated
        private String description;
        @Generated
        private LocalDate effectiveDate;
        @Generated
        private BigDecimal geometricMeanLengthOfStay;
        @Generated
        private String lowVolumeDrg;
        @Generated
        private String postAcuteCare;
        @Generated
        private String specialPaymentPostAcuteCare;
        @Generated
        private BigDecimal weight;

        @Generated
        DrgsTableEntryBuilder() {
        }

        @Generated
        public DrgsTableEntryBuilder arithmeticMeanLengthOfStay(BigDecimal arithmeticMeanLengthOfStay) {
            this.arithmeticMeanLengthOfStay = arithmeticMeanLengthOfStay;
            return this;
        }

        @Generated
        public DrgsTableEntryBuilder diagnosticRelatedGroup(String diagnosticRelatedGroup) {
            this.diagnosticRelatedGroup = diagnosticRelatedGroup;
            return this;
        }

        @Generated
        public DrgsTableEntryBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public DrgsTableEntryBuilder effectiveDate(LocalDate effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        @Generated
        public DrgsTableEntryBuilder geometricMeanLengthOfStay(BigDecimal geometricMeanLengthOfStay) {
            this.geometricMeanLengthOfStay = geometricMeanLengthOfStay;
            return this;
        }

        @Generated
        public DrgsTableEntryBuilder lowVolumeDrg(String lowVolumeDrg) {
            this.lowVolumeDrg = lowVolumeDrg;
            return this;
        }

        @Generated
        public DrgsTableEntryBuilder postAcuteCare(String postAcuteCare) {
            this.postAcuteCare = postAcuteCare;
            return this;
        }

        @Generated
        public DrgsTableEntryBuilder specialPaymentPostAcuteCare(String specialPaymentPostAcuteCare) {
            this.specialPaymentPostAcuteCare = specialPaymentPostAcuteCare;
            return this;
        }

        @Generated
        public DrgsTableEntryBuilder weight(BigDecimal weight) {
            this.weight = weight;
            return this;
        }

        @Generated
        public DrgsTableEntry build() {
            return new DrgsTableEntry(this.arithmeticMeanLengthOfStay, this.diagnosticRelatedGroup, this.description, this.effectiveDate, this.geometricMeanLengthOfStay, this.lowVolumeDrg, this.postAcuteCare, this.specialPaymentPostAcuteCare, this.weight);
        }

        @Generated
        public String toString() {
            return "DrgsTableEntry.DrgsTableEntryBuilder(arithmeticMeanLengthOfStay=" + this.arithmeticMeanLengthOfStay + ", diagnosticRelatedGroup=" + this.diagnosticRelatedGroup + ", description=" + this.description + ", effectiveDate=" + this.effectiveDate + ", geometricMeanLengthOfStay=" + this.geometricMeanLengthOfStay + ", lowVolumeDrg=" + this.lowVolumeDrg + ", postAcuteCare=" + this.postAcuteCare + ", specialPaymentPostAcuteCare=" + this.specialPaymentPostAcuteCare + ", weight=" + this.weight + ")";
        }
    }

    @Generated
    public static final class Fields {
        public static final String ARITHMETIC_MEAN_LENGTH_OF_STAY = "arithmeticMeanLengthOfStay";
        public static final String DIAGNOSTIC_RELATED_GROUP = "diagnosticRelatedGroup";
        public static final String DESCRIPTION = "description";
        public static final String EFFECTIVE_DATE = "effectiveDate";
        public static final String GEOMETRIC_MEAN_LENGTH_OF_STAY = "geometricMeanLengthOfStay";
        public static final String LOW_VOLUME_DRG = "lowVolumeDrg";
        public static final String POST_ACUTE_CARE = "postAcuteCare";
        public static final String SPECIAL_PAYMENT_POST_ACUTE_CARE = "specialPaymentPostAcuteCare";
        public static final String WEIGHT = "weight";
    }
}

