/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithNineFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;

@Schema(description="The additional operating variable information from claim pricing.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-ADDITIONAL-VARIABLES", value="<structure>")})})
public class AdditionalOperatingVariableData {
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The operating base diagnosis-related group (DRG) payment.", example="329078.56", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OPER-BASE-DRG-PAY", value="PIC 9(08)V99")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal operatingBaseDrgPayment;
    @BigDecimalScale(scale=4, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The operating disproportionate share hospital (DSH) amount.", example="4.5045", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-OPER-DSH", value="PIC 9(01)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal operatingDisproportionateShareHospitalAmount;
    @BigDecimalScale(scale=4, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The operating disproportionate share hospital ratio; derived from provider ratios.", example="4.5045", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-WK-OPER-DSH", value="PIC 9(01)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal operatingDisproportionateShareHospitalRatio;
    @BigDecimalScale(scale=9, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The new technology add-on payment.", example="9485.76", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-DOLLAR-THRESHOLD", value="PIC 9(07)V9(09)")})})
    @ValidDecimalOutputWithNineFractionDigits
    private BigDecimal operatingDollarThreshold;
    @BigDecimalScale(scale=9, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The operating federal-specific portion part.", example="984307.256493255", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-OPER-FSP-PART", value="PIC 9(06)V9(09)")})})
    @ValidDecimalOutputWithNineFractionDigits
    private BigDecimal operatingFederalSpecificPortionPart;
    @BigDecimalScale(scale=9, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The operating hospital-specific portion part.", example="1234.896525245", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-OPER-HSP-PART", value="PIC 9(06)V9(09)")})})
    @ValidDecimalOutputWithNineFractionDigits
    private BigDecimal operatingHospitalSpecificPortionPart;
    @BigDecimalScale(scale=9, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The operating indirect medical education amount.", example="738.920546234", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-OPER-IME-TEACH", value="PIC 9(06)V9(09)")})})
    @ValidDecimalOutputWithNineFractionDigits
    private BigDecimal operatingIndirectMedicalEducationAmount;

    @Generated
    public BigDecimal getOperatingBaseDrgPayment() {
        return this.operatingBaseDrgPayment;
    }

    @Generated
    public BigDecimal getOperatingDisproportionateShareHospitalAmount() {
        return this.operatingDisproportionateShareHospitalAmount;
    }

    @Generated
    public BigDecimal getOperatingDisproportionateShareHospitalRatio() {
        return this.operatingDisproportionateShareHospitalRatio;
    }

    @Generated
    public BigDecimal getOperatingDollarThreshold() {
        return this.operatingDollarThreshold;
    }

    @Generated
    public BigDecimal getOperatingFederalSpecificPortionPart() {
        return this.operatingFederalSpecificPortionPart;
    }

    @Generated
    public BigDecimal getOperatingHospitalSpecificPortionPart() {
        return this.operatingHospitalSpecificPortionPart;
    }

    @Generated
    public BigDecimal getOperatingIndirectMedicalEducationAmount() {
        return this.operatingIndirectMedicalEducationAmount;
    }

    @Generated
    public void setOperatingBaseDrgPayment(BigDecimal operatingBaseDrgPayment) {
        this.operatingBaseDrgPayment = operatingBaseDrgPayment;
    }

    @Generated
    public void setOperatingDisproportionateShareHospitalAmount(BigDecimal operatingDisproportionateShareHospitalAmount) {
        this.operatingDisproportionateShareHospitalAmount = operatingDisproportionateShareHospitalAmount;
    }

    @Generated
    public void setOperatingDisproportionateShareHospitalRatio(BigDecimal operatingDisproportionateShareHospitalRatio) {
        this.operatingDisproportionateShareHospitalRatio = operatingDisproportionateShareHospitalRatio;
    }

    @Generated
    public void setOperatingDollarThreshold(BigDecimal operatingDollarThreshold) {
        this.operatingDollarThreshold = operatingDollarThreshold;
    }

    @Generated
    public void setOperatingFederalSpecificPortionPart(BigDecimal operatingFederalSpecificPortionPart) {
        this.operatingFederalSpecificPortionPart = operatingFederalSpecificPortionPart;
    }

    @Generated
    public void setOperatingHospitalSpecificPortionPart(BigDecimal operatingHospitalSpecificPortionPart) {
        this.operatingHospitalSpecificPortionPart = operatingHospitalSpecificPortionPart;
    }

    @Generated
    public void setOperatingIndirectMedicalEducationAmount(BigDecimal operatingIndirectMedicalEducationAmount) {
        this.operatingIndirectMedicalEducationAmount = operatingIndirectMedicalEducationAmount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdditionalOperatingVariableData)) {
            return false;
        }
        AdditionalOperatingVariableData other = (AdditionalOperatingVariableData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$operatingBaseDrgPayment = this.getOperatingBaseDrgPayment();
        BigDecimal other$operatingBaseDrgPayment = other.getOperatingBaseDrgPayment();
        if (this$operatingBaseDrgPayment == null ? other$operatingBaseDrgPayment != null : !((Object)this$operatingBaseDrgPayment).equals(other$operatingBaseDrgPayment)) {
            return false;
        }
        BigDecimal this$operatingDisproportionateShareHospitalAmount = this.getOperatingDisproportionateShareHospitalAmount();
        BigDecimal other$operatingDisproportionateShareHospitalAmount = other.getOperatingDisproportionateShareHospitalAmount();
        if (this$operatingDisproportionateShareHospitalAmount == null ? other$operatingDisproportionateShareHospitalAmount != null : !((Object)this$operatingDisproportionateShareHospitalAmount).equals(other$operatingDisproportionateShareHospitalAmount)) {
            return false;
        }
        BigDecimal this$operatingDisproportionateShareHospitalRatio = this.getOperatingDisproportionateShareHospitalRatio();
        BigDecimal other$operatingDisproportionateShareHospitalRatio = other.getOperatingDisproportionateShareHospitalRatio();
        if (this$operatingDisproportionateShareHospitalRatio == null ? other$operatingDisproportionateShareHospitalRatio != null : !((Object)this$operatingDisproportionateShareHospitalRatio).equals(other$operatingDisproportionateShareHospitalRatio)) {
            return false;
        }
        BigDecimal this$operatingDollarThreshold = this.getOperatingDollarThreshold();
        BigDecimal other$operatingDollarThreshold = other.getOperatingDollarThreshold();
        if (this$operatingDollarThreshold == null ? other$operatingDollarThreshold != null : !((Object)this$operatingDollarThreshold).equals(other$operatingDollarThreshold)) {
            return false;
        }
        BigDecimal this$operatingFederalSpecificPortionPart = this.getOperatingFederalSpecificPortionPart();
        BigDecimal other$operatingFederalSpecificPortionPart = other.getOperatingFederalSpecificPortionPart();
        if (this$operatingFederalSpecificPortionPart == null ? other$operatingFederalSpecificPortionPart != null : !((Object)this$operatingFederalSpecificPortionPart).equals(other$operatingFederalSpecificPortionPart)) {
            return false;
        }
        BigDecimal this$operatingHospitalSpecificPortionPart = this.getOperatingHospitalSpecificPortionPart();
        BigDecimal other$operatingHospitalSpecificPortionPart = other.getOperatingHospitalSpecificPortionPart();
        if (this$operatingHospitalSpecificPortionPart == null ? other$operatingHospitalSpecificPortionPart != null : !((Object)this$operatingHospitalSpecificPortionPart).equals(other$operatingHospitalSpecificPortionPart)) {
            return false;
        }
        BigDecimal this$operatingIndirectMedicalEducationAmount = this.getOperatingIndirectMedicalEducationAmount();
        BigDecimal other$operatingIndirectMedicalEducationAmount = other.getOperatingIndirectMedicalEducationAmount();
        return !(this$operatingIndirectMedicalEducationAmount == null ? other$operatingIndirectMedicalEducationAmount != null : !((Object)this$operatingIndirectMedicalEducationAmount).equals(other$operatingIndirectMedicalEducationAmount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdditionalOperatingVariableData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $operatingBaseDrgPayment = this.getOperatingBaseDrgPayment();
        result = result * 59 + ($operatingBaseDrgPayment == null ? 43 : ((Object)$operatingBaseDrgPayment).hashCode());
        BigDecimal $operatingDisproportionateShareHospitalAmount = this.getOperatingDisproportionateShareHospitalAmount();
        result = result * 59 + ($operatingDisproportionateShareHospitalAmount == null ? 43 : ((Object)$operatingDisproportionateShareHospitalAmount).hashCode());
        BigDecimal $operatingDisproportionateShareHospitalRatio = this.getOperatingDisproportionateShareHospitalRatio();
        result = result * 59 + ($operatingDisproportionateShareHospitalRatio == null ? 43 : ((Object)$operatingDisproportionateShareHospitalRatio).hashCode());
        BigDecimal $operatingDollarThreshold = this.getOperatingDollarThreshold();
        result = result * 59 + ($operatingDollarThreshold == null ? 43 : ((Object)$operatingDollarThreshold).hashCode());
        BigDecimal $operatingFederalSpecificPortionPart = this.getOperatingFederalSpecificPortionPart();
        result = result * 59 + ($operatingFederalSpecificPortionPart == null ? 43 : ((Object)$operatingFederalSpecificPortionPart).hashCode());
        BigDecimal $operatingHospitalSpecificPortionPart = this.getOperatingHospitalSpecificPortionPart();
        result = result * 59 + ($operatingHospitalSpecificPortionPart == null ? 43 : ((Object)$operatingHospitalSpecificPortionPart).hashCode());
        BigDecimal $operatingIndirectMedicalEducationAmount = this.getOperatingIndirectMedicalEducationAmount();
        result = result * 59 + ($operatingIndirectMedicalEducationAmount == null ? 43 : ((Object)$operatingIndirectMedicalEducationAmount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AdditionalOperatingVariableData(operatingBaseDrgPayment=" + this.getOperatingBaseDrgPayment() + ", operatingDisproportionateShareHospitalAmount=" + this.getOperatingDisproportionateShareHospitalAmount() + ", operatingDisproportionateShareHospitalRatio=" + this.getOperatingDisproportionateShareHospitalRatio() + ", operatingDollarThreshold=" + this.getOperatingDollarThreshold() + ", operatingFederalSpecificPortionPart=" + this.getOperatingFederalSpecificPortionPart() + ", operatingHospitalSpecificPortionPart=" + this.getOperatingHospitalSpecificPortionPart() + ", operatingIndirectMedicalEducationAmount=" + this.getOperatingIndirectMedicalEducationAmount() + ")";
    }

    @Generated
    public AdditionalOperatingVariableData() {
    }
}

