/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v1.DrgsTableEntry;
import gov.cms.fiss.pricers.ipps.api.v2.AdditionalCalculationVariableData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;

public class DefaultAdditionalVariableUpdate
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        AdditionalCalculationVariableData additionalVariables = calculationContext.getAdditionalVariables();
        additionalVariables.getAdditionalPaymentInformation().setBundledAdjustmentPayment(this.getValueOrNull(calculationContext.getBundledAdjustmentPayment()));
        additionalVariables.getAdditionalCapitalVariables().setCapitalFederalSpecificPortion2B(this.getValueOrNull(calculationContext.getCapital2BFederalSpecificPortionPart()));
        additionalVariables.getAdditionalCapitalVariables().setCapitalHospitalSpecificPortionPart(this.getValueOrNull(calculationContext.getCapitalHospitalSpecificPortionPart()));
        additionalVariables.getAdditionalCapitalVariables().setCapitalOutlier2B(this.getValueOrNull(calculationContext.getCapital2BOutlierPart()));
        additionalVariables.getAdditionalCapitalVariables().setCapitalExceptionAmount(this.getValueOrNull(calculationContext.getCapitalExceptionPaymentRate()));
        additionalVariables.getAdditionalCapitalVariables().setCapitalPaymentCode(calculationContext.getCapital2PayCode());
        BigDecimal capitalFederalSpecificPortion = calculationContext.getCapitalFederalSpecificPortionPart().multiply(calculationContext.getCapitalFederalSpecificPortionPct()).setScale(2, RoundingMode.HALF_UP);
        additionalVariables.getAdditionalCapitalVariables().setCapitalDisproportionateShareHospitalAdjustment(this.getValueOrNull(calculationContext.getCapitalDisproportionateShareHospital().multiply(capitalFederalSpecificPortion).setScale(2, RoundingMode.HALF_UP)));
        additionalVariables.getAdditionalCapitalVariables().setCapitalFederalSpecificPortion(this.getValueOrNull(capitalFederalSpecificPortion));
        additionalVariables.getAdditionalCapitalVariables().setCapitalIndirectMedicalEducationAdjustment(this.getValueOrNull(calculationContext.getCapitalIndirectMedicalEducationAdj()));
        additionalVariables.getAdditionalCapitalVariables().setCapitalOldHoldHarmlessAmount(this.getValueOrNull(calculationContext.getCapitalOldHoldHarmless().setScale(2, RoundingMode.HALF_UP)));
        additionalVariables.getAdditionalCapitalVariables().setCapitalOutlier(this.getValueOrNull(calculationContext.getCapitalOutlierPart().setScale(2, RoundingMode.HALF_UP)));
        additionalVariables.getAdditionalCapitalVariables().setCapitalTotalPayment(this.getValueOrNull(calculationContext.getCapitalTotalPayment().setScale(2, RoundingMode.HALF_UP)));
        additionalVariables.setDischargeFraction(this.getValueOrNull(calculationContext.getDischargeFraction()));
        additionalVariables.setDrgRelativeWeight(this.getValueOrNull(Optional.ofNullable(calculationContext.getDrgsTableEntry()).orElse(DrgsTableEntry.ZERO_WEIGHT).getWeight()));
        additionalVariables.setDrgRelativeWeightFraction(this.getValueOrNull(calculationContext.getDrgWeightFraction()));
        additionalVariables.getAdditionalPaymentInformation().setElectronicHealthRecordAdjustmentPayment(this.getValueOrNull(calculationContext.getElectronicHealthRecordAdjustmentAmt()));
        additionalVariables.setFederalSpecificPortionPercent(this.getValueOrNull(calculationContext.getOperatingFederalSpecificPortionPct()));
        additionalVariables.getAdditionalPaymentInformation().setHospitalAcquiredConditionPayment(this.getValueOrNull(calculationContext.getHospitalAcquiredConditionAmount().setScale(2, RoundingMode.HALF_UP)));
        additionalVariables.setHospitalReadmissionReductionIndicator(calculationContext.getHrrParticipantIndicator());
        additionalVariables.setHospitalReadmissionReductionAdjustment(this.getValueOrNull(calculationContext.getHospitalReadmissionReductionAdjustment()));
        additionalVariables.setIsletIsolationAddOnPayment(this.getValueOrNull(calculationContext.getIsletIsolationPaymentAddOn()));
        additionalVariables.setLowVolumePayment(this.getValueOrNull(calculationContext.getLowVolumePayment().setScale(2, RoundingMode.HALF_UP)));
        additionalVariables.setNationalPercent(this.getValueOrNull(calculationContext.getNationalPct()));
        additionalVariables.setNewTechnologyAddOnPayment(this.getValueOrNull(calculationContext.getNewTechAddOnPayment().setScale(2, RoundingMode.HALF_UP)));
        additionalVariables.getAdditionalOperatingVariables().setOperatingBaseDrgPayment(this.getValueOrNull(calculationContext.getOperatingBaseDrgPayment()));
        additionalVariables.getAdditionalOperatingVariables().setOperatingDollarThreshold(this.getValueOrNull(calculationContext.getOperatingDollarThreshold().setScale(9, RoundingMode.HALF_UP)));
        additionalVariables.getAdditionalPaymentInformation().setHospitalReadmissionReductionAdjustmentPayment(this.getValueOrNull(calculationContext.getReadmissionAdjustmentAmount()));
        additionalVariables.getAdditionalPaymentInformation().setStandardValue(this.getValueOrNull(calculationContext.getStandardAllowedAmount().setScale(2, RoundingMode.HALF_UP)));
        additionalVariables.getAdditionalPaymentInformation().setUncompensatedCarePayment(this.getValueOrNull(calculationContext.getUncompensatedCareAmount()));
        additionalVariables.setValueBasedPurchasingAdjustmentAmount(this.getValueOrNull(calculationContext.getValueBasedPurchasingAdjustment()));
        additionalVariables.getAdditionalPaymentInformation().setValueBasedPurchasingAdjustmentPayment(this.getValueOrNull(calculationContext.getValueBasedPurchasingAdjustmentAmount()));
        additionalVariables.setValueBasedPurchasingParticipantIndicator(calculationContext.getValueBasedPurchasingParticipant());
        ((IppsClaimPricingResponse)calculationContext.getOutput()).setCalculationVersion(calculationContext.getCalculationVersion());
    }

    private BigDecimal getValueOrNull(BigDecimal value) {
        BigDecimal returnVal = null;
        if (!BigDecimalUtils.isZero(value)) {
            returnVal = value;
        }
        return returnVal;
    }
}

