/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.billing_validation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;

public class ValidateCoveredDays
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public boolean shouldExecute(IppsPricerContext calculationContext) {
        return ResultCode.RC_00_OK == calculationContext.getResultCode();
    }

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        IppsClaimData claimData = calculationContext.getClaimData();
        if (claimData.getCoveredDays() == 0 && claimData.getLengthOfStay() > 0) {
            calculationContext.applyResultCode(ResultCode.RC_62_INVALID_NBR_COVERED_DAYS);
        }
    }
}

