/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;

public class CalculateNationalPercentages
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        calculationContext.setNationalLaborPct(calculationContext.getNationalLaborPctWageIndexGtOne());
        calculationContext.setNationalNonLaborPct(calculationContext.getNationalNonLaborPctWageIndexGtOne());
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        if (BigDecimalUtils.isLessThanOrEqualTo(cbsaReference.getWageIndex(), BigDecimal.ONE)) {
            calculationContext.setNationalLaborPct(calculationContext.getNationalLaborPctWageIndexLtEqOne());
            calculationContext.setNationalNonLaborPct(calculationContext.getNationalNonLaborPctWageIndexLtEqOne());
        }
        if (BigDecimalUtils.isGreaterThanZero(providerData.getOperatingCostToChargeRatio())) {
            calculationContext.setOperatingCostToChargeRatio(providerData.getOperatingCostToChargeRatio());
        } else {
            calculationContext.setOperatingCostToChargeRatio(BigDecimal.ZERO);
        }
        if (BigDecimalUtils.isGreaterThanZero(providerData.getCapitalCostToChargeRatio())) {
            calculationContext.setCapitalOperatingCostToChargeRatio(providerData.getCapitalCostToChargeRatio());
        } else {
            calculationContext.setCapitalOperatingCostToChargeRatio(BigDecimal.ZERO);
        }
    }
}

