/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class CalculateReadmissionReduction
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        calculationContext.setReadmissionAdjustmentAmount(BigDecimal.ZERO);
        if (!StringUtils.equals(providerData.getHrrParticipantIndicator(), "1")) {
            if (StringUtils.equals(providerData.getHrrParticipantIndicator(), "0") && BigDecimalUtils.isZero(providerData.getHrrAdjustment())) {
                return;
            }
            if (StringUtils.equals(providerData.getHrrParticipantIndicator(), "0") && BigDecimalUtils.isGreaterThanZero(providerData.getHrrAdjustment()) || StringUtils.isBlank(providerData.getHrrParticipantIndicator()) || StringUtils.equalsAny(providerData.getHrrParticipantIndicator(), "2", "3", "4", "5", "6", "7", "8", "9")) {
                calculationContext.applyResultCode(ResultCode.RC_65_PAY_CODE_NOT_ABC);
                calculationContext.setReadmissionAdjustmentAmount(BigDecimal.ZERO);
                return;
            }
        }
        this.editReadmission(calculationContext);
    }

    protected void editReadmission(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (BigDecimalUtils.isLessThan(providerData.getHrrAdjustment(), new BigDecimal(".97")) || BigDecimalUtils.isGreaterThan(providerData.getHrrAdjustment(), BigDecimal.ONE) || calculationContext.isReadInvalidState()) {
            calculationContext.applyResultCode(ResultCode.RC_65_PAY_CODE_NOT_ABC);
            calculationContext.setReadmissionAdjustmentAmount(BigDecimal.ZERO);
            return;
        }
        this.computeReadmission(calculationContext);
    }

    protected void computeReadmission(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        calculationContext.setReadmissionAdjustmentAmount(providerData.getHrrAdjustment().multiply(calculationContext.getOperatingBaseDrgPayment()).subtract(calculationContext.getOperatingBaseDrgPayment()).setScale(2, RoundingMode.HALF_UP));
    }
}

