/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.wage_index;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import gov.cms.fiss.pricers.ipps.core.tables.CbsaWageIndexEntry;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;

public class AdjustIndexForRuralFloor
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        if (cbsaReference.getWageIndex() != null && BigDecimalUtils.isZero(cbsaReference.getWageIndex())) {
            calculationContext.applyResultCode(ResultCode.RC_52_INVALID_WAGE_INDEX);
            return;
        }
        InpatientProviderData providerData = calculationContext.getProviderData();
        calculationContext.setStateCode(StringUtils.isNotEmpty(providerData.getStateCode()) ? providerData.getStateCode().trim() : "00");
        if (calculationContext.getStateCode().equals("00")) {
            calculationContext.setStateCode("03");
        }
        this.adjustRuralFloor(calculationContext);
    }

    protected void adjustRuralFloor(IppsPricerContext calculationContext) {
        CbsaReference cbsaReference;
        CbsaWageIndexEntry ruralCbsaTableEntry = calculationContext.getCbsaWageIndexEntry(calculationContext.getStateCode());
        BigDecimal ruralWi = BigDecimal.ZERO;
        if (ruralCbsaTableEntry != null) {
            LocalDate ruralCbsaTableEntryEffectiveDate = ruralCbsaTableEntry.getEffectiveDate();
            if (LocalDateUtils.isAfterOrEqual(calculationContext.getDischargeDate(), ruralCbsaTableEntry.getEffectiveDate()) && LocalDateUtils.inRange(ruralCbsaTableEntryEffectiveDate, calculationContext.fiscalYearStart(), calculationContext.fiscalYearEnd())) {
                ruralWi = ruralCbsaTableEntry.getGeographicWageIndex();
            }
        }
        if (BigDecimalUtils.isGreaterThan(ruralWi, (cbsaReference = calculationContext.getCbsaReference()).getWageIndex())) {
            if (ruralCbsaTableEntry == null) {
                cbsaReference.setCbsa(null);
                cbsaReference.setEffectiveDate(null);
                cbsaReference.setWageIndex(null);
            } else {
                cbsaReference.setCbsa(ruralCbsaTableEntry.getCbsa());
                cbsaReference.setEffectiveDate(ruralCbsaTableEntry.getEffectiveDate());
                cbsaReference.setWageIndex(ruralCbsaTableEntry.getGeographicWageIndex());
            }
            calculationContext.getProviderData().setSpecialPaymentIndicator("N");
            calculationContext.setCbsaLocation(calculationContext.getStateCode());
        }
    }
}

