/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.tables;

import com.fasterxml.jackson.databind.MapperFeature;
import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.RatexTableEntry;
import java.util.List;
import java.util.Map;

public class RatexTableEntryLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/ratex-%s.csv";
    private final CsvContentReader<RatexTableEntry> contentProvider = new CsvContentReader<RatexTableEntry>(RatexTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public RatexTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<RatexTableEntry.RatexKey, RatexTableEntry> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<RatexTableEntry.RatexKey, RatexTableEntry> generate(String csvFilename) {
        this.contentProvider.customizeMapper(csvMapper -> {
            csvMapper.enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
            return csvMapper;
        });
        List<RatexTableEntry> content = this.contentProvider.read(csvFilename);
        return LookupGenerator.generateMap(RatexTableEntry.RatexKey::fromRatex, content);
    }
}

