/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.RuralFloorTableEntry;
import java.util.List;
import java.util.Map;

public class RuralFloorTableEntryLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/rufl-%s.csv";
    private final CsvContentReader<RuralFloorTableEntry> contentProvider = new CsvContentReader<RuralFloorTableEntry>(RuralFloorTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public RuralFloorTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, RuralFloorTableEntry> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, RuralFloorTableEntry> generate(String csvFilename) {
        List<RuralFloorTableEntry> content = this.contentProvider.read(csvFilename);
        return LookupGenerator.generateMap(RuralFloorTableEntry::getCbsa, content);
    }
}

