// Generated by delombok at Thu Nov 13 21:39:03 UTC 2025
package gov.cms.fiss.pricers.ipps.core.tables;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.ipps.core.tables.RatexTableEntry.Fields;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
@JsonDeserialize(builder = RatexTableEntry.RatexTableEntryBuilder.class)
@JsonPropertyOrder({Fields.TABLE_NUMBER, Fields.SCOPE, Fields.LARGE_URBAN, Fields.REG_LABOR, Fields.REG_N_LABOR})
public class RatexTableEntry {

  @JsonPOJOBuilder(withPrefix = "")
  public static class RatexTableEntryBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String tableNumber;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Scope scope;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private int largeUrban;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal regLabor;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal regNLabor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    RatexTableEntryBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RatexTableEntry.RatexTableEntryBuilder tableNumber(final String tableNumber) {
      this.tableNumber = tableNumber;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RatexTableEntry.RatexTableEntryBuilder scope(final Scope scope) {
      this.scope = scope;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RatexTableEntry.RatexTableEntryBuilder largeUrban(final int largeUrban) {
      this.largeUrban = largeUrban;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RatexTableEntry.RatexTableEntryBuilder regLabor(final BigDecimal regLabor) {
      this.regLabor = regLabor;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RatexTableEntry.RatexTableEntryBuilder regNLabor(final BigDecimal regNLabor) {
      this.regNLabor = regNLabor;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RatexTableEntry build() {
      return new RatexTableEntry(this.tableNumber, this.scope, this.largeUrban, this.regLabor, this.regNLabor);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "RatexTableEntry.RatexTableEntryBuilder(tableNumber=" + this.tableNumber + ", scope=" + this.scope + ", largeUrban=" + this.largeUrban + ", regLabor=" + this.regLabor + ", regNLabor=" + this.regNLabor + ")";
    }
  }

  @Pattern(regexp = "tab\\d+")
  private final String tableNumber;
  private final Scope scope;
  @Max(2)
  @Min(1)
  private final int largeUrban;
  @Digits(integer = 5, fraction = 2)
  private final BigDecimal regLabor;
  @Digits(integer = 5, fraction = 2)
  private final BigDecimal regNLabor;

  public boolean isLargeUrban() {
    return Objects.equals(largeUrban, 1);
  }

  public RatexTableEntryBuilder copyBuilder() {
    return RatexTableEntry.builder().tableNumber(getTableNumber()).scope(getScope()).largeUrban(getLargeUrban()).regLabor(getRegLabor()).regNLabor(getRegNLabor());
  }


  /**
   * Representation of the scope of a rate table entry.
   */
  public enum Scope {
    NAT("nat"), PR("pr"), @JsonProperty("natpr")
    NAT_PR("natpr");
    private final String referenceName;

    Scope(String referenceName) {
      this.referenceName = referenceName;
    }

    public static Scope fromReference(String referenceName) {
      for (final Scope scope : Scope.values()) {
        if (scope.referenceName.equals(referenceName)) {
          return scope;
        }
      }
      throw new IllegalArgumentException("Invalid scope reference: " + referenceName);
    }
  }


  /**
   * Multi-part key for a rate table entry.
   */
  public static final class RatexKey {
    private final String table;
    private final Scope scope;
    private final boolean isLargeUrban;

    public static RatexKey fromRatex(RatexTableEntry ratexTableEntry) {
      return new RatexKey(ratexTableEntry.getTableNumber(), ratexTableEntry.getScope(), ratexTableEntry.isLargeUrban());
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RatexKey(final String table, final Scope scope, final boolean isLargeUrban) {
      this.table = table;
      this.scope = scope;
      this.isLargeUrban = isLargeUrban;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTable() {
      return this.table;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Scope getScope() {
      return this.scope;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isLargeUrban() {
      return this.isLargeUrban;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof RatexTableEntry.RatexKey)) return false;
      final RatexTableEntry.RatexKey other = (RatexTableEntry.RatexKey) o;
      if (this.isLargeUrban() != other.isLargeUrban()) return false;
      final java.lang.Object this$table = this.getTable();
      final java.lang.Object other$table = other.getTable();
      if (this$table == null ? other$table != null : !this$table.equals(other$table)) return false;
      final java.lang.Object this$scope = this.getScope();
      final java.lang.Object other$scope = other.getScope();
      if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) return false;
      return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      result = result * PRIME + (this.isLargeUrban() ? 79 : 97);
      final java.lang.Object $table = this.getTable();
      result = result * PRIME + ($table == null ? 43 : $table.hashCode());
      final java.lang.Object $scope = this.getScope();
      result = result * PRIME + ($scope == null ? 43 : $scope.hashCode());
      return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "RatexTableEntry.RatexKey(table=" + this.getTable() + ", scope=" + this.getScope() + ", isLargeUrban=" + this.isLargeUrban() + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  RatexTableEntry(final String tableNumber, final Scope scope, final int largeUrban, final BigDecimal regLabor, final BigDecimal regNLabor) {
    this.tableNumber = tableNumber;
    this.scope = scope;
    this.largeUrban = largeUrban;
    this.regLabor = regLabor;
    this.regNLabor = regNLabor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static RatexTableEntry.RatexTableEntryBuilder builder() {
    return new RatexTableEntry.RatexTableEntryBuilder();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTableNumber() {
    return this.tableNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Scope getScope() {
    return this.scope;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLargeUrban() {
    return this.largeUrban;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRegLabor() {
    return this.regLabor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRegNLabor() {
    return this.regNLabor;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String TABLE_NUMBER = "tableNumber";
    public static final java.lang.String SCOPE = "scope";
    public static final java.lang.String LARGE_URBAN = "largeUrban";
    public static final java.lang.String REG_LABOR = "regLabor";
    public static final java.lang.String REG_N_LABOR = "regNLabor";
  }
}
