/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.request;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class ClaimMetadata {
    private final MultivaluedMap<String, String> claimRequestMetadata = new MultivaluedHashMap<String, String>();

    public ClaimMetadata(MultivaluedMap<String, String> requestMetadata) {
        this.claimRequestMetadata.putAll(requestMetadata);
    }

    public List<String> getClaimMetadata(String metadataKey) {
        return this.claimRequestMetadata.getOrDefault(metadataKey, (String)((Object)new ArrayList()));
    }

    public List<String> getClaimMetadata(String metadataKey, String defaultValue) {
        return this.claimRequestMetadata.getOrDefault(metadataKey, (String)((Object)Collections.singletonList(defaultValue)));
    }

    public boolean claimMetadataMatches(String metadataKey, Predicate<String> matcher) {
        return ((List)Optional.ofNullable((List)this.claimRequestMetadata.get(metadataKey)).orElse(new ArrayList())).stream().anyMatch(matcher);
    }

    public boolean claimMetadataMatches(String metadataKey, List<String> matchingValues) {
        return this.claimMetadataMatches(metadataKey, (String v) -> ((List)Optional.ofNullable(matchingValues).orElse(new ArrayList())).contains(v));
    }

    public boolean claimMetadataMatchesIgnoreCase(String metadataKey, List<String> matchingValues) {
        return this.claimMetadataMatches(metadataKey, (String v) -> StringUtils.containsAnyIgnoreCase(v, ((List)Optional.ofNullable(matchingValues).orElse(new ArrayList())).toArray(new String[0])));
    }

    public boolean claimMetadataMatchesIgnoreAllCase(String metadataKey, List<String> matchingValues) {
        return this.claimMetadataMatchesIgnoreKeyCase(metadataKey, (String v) -> StringUtils.containsAnyIgnoreCase(v, ((List)Optional.ofNullable(matchingValues).orElse(new ArrayList())).toArray(new String[0])));
    }

    public boolean claimMetadataMatchesIgnoreKeyCase(String metadataKey, List<String> matchingValues) {
        return this.claimMetadataMatchesIgnoreKeyCase(metadataKey, (String v) -> ((List)Optional.ofNullable(matchingValues).orElse(new ArrayList())).contains(v));
    }

    public boolean claimMetadataMatchesIgnoreKeyCase(String metadataKey, Predicate<String> matcher) {
        return this.claimRequestMetadata.keySet().stream().filter(k -> StringUtils.equalsIgnoreCase(k, metadataKey)).findFirst().filter(k -> this.claimMetadataMatches((String)k, matcher)).isPresent();
    }
}

