/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.ipps.IppsPricerConfiguration;
import gov.cms.fiss.pricers.ipps.core.IppsPricerDispatch;
import gov.cms.fiss.pricers.ipps.core.tables.DataTables;
import gov.cms.fiss.pricers.ipps.resources.IppsClaimPricingResource;
import gov.cms.fiss.pricers.ipps.resources.IppsDrgEntryResource;
import gov.cms.fiss.pricers.ipps.resources.IppsExtractionUtil;
import io.dropwizard.core.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class IppsPricerApplication
extends OpenApiPricerApplication<IppsPricerConfiguration> {
    public static void main(String[] args) throws Exception {
        new IppsPricerApplication().run(args);
    }

    @Override
    public String getName() {
        return "ipps-pricer";
    }

    @Override
    protected void configureApplication(IppsPricerConfiguration configuration, Environment environment) {
        DataTables.loadDataTables(configuration);
        IppsClaimPricingResource v2Resource = new IppsClaimPricingResource(new IppsPricerDispatch(configuration));
        environment.jersey().register(v2Resource);
        environment.jersey().register(new CbsaWageIndexResource(configuration, IppsExtractionUtil.CBSA_EXTRACTOR));
        environment.jersey().register(new IppsDrgEntryResource(configuration));
    }

    @Override
    protected void customizeJacksonMapper(ObjectMapper objectMapper) {
        super.customizeJacksonMapper(objectMapper);
        objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
    }

    @Override
    protected List<OpenApiCustomizer> getContractCustomizers() {
        ArrayList<OpenApiCustomizer> customizers = new ArrayList<OpenApiCustomizer>(super.getContractCustomizers());
        customizers.add((configuration, environment, oas) -> oas.info(new Info().title("IPPS Pricer").version("v1")));
        return customizers;
    }

    @Override
    protected List<Package> getResourcePackages() {
        return Collections.singletonList(IppsClaimPricingResource.class.getPackage());
    }

    @Override
    protected Map<Integer, String> getCalculationVersions() {
        return Map.of(2019, "2019.2", 2020, "2020.5", 2021, "2021.6", 2022, "2022.3", 2023, "2023.3", 2024, "2024.1", 2025, "2025.1", 2026, "2026.1");
    }
}

