/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.billing_validation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;

public class ValidateDischargeDateVsEffectiveDate
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public boolean shouldExecute(IppsPricerContext calculationContext) {
        return ResultCode.RC_00_OK.equals((Object)calculationContext.getResultCode());
    }

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        if (LocalDateUtils.isBefore(calculationContext.getDischargeDate(), calculationContext.getEffectiveDate()) || LocalDateUtils.isBefore(calculationContext.getDischargeDate(), calculationContext.getCbsaReference().getEffectiveDate())) {
            calculationContext.applyResultCode(ResultCode.RC_55_DISCHRG_DT_LT_EFF_START_DT);
        }
    }
}

