/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.ArrayUtils;

public class CalculateOperAndCapitalCostOutliers
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public boolean shouldExecute(IppsPricerContext calculationContext) {
        return !ArrayUtils.contains((Object[])new ResultCode[]{ResultCode.RC_65_PAY_CODE_NOT_ABC, ResultCode.RC_67_OUTLIER_LOS_GT_COVERED_DAYS, ResultCode.RC_68_INVALID_VBPF_IN_PSF}, (Object)calculationContext.getResultCode());
    }

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        if (calculationContext.isOutlierReconciliation()) {
            calculationContext.setOperatingCostToChargeRatio(calculationContext.getOperatingCostToChargeRatio().add(new BigDecimal("0.2")).setScale(3, RoundingMode.HALF_UP));
        }
        if (BigDecimalUtils.isGreaterThanZero(calculationContext.getCapitalOperatingCostToChargeRatio()) || BigDecimalUtils.isGreaterThanZero(calculationContext.getOperatingCostToChargeRatio())) {
            calculationContext.setOperatingShareDollarThreshold(calculationContext.getOperatingCostToChargeRatio().divide(calculationContext.getOperatingCostToChargeRatio().add(calculationContext.getCapitalOperatingCostToChargeRatio()), 9, RoundingMode.HALF_UP));
            calculationContext.setCapitalShareDollarThreshold(calculationContext.getCapitalOperatingCostToChargeRatio().divide(calculationContext.getOperatingCostToChargeRatio().add(calculationContext.getCapitalOperatingCostToChargeRatio()), 9, RoundingMode.HALF_UP));
        }
    }
}

