/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.EvaluatingCalculationRule;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.math.BigDecimal;
import java.util.List;

public class CalculateTotals
extends EvaluatingCalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    public CalculateTotals(List<CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext>> calculationRules) {
        super(calculationRules);
    }

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        BigDecimal operChargeThreshold = calculationContext.getOperatingChargeThreshold();
        BigDecimal operDollarThreshold = calculationContext.getOperatingDollarThreshold();
        if (!calculationContext.isErrorResult()) {
            super.calculate(calculationContext);
        }
        if (calculationContext.isErrorResult()) {
            calculationContext.zeroResponse();
        }
        if (ResultCode.RC_67_OUTLIER_LOS_GT_COVERED_DAYS == calculationContext.getResultCode()) {
            calculationContext.setOperatingChargeThreshold(operChargeThreshold);
            calculationContext.setOperatingDollarThreshold(operDollarThreshold);
        }
    }
}

