/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class DetermineOutlierCosts
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (StringUtils.equals(providerData.getNewHospital(), "Y")) {
            calculationContext.setCapitalOutlierCostPart(BigDecimal.ZERO);
        }
        if (BigDecimalUtils.isGreaterThanZero(calculationContext.getOperatingOutlierCostPart().add(calculationContext.getCapitalOutlierCostPart()))) {
            calculationContext.setOperatingOutlierPart(calculationContext.getOperatingOutlierCostPart());
            calculationContext.setCapitalOutlierPart(calculationContext.getCapitalOutlierCostPart());
            calculationContext.applyResultCode(ResultCode.RC_02_TRANSFER_PAID_AS_OUTLIER);
        }
        if (calculationContext.isOutlierReconciliation()) {
            if (BigDecimalUtils.isGreaterThanZero(calculationContext.getOperatingOutlierCostPart().add(calculationContext.getCapitalOutlierCostPart()))) {
                calculationContext.setOutlierAdjustmentEnabled(true);
            }
        } else {
            this.dollarThresholdRTCBlock(calculationContext);
            this.costOutlierWithLOSBlock(calculationContext);
            if (StringUtils.equals(providerData.getCapitalPpsPaymentCode(), "B")) {
                calculationContext.setCapital2BOutlierPart(calculationContext.getCapitalOutlierPart());
            }
            if (StringUtils.equals(providerData.getCapitalPpsPaymentCode(), "C") && BigDecimalUtils.isGreaterThanZero(calculationContext.getCapitalPaycodePct1())) {
                calculationContext.setCapital2BOutlierPart(calculationContext.getCapitalOutlierPart().divide(calculationContext.getCapitalPaycodePct1(), 9, RoundingMode.HALF_UP));
            } else {
                calculationContext.setCapital2BOutlierPart(BigDecimal.ZERO);
            }
        }
    }

    protected void dollarThresholdRTCBlock(IppsPricerContext calculationContext) {
        calculationContext.setOperatingDollarThreshold(BigDecimal.ZERO);
        if (calculationContext.getResultCode() == ResultCode.RC_02_TRANSFER_PAID_AS_OUTLIER) {
            if (BigDecimalUtils.isGreaterThanZero(calculationContext.getCapitalOperatingCostToChargeRatio()) || BigDecimalUtils.isGreaterThanZero(calculationContext.getOperatingCostToChargeRatio())) {
                calculationContext.setOperatingDollarThreshold(calculationContext.getCapitalCostOutlier().add(calculationContext.getOperatingCostOutlier()).divide(calculationContext.getCapitalOperatingCostToChargeRatio().add(calculationContext.getOperatingCostToChargeRatio()), 9, RoundingMode.HALF_UP));
            } else {
                calculationContext.setOperatingDollarThreshold(BigDecimal.ZERO);
            }
        }
    }

    protected void costOutlierWithLOSBlock(IppsPricerContext calculationContext) {
        IppsClaimData claimData = calculationContext.getClaimData();
        if (calculationContext.getResultCode() == ResultCode.RC_02_TRANSFER_PAID_AS_OUTLIER && (claimData.getLengthOfStay() > calculationContext.getRegularDays() + claimData.getLifetimeReserveDays() || calculationContext.isCostOutlierThresholdClaim())) {
            calculationContext.applyResultCode(ResultCode.RC_67_OUTLIER_LOS_GT_COVERED_DAYS);
        }
    }
}

