/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.totals;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class CalculateCapitalIntermediateVariables
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        calculationContext.setCapital2PayCode(providerData.getCapitalPpsPaymentCode());
        this.capitalPpsPayCodeBlock(calculationContext);
        calculationContext.setCapitalFederalSpecificPortion(calculationContext.getCapitalFederalSpecificPortionPct().multiply(calculationContext.getCapitalFederalSpecificPortionPart()).setScale(2, RoundingMode.HALF_UP));
        calculationContext.setCapitalExceptionPaymentRate(providerData.getCapitalExceptionPaymentRate());
        calculationContext.setCapitalDisproportionateShareHospitalAdjustment(calculationContext.getCapitalFederalSpecificPortion().multiply(calculationContext.getCapitalDisproportionateShareHospital()).setScale(2, RoundingMode.HALF_UP));
        calculationContext.setCapitalIndirectMedicalEducationAdj(calculationContext.getCapitalFederalSpecificPortion().multiply(calculationContext.getCapitalIndirectMedicalEducation()).setScale(2, RoundingMode.HALF_UP));
        calculationContext.setCapitalOutlierCost(calculationContext.getCapitalOutlierPart().multiply(BigDecimal.ONE).setScale(2, RoundingMode.HALF_UP));
        if (StringUtils.equals(providerData.getNewHospital(), "Y")) {
            calculationContext.getPaymentData().setTotalPayment(BigDecimal.ZERO);
            calculationContext.setCapitalFederalSpecificPortion(BigDecimal.ZERO);
            calculationContext.setCapitalExceptionPaymentRate(BigDecimal.ZERO);
            calculationContext.setCapitalDisproportionateShareHospitalAdjustment(BigDecimal.ZERO);
            calculationContext.setCapitalIndirectMedicalEducationAdj(BigDecimal.ZERO);
            calculationContext.setCapitalOutlierCost(BigDecimal.ZERO);
        }
    }

    private void capitalPpsPayCodeBlock(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (StringUtils.equals(providerData.getCapitalPpsPaymentCode(), "B")) {
            calculationContext.setCapitalOldHoldHarmless(BigDecimal.ZERO);
            calculationContext.setCapitalFederalSpecificPortionPct(BigDecimal.ONE);
        }
        if (StringUtils.equals(providerData.getCapitalPpsPaymentCode(), "C")) {
            calculationContext.setCapitalOldHoldHarmless(BigDecimal.ZERO);
            calculationContext.setCapitalFederalSpecificPortionPct(calculationContext.getCapitalPaycodePct1());
        }
    }
}

