/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.cost_factor_determination;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.tables.DataTables;
import gov.cms.fiss.pricers.ipps.core.tables.MidnightTableEntry;

public class AdjustForMidnightFactors
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public boolean shouldExecute(IppsPricerContext calculationContext) {
        return calculationContext.getGeolocationAsInt() >= 9400 && calculationContext.getGeolocationAsInt() <= 9900;
    }

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        DataTables dataTables = calculationContext.getDataTables();
        MidnightTableEntry entry = dataTables.getMidnightEntry(calculationContext.getMidnightAdjustmentGeolocation());
        if (entry != null) {
            calculationContext.setMidnightAdjustmentFactor(entry.getAdjustmentFactor());
        }
    }
}

