/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.cost_factor_determination.ratex;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class DetermineRateTableWithoutReduction
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        if (StringUtils.equals(providerData.getHospitalQualityIndicator(), "1") && StringUtils.isBlank(providerData.getEhrReductionIndicator()) && BigDecimalUtils.isGreaterThan(cbsaReference.getWageIndex(), BigDecimal.ONE)) {
            calculationContext.setRatexTable("tab1");
        }
        if (!StringUtils.equals(providerData.getHospitalQualityIndicator(), "1") && StringUtils.isBlank(providerData.getEhrReductionIndicator()) && BigDecimalUtils.isGreaterThan(cbsaReference.getWageIndex(), BigDecimal.ONE)) {
            calculationContext.setRatexTable("tab2");
        }
        if (StringUtils.equals(providerData.getHospitalQualityIndicator(), "1") && StringUtils.isBlank(providerData.getEhrReductionIndicator()) && BigDecimalUtils.isLessThanOrEqualTo(cbsaReference.getWageIndex(), BigDecimal.ONE)) {
            calculationContext.setRatexTable("tab3");
        }
        if (!StringUtils.equals(providerData.getHospitalQualityIndicator(), "1") && StringUtils.isBlank(providerData.getEhrReductionIndicator()) && BigDecimalUtils.isLessThanOrEqualTo(cbsaReference.getWageIndex(), BigDecimal.ONE)) {
            calculationContext.setRatexTable("tab4");
        }
    }
}

