/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.rules2021.calculate_payment;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.DetermineOutlierCosts;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DetermineOutlierCosts2021
extends DetermineOutlierCosts {
    @Override
    protected void dollarThresholdRTCBlock(IppsPricerContext calculationContext) {
        calculationContext.setOperatingChargeThreshold(BigDecimal.ZERO);
        if (calculationContext.getResultCode() == ResultCode.RC_02_TRANSFER_PAID_AS_OUTLIER) {
            if (BigDecimalUtils.isGreaterThanZero(calculationContext.getCapitalOperatingCostToChargeRatio()) || BigDecimalUtils.isGreaterThanZero(calculationContext.getOperatingCostToChargeRatio())) {
                calculationContext.setOperatingChargeThreshold(calculationContext.getCapitalCostOutlier().add(calculationContext.getOperatingCostOutlier()).divide(calculationContext.getCapitalOperatingCostToChargeRatio().add(calculationContext.getOperatingCostToChargeRatio()), 9, RoundingMode.HALF_UP));
            } else {
                calculationContext.setOperatingChargeThreshold(BigDecimal.ZERO);
            }
        }
    }
}

