/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.rules2021.wage_index;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class AdjustIndexForQuartile2021
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        BigDecimal wageIndexQuartileLimit = calculationContext.getWageIndexQuartileLimit();
        if (cbsaReference.getWageIndex() != null && BigDecimalUtils.isLessThan(cbsaReference.getWageIndex(), wageIndexQuartileLimit)) {
            cbsaReference.setWageIndex(wageIndexQuartileLimit.subtract(cbsaReference.getWageIndex()).multiply(new BigDecimal("0.5")).add(cbsaReference.getWageIndex()).setScale(4, RoundingMode.HALF_UP));
        }
    }
}

