/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.tables;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@JsonDeserialize(builder=RatexTableEntryBuilder.class)
@JsonPropertyOrder(value={"tableNumber", "scope", "largeUrban", "regLabor", "regNLabor"})
@Immutable
public class RatexTableEntry {
    @Pattern(regexp="tab\\d+")
    private final @Pattern(regexp="tab\\d+") String tableNumber;
    private final Scope scope;
    @Max(value=2L)
    @Min(value=1L)
    private final @Max(value=2L) @Min(value=1L) int largeUrban;
    @Digits(integer=5, fraction=2)
    private final @Digits(integer=5, fraction=2) BigDecimal regLabor;
    @Digits(integer=5, fraction=2)
    private final @Digits(integer=5, fraction=2) BigDecimal regNLabor;

    public boolean isLargeUrban() {
        return Objects.equals(this.largeUrban, 1);
    }

    public RatexTableEntryBuilder copyBuilder() {
        return RatexTableEntry.builder().tableNumber(this.getTableNumber()).scope(this.getScope()).largeUrban(this.getLargeUrban()).regLabor(this.getRegLabor()).regNLabor(this.getRegNLabor());
    }

    @Generated
    RatexTableEntry(String tableNumber, Scope scope, int largeUrban, BigDecimal regLabor, BigDecimal regNLabor) {
        this.tableNumber = tableNumber;
        this.scope = scope;
        this.largeUrban = largeUrban;
        this.regLabor = regLabor;
        this.regNLabor = regNLabor;
    }

    @Generated
    public static RatexTableEntryBuilder builder() {
        return new RatexTableEntryBuilder();
    }

    @Generated
    public String getTableNumber() {
        return this.tableNumber;
    }

    @Generated
    public Scope getScope() {
        return this.scope;
    }

    @Generated
    public int getLargeUrban() {
        return this.largeUrban;
    }

    @Generated
    public BigDecimal getRegLabor() {
        return this.regLabor;
    }

    @Generated
    public BigDecimal getRegNLabor() {
        return this.regNLabor;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class RatexTableEntryBuilder {
        @Generated
        private String tableNumber;
        @Generated
        private Scope scope;
        @Generated
        private int largeUrban;
        @Generated
        private BigDecimal regLabor;
        @Generated
        private BigDecimal regNLabor;

        @Generated
        RatexTableEntryBuilder() {
        }

        @Generated
        public RatexTableEntryBuilder tableNumber(String tableNumber) {
            this.tableNumber = tableNumber;
            return this;
        }

        @Generated
        public RatexTableEntryBuilder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        @Generated
        public RatexTableEntryBuilder largeUrban(int largeUrban) {
            this.largeUrban = largeUrban;
            return this;
        }

        @Generated
        public RatexTableEntryBuilder regLabor(BigDecimal regLabor) {
            this.regLabor = regLabor;
            return this;
        }

        @Generated
        public RatexTableEntryBuilder regNLabor(BigDecimal regNLabor) {
            this.regNLabor = regNLabor;
            return this;
        }

        @Generated
        public RatexTableEntry build() {
            return new RatexTableEntry(this.tableNumber, this.scope, this.largeUrban, this.regLabor, this.regNLabor);
        }

        @Generated
        public String toString() {
            return "RatexTableEntry.RatexTableEntryBuilder(tableNumber=" + this.tableNumber + ", scope=" + this.scope + ", largeUrban=" + this.largeUrban + ", regLabor=" + this.regLabor + ", regNLabor=" + this.regNLabor + ")";
        }
    }

    public static enum Scope {
        NAT("nat"),
        PR("pr"),
        NAT_PR("natpr");

        private final String referenceName;

        private Scope(String referenceName) {
            this.referenceName = referenceName;
        }

        public static Scope fromReference(String referenceName) {
            for (Scope scope : Scope.values()) {
                if (!scope.referenceName.equals(referenceName)) continue;
                return scope;
            }
            throw new IllegalArgumentException("Invalid scope reference: " + referenceName);
        }
    }

    @Generated
    public static final class Fields {
        public static final String TABLE_NUMBER = "tableNumber";
        public static final String SCOPE = "scope";
        public static final String LARGE_URBAN = "largeUrban";
        public static final String REG_LABOR = "regLabor";
        public static final String REG_N_LABOR = "regNLabor";
    }

    public static final class RatexKey {
        private final String table;
        private final Scope scope;
        private final boolean isLargeUrban;

        public static RatexKey fromRatex(RatexTableEntry ratexTableEntry) {
            return new RatexKey(ratexTableEntry.getTableNumber(), ratexTableEntry.getScope(), ratexTableEntry.isLargeUrban());
        }

        @Generated
        public RatexKey(String table, Scope scope, boolean isLargeUrban) {
            this.table = table;
            this.scope = scope;
            this.isLargeUrban = isLargeUrban;
        }

        @Generated
        public String getTable() {
            return this.table;
        }

        @Generated
        public Scope getScope() {
            return this.scope;
        }

        @Generated
        public boolean isLargeUrban() {
            return this.isLargeUrban;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RatexKey)) {
                return false;
            }
            RatexKey other = (RatexKey)o;
            if (this.isLargeUrban() != other.isLargeUrban()) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            return !(this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isLargeUrban() ? 79 : 97);
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RatexTableEntry.RatexKey(table=" + this.getTable() + ", scope=" + this.getScope() + ", isLargeUrban=" + this.isLargeUrban() + ")";
        }
    }
}

