/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.helper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrefixPattern {
    private final String prefixChars_;
    private final Pattern prefixPattern_;

    public PrefixPattern(String prefixChars) {
        this.prefixChars_ = prefixChars;
        this.prefixPattern_ = PrefixPattern.compilePrefixPattern(prefixChars);
    }

    public boolean match(String str) {
        Matcher m4 = this.prefixPattern_.matcher(str);
        return m4.find() && !m4.group(0).equals(str);
    }

    public boolean matchLongFlag(String str) {
        Matcher m4 = this.prefixPattern_.matcher(str);
        return m4.find() && !m4.group(0).equals(str) && m4.group(0).length() >= 2;
    }

    public boolean matchShortFlag(String str) {
        Matcher m4 = this.prefixPattern_.matcher(str);
        return m4.find() && !m4.group(0).equals(str) && m4.group(0).length() == 1;
    }

    public String removePrefix(String str) {
        Matcher m4 = this.prefixPattern_.matcher(str);
        if (m4.find() && !m4.group(0).equals(str)) {
            return m4.replaceFirst("");
        }
        return str;
    }

    public String getPrefixChars() {
        return this.prefixChars_;
    }

    public Pattern getPrefixPattern() {
        return this.prefixPattern_;
    }

    private static Pattern compilePrefixPattern(String prefixChars) {
        String qs = Pattern.quote(prefixChars);
        return Pattern.compile("^[" + qs + "]+");
    }
}

