// Generated by delombok at Tue Dec 23 17:06:13 UTC 2025
package gov.cms.fiss.pricers.ipps.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.api.validation.ValidDiagnosisRelatedGroup;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

@Schema(description = "The IPPS claim data.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-NEW-DATA", value = "<structure>")})})
public class IppsClaimData extends ClaimData {
  @ArraySchema(arraySchema = @Schema(description = "The condition codes related to this claim.", example = "[\n" + "\"ZA\",\n" + "\"ZB\",\n" + "\"ZC\",\n" + "\"ZD\",\n" + "\"ZE\"\n" + "]", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-CONDITION-CODE-TABLE", value = "B-CONDITION-CODE    PIC X(07) OCCURS 25 TIMES\n" + "INDEXED BY IDX-COND", parseValue = true)})}), uniqueItems = true)
  @Size(max = 25, min = 1)
  private List<@Pattern(regexp = "[A-Z\\d]{2,7}", message = "must be two to seven alphanumeric characters") String> conditionCodes;
  @BigDecimalScale
  @DecimalMax("999999999.99")
  @DecimalMin("0")
  @Digits(integer = 9, fraction = 2)
  @NotNull
  @Schema(description = "The charges covered by the claim.", example = "903845.76", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-CHARGES-CLAIMED", value = "PIC 9(09)V9(02)")})})
  private BigDecimal coveredCharges;
  @Max(999)
  @Min(0)
  @NotNull
  @Schema(description = "The covered days.", example = "3", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-COVERED-DAYS", value = "PIC 9(03)")})})
  private Integer coveredDays;
  @ArraySchema(arraySchema = @Schema(description = "The demo codes related to this claim.", example = "[\"61\"]", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-DEMO-DATA", value = "B-DEMO-CODE1           PIC X(02)\n" + "B-DEMO-CODE2           PIC X(02)\n" + "B-DEMO-CODE3           PIC X(02)\n" + "B-DEMO-CODE4           PIC X(02)", parseValue = true)})}))
  @Size(max = 4, min = 1)
  private List<@Pattern(regexp = "[A-Z\\d]{2}", message = "must be two alphanumeric characters") String> demoCodes;
  @ArraySchema(arraySchema = @Schema(description = "The diagnosis codes related to this claim.", example = "[\n" + "\"N390\",\n" + "\"B952\",\n" + "\"I130\",\n" + "\"I5032\",\n" + "\"N179\",\n" + "\"M25511\",\n" + "\"M549\"\n" + "]", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-DIAGNOSIS-CODE-TABLE", value = "B-DIAGNOSIS-CODE    PIC X(07) OCCURS 25 TIMES\n" + "INDEXED BY IDX-DIAG", parseValue = true)})}))
  @Size(max = 25, min = 1)
  private List<@Pattern(regexp = "[A-Z\\d]{2,7}", message = "must be two to seven alphanumeric characters") String> diagnosisCodes;
  @NotNull
  @ValidDiagnosisRelatedGroup
  @Schema(description = "The diagnosis-related group.", example = "001", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-DRG", value = "PIC 9(03)")})})
  private String diagnosisRelatedGroup;
  @Pattern(regexp = "[A-Z\\d]", message = "must be an alphanumeric character")
  @Schema(description = "The diagnosis-related group severity.", example = "X")
  private String diagnosisRelatedGroupSeverity;
  @NotNull
  @Schema(description = "The discharge date.", example = "2020-05-13", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-DISCHARGE-DATE", value = "B-DISCHG-CC        PIC 9(02)\n" + "B-DISCHG-YY        PIC 9(02)\n" + "B-DISCHG-MM        PIC 9(02)\n" + "B-DISCHG-DD        PIC 9(02)", parseValue = true)})})
  @StrictLocalDate
  private LocalDate dischargeDate;
  @Max(999)
  @Min(0)
  @NotNull
  @Schema(description = "The length of stay (LOS).", example = "3", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-LOS", value = "PIC 9(03)")})})
  private Integer lengthOfStay;
  @Max(99)
  @Min(0)
  @NotNull
  @Schema(description = "The lifetime reserve days.", example = "2", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-LTR-DAYS", value = "PIC 9(02)")})})
  private Integer lifetimeReserveDays;
  @Pattern(regexp = "\\d{4}|\\d{2}", message = "must be two or four digits")
  @Schema(description = "The condition codes related to this claim.", example = "6120", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "P-NEW-GEO-LOC-MSA9", value = "REDEFINES P-NEW-GEO-LOC-MSAX  PIC 9(04)")})})
  private String midnightAdjustmentGeolocation;
  @ArraySchema(arraySchema = @Schema(description = "The national drug codes related to this claim.", example = "[\n" + "\"70842012001\",\n" + "\"65293000901\",\n" + "\"389475235\",\n" + "\"0934764436\"\n" + "]", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-NDC-DATA", value = "B-NDC-NUMBER        PIC X(11) OCCURS 449 TIMES\n" + "INDEXED BY IDX-NDC", parseValue = true)})}))
  @Size(max = 449, min = 1)
  private List<@Pattern(regexp = "\\d{9,11}", message = "must be nine to eleven digits") String> nationalDrugCodes;
  @ArraySchema(arraySchema = @Schema(description = "The procedure codes related to this claim.", example = "[\n" + "\"04VD3FZ\",\n" + "\"XNS0032\",\n" + "\"XW033F3\",\n" + "\"3E0J7U1\",\n" + "\"3E0J7U1\",\n" + "\"0JH60DZ\"\n" + "]", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-PROCEDURE-CODE-TABLE", value = "B-PROCEDURE-CODE    PIC X(07) OCCURS 25 TIMES\n" + "INDEXED BY IDX-PROC", parseValue = true)})}))
  @Size(max = 25, min = 1)
  private List<@Pattern(regexp = "[A-Z\\d]{2,7}", message = "must be two to seven alphanumeric characters") String> procedureCodes;
  @NotNull
  @Pattern(regexp = "\\d{2}", message = "must be two digits")
  @Schema(description = "The code indicating the state of claim review.", example = "11", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-REVIEW-CODE", value = "PIC 9(02)")})})
  private String reviewCode;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "[A-Z\\d]{2,7}", message = "must be two to seven alphanumeric characters") String> getConditionCodes() {
    return this.conditionCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCoveredCharges() {
    return this.coveredCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getCoveredDays() {
    return this.coveredDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "[A-Z\\d]{2}", message = "must be two alphanumeric characters") String> getDemoCodes() {
    return this.demoCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "[A-Z\\d]{2,7}", message = "must be two to seven alphanumeric characters") String> getDiagnosisCodes() {
    return this.diagnosisCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDiagnosisRelatedGroup() {
    return this.diagnosisRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDiagnosisRelatedGroupSeverity() {
    return this.diagnosisRelatedGroupSeverity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getDischargeDate() {
    return this.dischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getLengthOfStay() {
    return this.lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getLifetimeReserveDays() {
    return this.lifetimeReserveDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getMidnightAdjustmentGeolocation() {
    return this.midnightAdjustmentGeolocation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "\\d{9,11}", message = "must be nine to eleven digits") String> getNationalDrugCodes() {
    return this.nationalDrugCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "[A-Z\\d]{2,7}", message = "must be two to seven alphanumeric characters") String> getProcedureCodes() {
    return this.procedureCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReviewCode() {
    return this.reviewCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setConditionCodes(final List<@Pattern(regexp = "[A-Z\\d]{2,7}", message = "must be two to seven alphanumeric characters") String> conditionCodes) {
    this.conditionCodes = conditionCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoveredCharges(final BigDecimal coveredCharges) {
    this.coveredCharges = coveredCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoveredDays(final Integer coveredDays) {
    this.coveredDays = coveredDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDemoCodes(final List<@Pattern(regexp = "[A-Z\\d]{2}", message = "must be two alphanumeric characters") String> demoCodes) {
    this.demoCodes = demoCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisCodes(final List<@Pattern(regexp = "[A-Z\\d]{2,7}", message = "must be two to seven alphanumeric characters") String> diagnosisCodes) {
    this.diagnosisCodes = diagnosisCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisRelatedGroup(final String diagnosisRelatedGroup) {
    this.diagnosisRelatedGroup = diagnosisRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisRelatedGroupSeverity(final String diagnosisRelatedGroupSeverity) {
    this.diagnosisRelatedGroupSeverity = diagnosisRelatedGroupSeverity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDischargeDate(final LocalDate dischargeDate) {
    this.dischargeDate = dischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLengthOfStay(final Integer lengthOfStay) {
    this.lengthOfStay = lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLifetimeReserveDays(final Integer lifetimeReserveDays) {
    this.lifetimeReserveDays = lifetimeReserveDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMidnightAdjustmentGeolocation(final String midnightAdjustmentGeolocation) {
    this.midnightAdjustmentGeolocation = midnightAdjustmentGeolocation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalDrugCodes(final List<@Pattern(regexp = "\\d{9,11}", message = "must be nine to eleven digits") String> nationalDrugCodes) {
    this.nationalDrugCodes = nationalDrugCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProcedureCodes(final List<@Pattern(regexp = "[A-Z\\d]{2,7}", message = "must be two to seven alphanumeric characters") String> procedureCodes) {
    this.procedureCodes = procedureCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReviewCode(final String reviewCode) {
    this.reviewCode = reviewCode;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof IppsClaimData)) return false;
    final IppsClaimData other = (IppsClaimData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    final java.lang.Object this$coveredDays = this.getCoveredDays();
    final java.lang.Object other$coveredDays = other.getCoveredDays();
    if (this$coveredDays == null ? other$coveredDays != null : !this$coveredDays.equals(other$coveredDays)) return false;
    final java.lang.Object this$lengthOfStay = this.getLengthOfStay();
    final java.lang.Object other$lengthOfStay = other.getLengthOfStay();
    if (this$lengthOfStay == null ? other$lengthOfStay != null : !this$lengthOfStay.equals(other$lengthOfStay)) return false;
    final java.lang.Object this$lifetimeReserveDays = this.getLifetimeReserveDays();
    final java.lang.Object other$lifetimeReserveDays = other.getLifetimeReserveDays();
    if (this$lifetimeReserveDays == null ? other$lifetimeReserveDays != null : !this$lifetimeReserveDays.equals(other$lifetimeReserveDays)) return false;
    final java.lang.Object this$conditionCodes = this.getConditionCodes();
    final java.lang.Object other$conditionCodes = other.getConditionCodes();
    if (this$conditionCodes == null ? other$conditionCodes != null : !this$conditionCodes.equals(other$conditionCodes)) return false;
    final java.lang.Object this$coveredCharges = this.getCoveredCharges();
    final java.lang.Object other$coveredCharges = other.getCoveredCharges();
    if (this$coveredCharges == null ? other$coveredCharges != null : !this$coveredCharges.equals(other$coveredCharges)) return false;
    final java.lang.Object this$demoCodes = this.getDemoCodes();
    final java.lang.Object other$demoCodes = other.getDemoCodes();
    if (this$demoCodes == null ? other$demoCodes != null : !this$demoCodes.equals(other$demoCodes)) return false;
    final java.lang.Object this$diagnosisCodes = this.getDiagnosisCodes();
    final java.lang.Object other$diagnosisCodes = other.getDiagnosisCodes();
    if (this$diagnosisCodes == null ? other$diagnosisCodes != null : !this$diagnosisCodes.equals(other$diagnosisCodes)) return false;
    final java.lang.Object this$diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
    final java.lang.Object other$diagnosisRelatedGroup = other.getDiagnosisRelatedGroup();
    if (this$diagnosisRelatedGroup == null ? other$diagnosisRelatedGroup != null : !this$diagnosisRelatedGroup.equals(other$diagnosisRelatedGroup)) return false;
    final java.lang.Object this$diagnosisRelatedGroupSeverity = this.getDiagnosisRelatedGroupSeverity();
    final java.lang.Object other$diagnosisRelatedGroupSeverity = other.getDiagnosisRelatedGroupSeverity();
    if (this$diagnosisRelatedGroupSeverity == null ? other$diagnosisRelatedGroupSeverity != null : !this$diagnosisRelatedGroupSeverity.equals(other$diagnosisRelatedGroupSeverity)) return false;
    final java.lang.Object this$dischargeDate = this.getDischargeDate();
    final java.lang.Object other$dischargeDate = other.getDischargeDate();
    if (this$dischargeDate == null ? other$dischargeDate != null : !this$dischargeDate.equals(other$dischargeDate)) return false;
    final java.lang.Object this$midnightAdjustmentGeolocation = this.getMidnightAdjustmentGeolocation();
    final java.lang.Object other$midnightAdjustmentGeolocation = other.getMidnightAdjustmentGeolocation();
    if (this$midnightAdjustmentGeolocation == null ? other$midnightAdjustmentGeolocation != null : !this$midnightAdjustmentGeolocation.equals(other$midnightAdjustmentGeolocation)) return false;
    final java.lang.Object this$nationalDrugCodes = this.getNationalDrugCodes();
    final java.lang.Object other$nationalDrugCodes = other.getNationalDrugCodes();
    if (this$nationalDrugCodes == null ? other$nationalDrugCodes != null : !this$nationalDrugCodes.equals(other$nationalDrugCodes)) return false;
    final java.lang.Object this$procedureCodes = this.getProcedureCodes();
    final java.lang.Object other$procedureCodes = other.getProcedureCodes();
    if (this$procedureCodes == null ? other$procedureCodes != null : !this$procedureCodes.equals(other$procedureCodes)) return false;
    final java.lang.Object this$reviewCode = this.getReviewCode();
    final java.lang.Object other$reviewCode = other.getReviewCode();
    if (this$reviewCode == null ? other$reviewCode != null : !this$reviewCode.equals(other$reviewCode)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof IppsClaimData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    final java.lang.Object $coveredDays = this.getCoveredDays();
    result = result * PRIME + ($coveredDays == null ? 43 : $coveredDays.hashCode());
    final java.lang.Object $lengthOfStay = this.getLengthOfStay();
    result = result * PRIME + ($lengthOfStay == null ? 43 : $lengthOfStay.hashCode());
    final java.lang.Object $lifetimeReserveDays = this.getLifetimeReserveDays();
    result = result * PRIME + ($lifetimeReserveDays == null ? 43 : $lifetimeReserveDays.hashCode());
    final java.lang.Object $conditionCodes = this.getConditionCodes();
    result = result * PRIME + ($conditionCodes == null ? 43 : $conditionCodes.hashCode());
    final java.lang.Object $coveredCharges = this.getCoveredCharges();
    result = result * PRIME + ($coveredCharges == null ? 43 : $coveredCharges.hashCode());
    final java.lang.Object $demoCodes = this.getDemoCodes();
    result = result * PRIME + ($demoCodes == null ? 43 : $demoCodes.hashCode());
    final java.lang.Object $diagnosisCodes = this.getDiagnosisCodes();
    result = result * PRIME + ($diagnosisCodes == null ? 43 : $diagnosisCodes.hashCode());
    final java.lang.Object $diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
    result = result * PRIME + ($diagnosisRelatedGroup == null ? 43 : $diagnosisRelatedGroup.hashCode());
    final java.lang.Object $diagnosisRelatedGroupSeverity = this.getDiagnosisRelatedGroupSeverity();
    result = result * PRIME + ($diagnosisRelatedGroupSeverity == null ? 43 : $diagnosisRelatedGroupSeverity.hashCode());
    final java.lang.Object $dischargeDate = this.getDischargeDate();
    result = result * PRIME + ($dischargeDate == null ? 43 : $dischargeDate.hashCode());
    final java.lang.Object $midnightAdjustmentGeolocation = this.getMidnightAdjustmentGeolocation();
    result = result * PRIME + ($midnightAdjustmentGeolocation == null ? 43 : $midnightAdjustmentGeolocation.hashCode());
    final java.lang.Object $nationalDrugCodes = this.getNationalDrugCodes();
    result = result * PRIME + ($nationalDrugCodes == null ? 43 : $nationalDrugCodes.hashCode());
    final java.lang.Object $procedureCodes = this.getProcedureCodes();
    result = result * PRIME + ($procedureCodes == null ? 43 : $procedureCodes.hashCode());
    final java.lang.Object $reviewCode = this.getReviewCode();
    result = result * PRIME + ($reviewCode == null ? 43 : $reviewCode.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "IppsClaimData(conditionCodes=" + this.getConditionCodes() + ", coveredCharges=" + this.getCoveredCharges() + ", coveredDays=" + this.getCoveredDays() + ", demoCodes=" + this.getDemoCodes() + ", diagnosisCodes=" + this.getDiagnosisCodes() + ", diagnosisRelatedGroup=" + this.getDiagnosisRelatedGroup() + ", diagnosisRelatedGroupSeverity=" + this.getDiagnosisRelatedGroupSeverity() + ", dischargeDate=" + this.getDischargeDate() + ", lengthOfStay=" + this.getLengthOfStay() + ", lifetimeReserveDays=" + this.getLifetimeReserveDays() + ", midnightAdjustmentGeolocation=" + this.getMidnightAdjustmentGeolocation() + ", nationalDrugCodes=" + this.getNationalDrugCodes() + ", procedureCodes=" + this.getProcedureCodes() + ", reviewCode=" + this.getReviewCode() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public IppsClaimData() {
  }
}
