// Generated by delombok at Tue Dec 23 17:06:13 UTC 2025
package gov.cms.fiss.pricers.ipps.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.math.RoundingMode;

@Schema(description = "The IPPS prospective payment data.", extensions = @Extension(name = "cobol-declaration", properties = @ExtensionProperty(name = "PPS-DATA", value = "<structure>")))
public class IppsPaymentData extends PaymentData {
  @BigDecimalScale(scale = 1, roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("99.9")
  @Digits(integer = 2, fraction = 1)
  @NotNull
  @Schema(description = "The average length of stay.", example = "12.1", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-AVG-LOS", value = "PIC 9(02)V9(01)")})})
  @FixedValue
  private BigDecimal averageLengthOfStay = BigDecimal.ZERO.setScale(1, RoundingMode.HALF_UP);
  @DecimalMin("0")
  @DecimalMax("99.9")
  @Digits(integer = 2, fraction = 1)
  @Schema(description = "The number of days cut off.", example = "15.2", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-DAYS-CUTOFF", value = "PIC 9(02)V9(01)")})})
  @FixedValue
  private BigDecimal daysCutoff;
  @Max(99)
  @Min(0)
  @NotNull
  @Schema(description = "The number of lifetime reserve days used.", example = "12", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-LTR-DAYS-USED", value = "PIC 9(02)")})})
  private int lifetimeReserveDaysUsed;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @NotNull
  @Schema(description = "The operating disproportionate share hospital adjustment.", example = "345879.06", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OPER-DSH-ADJ", value = "PIC 9(06)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal operatingDisproportionateShareHospitalAdjustment = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @NotNull
  @Schema(description = "The operating federal-specific portion part.", example = "39084.75", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OPER-FSP-PART", value = "PIC 9(06)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal operatingFederalSpecificPortionPart = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @NotNull
  @Schema(description = "The operating hospital-specific portion part.", example = "98734.56", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OPER-HSP-PART", value = "PIC 9(06)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal operatingHospitalSpecificPortionPart = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @NotNull
  @Schema(description = "The operating indirect medical education adjustment.", example = "239048.57", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OPER-IME-ADJ", value = "PIC 9(06)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal operatingIndirectMedicalEducationAdjustment = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @NotNull
  @Schema(description = "The operating outlier payment part.", example = "9823705.46", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OPER-OUTLIER-PART", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal operatingOutlierPaymentPart = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @Max(999)
  @Min(0)
  @NotNull
  @Schema(description = "The number of outlier days.", example = "3", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OUTLIER-DAYS", value = "PIC 9(03)")})})
  private int outlierDays;
  @Max(999)
  @Min(0)
  @NotNull
  @Schema(description = "The number of regular days used.", example = "90", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-REG-DAYS-USED", value = "PIC 9(03)")})})
  private int regularDaysUsed;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getAverageLengthOfStay() {
    return this.averageLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDaysCutoff() {
    return this.daysCutoff;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLifetimeReserveDaysUsed() {
    return this.lifetimeReserveDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingDisproportionateShareHospitalAdjustment() {
    return this.operatingDisproportionateShareHospitalAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingFederalSpecificPortionPart() {
    return this.operatingFederalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingHospitalSpecificPortionPart() {
    return this.operatingHospitalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingIndirectMedicalEducationAdjustment() {
    return this.operatingIndirectMedicalEducationAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingOutlierPaymentPart() {
    return this.operatingOutlierPaymentPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getOutlierDays() {
    return this.outlierDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getRegularDaysUsed() {
    return this.regularDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAverageLengthOfStay(final BigDecimal averageLengthOfStay) {
    this.averageLengthOfStay = averageLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDaysCutoff(final BigDecimal daysCutoff) {
    this.daysCutoff = daysCutoff;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLifetimeReserveDaysUsed(final int lifetimeReserveDaysUsed) {
    this.lifetimeReserveDaysUsed = lifetimeReserveDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingDisproportionateShareHospitalAdjustment(final BigDecimal operatingDisproportionateShareHospitalAdjustment) {
    this.operatingDisproportionateShareHospitalAdjustment = operatingDisproportionateShareHospitalAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingFederalSpecificPortionPart(final BigDecimal operatingFederalSpecificPortionPart) {
    this.operatingFederalSpecificPortionPart = operatingFederalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingHospitalSpecificPortionPart(final BigDecimal operatingHospitalSpecificPortionPart) {
    this.operatingHospitalSpecificPortionPart = operatingHospitalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingIndirectMedicalEducationAdjustment(final BigDecimal operatingIndirectMedicalEducationAdjustment) {
    this.operatingIndirectMedicalEducationAdjustment = operatingIndirectMedicalEducationAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingOutlierPaymentPart(final BigDecimal operatingOutlierPaymentPart) {
    this.operatingOutlierPaymentPart = operatingOutlierPaymentPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierDays(final int outlierDays) {
    this.outlierDays = outlierDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRegularDaysUsed(final int regularDaysUsed) {
    this.regularDaysUsed = regularDaysUsed;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof IppsPaymentData)) return false;
    final IppsPaymentData other = (IppsPaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    if (this.getLifetimeReserveDaysUsed() != other.getLifetimeReserveDaysUsed()) return false;
    if (this.getOutlierDays() != other.getOutlierDays()) return false;
    if (this.getRegularDaysUsed() != other.getRegularDaysUsed()) return false;
    final java.lang.Object this$averageLengthOfStay = this.getAverageLengthOfStay();
    final java.lang.Object other$averageLengthOfStay = other.getAverageLengthOfStay();
    if (this$averageLengthOfStay == null ? other$averageLengthOfStay != null : !this$averageLengthOfStay.equals(other$averageLengthOfStay)) return false;
    final java.lang.Object this$daysCutoff = this.getDaysCutoff();
    final java.lang.Object other$daysCutoff = other.getDaysCutoff();
    if (this$daysCutoff == null ? other$daysCutoff != null : !this$daysCutoff.equals(other$daysCutoff)) return false;
    final java.lang.Object this$operatingDisproportionateShareHospitalAdjustment = this.getOperatingDisproportionateShareHospitalAdjustment();
    final java.lang.Object other$operatingDisproportionateShareHospitalAdjustment = other.getOperatingDisproportionateShareHospitalAdjustment();
    if (this$operatingDisproportionateShareHospitalAdjustment == null ? other$operatingDisproportionateShareHospitalAdjustment != null : !this$operatingDisproportionateShareHospitalAdjustment.equals(other$operatingDisproportionateShareHospitalAdjustment)) return false;
    final java.lang.Object this$operatingFederalSpecificPortionPart = this.getOperatingFederalSpecificPortionPart();
    final java.lang.Object other$operatingFederalSpecificPortionPart = other.getOperatingFederalSpecificPortionPart();
    if (this$operatingFederalSpecificPortionPart == null ? other$operatingFederalSpecificPortionPart != null : !this$operatingFederalSpecificPortionPart.equals(other$operatingFederalSpecificPortionPart)) return false;
    final java.lang.Object this$operatingHospitalSpecificPortionPart = this.getOperatingHospitalSpecificPortionPart();
    final java.lang.Object other$operatingHospitalSpecificPortionPart = other.getOperatingHospitalSpecificPortionPart();
    if (this$operatingHospitalSpecificPortionPart == null ? other$operatingHospitalSpecificPortionPart != null : !this$operatingHospitalSpecificPortionPart.equals(other$operatingHospitalSpecificPortionPart)) return false;
    final java.lang.Object this$operatingIndirectMedicalEducationAdjustment = this.getOperatingIndirectMedicalEducationAdjustment();
    final java.lang.Object other$operatingIndirectMedicalEducationAdjustment = other.getOperatingIndirectMedicalEducationAdjustment();
    if (this$operatingIndirectMedicalEducationAdjustment == null ? other$operatingIndirectMedicalEducationAdjustment != null : !this$operatingIndirectMedicalEducationAdjustment.equals(other$operatingIndirectMedicalEducationAdjustment)) return false;
    final java.lang.Object this$operatingOutlierPaymentPart = this.getOperatingOutlierPaymentPart();
    final java.lang.Object other$operatingOutlierPaymentPart = other.getOperatingOutlierPaymentPart();
    if (this$operatingOutlierPaymentPart == null ? other$operatingOutlierPaymentPart != null : !this$operatingOutlierPaymentPart.equals(other$operatingOutlierPaymentPart)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof IppsPaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    result = result * PRIME + this.getLifetimeReserveDaysUsed();
    result = result * PRIME + this.getOutlierDays();
    result = result * PRIME + this.getRegularDaysUsed();
    final java.lang.Object $averageLengthOfStay = this.getAverageLengthOfStay();
    result = result * PRIME + ($averageLengthOfStay == null ? 43 : $averageLengthOfStay.hashCode());
    final java.lang.Object $daysCutoff = this.getDaysCutoff();
    result = result * PRIME + ($daysCutoff == null ? 43 : $daysCutoff.hashCode());
    final java.lang.Object $operatingDisproportionateShareHospitalAdjustment = this.getOperatingDisproportionateShareHospitalAdjustment();
    result = result * PRIME + ($operatingDisproportionateShareHospitalAdjustment == null ? 43 : $operatingDisproportionateShareHospitalAdjustment.hashCode());
    final java.lang.Object $operatingFederalSpecificPortionPart = this.getOperatingFederalSpecificPortionPart();
    result = result * PRIME + ($operatingFederalSpecificPortionPart == null ? 43 : $operatingFederalSpecificPortionPart.hashCode());
    final java.lang.Object $operatingHospitalSpecificPortionPart = this.getOperatingHospitalSpecificPortionPart();
    result = result * PRIME + ($operatingHospitalSpecificPortionPart == null ? 43 : $operatingHospitalSpecificPortionPart.hashCode());
    final java.lang.Object $operatingIndirectMedicalEducationAdjustment = this.getOperatingIndirectMedicalEducationAdjustment();
    result = result * PRIME + ($operatingIndirectMedicalEducationAdjustment == null ? 43 : $operatingIndirectMedicalEducationAdjustment.hashCode());
    final java.lang.Object $operatingOutlierPaymentPart = this.getOperatingOutlierPaymentPart();
    result = result * PRIME + ($operatingOutlierPaymentPart == null ? 43 : $operatingOutlierPaymentPart.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "IppsPaymentData(averageLengthOfStay=" + this.getAverageLengthOfStay() + ", daysCutoff=" + this.getDaysCutoff() + ", lifetimeReserveDaysUsed=" + this.getLifetimeReserveDaysUsed() + ", operatingDisproportionateShareHospitalAdjustment=" + this.getOperatingDisproportionateShareHospitalAdjustment() + ", operatingFederalSpecificPortionPart=" + this.getOperatingFederalSpecificPortionPart() + ", operatingHospitalSpecificPortionPart=" + this.getOperatingHospitalSpecificPortionPart() + ", operatingIndirectMedicalEducationAdjustment=" + this.getOperatingIndirectMedicalEducationAdjustment() + ", operatingOutlierPaymentPart=" + this.getOperatingOutlierPaymentPart() + ", outlierDays=" + this.getOutlierDays() + ", regularDaysUsed=" + this.getRegularDaysUsed() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public IppsPaymentData() {
  }
}
