/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big;

import ch.obermuhlner.math.big.BigRational;
import ch.obermuhlner.math.big.internal.AsinCalculator;
import ch.obermuhlner.math.big.internal.CosCalculator;
import ch.obermuhlner.math.big.internal.CoshCalculator;
import ch.obermuhlner.math.big.internal.ExpCalculator;
import ch.obermuhlner.math.big.internal.SinCalculator;
import ch.obermuhlner.math.big.internal.SinhCalculator;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BigDecimalMath {
    private static final BigDecimal TWO;
    private static final BigDecimal THREE;
    private static final BigDecimal MINUS_ONE;
    private static final BigDecimal ONE_HALF;
    private static final BigDecimal DOUBLE_MAX_VALUE;
    private static volatile BigDecimal log2Cache;
    private static final Object log2CacheLock;
    private static volatile BigDecimal log3Cache;
    private static final Object log3CacheLock;
    private static volatile BigDecimal log10Cache;
    private static final Object log10CacheLock;
    private static volatile BigDecimal piCache;
    private static final Object piCacheLock;
    private static volatile BigDecimal eCache;
    private static final Object eCacheLock;
    private static final BigDecimal ROUGHLY_TWO_PI;
    private static final int EXPECTED_INITIAL_PRECISION = 15;
    private static BigDecimal[] factorialCache;
    private static final Map<Integer, List<BigDecimal>> spougeFactorialConstantsCache;
    private static final Object spougeFactorialConstantsCacheLock;

    private BigDecimalMath() {
    }

    public static BigDecimal toBigDecimal(String string) {
        return BigDecimalMath.toBigDecimal(string, MathContext.UNLIMITED);
    }

    public static BigDecimal toBigDecimal(String string, MathContext mathContext) {
        int len = string.length();
        if (len < 600) {
            return new BigDecimal(string, mathContext);
        }
        int splitLength = len / (len >= 10000 ? 8 : 5);
        return BigDecimalMath.toBigDecimal(string, mathContext, splitLength);
    }

    static BigDecimal toBigDecimal(String string, MathContext mathContext, int splitLength) {
        BigDecimal result;
        int numberEndIndex;
        int len = string.length();
        if (len < splitLength) {
            return new BigDecimal(string, mathContext);
        }
        char[] chars = string.toCharArray();
        boolean numberHasSign = false;
        boolean negative = false;
        int numberIndex = 0;
        int dotIndex = -1;
        int expIndex = -1;
        boolean expHasSign = false;
        int scale = 0;
        block6: for (int i2 = 0; i2 < len; ++i2) {
            char c = chars[i2];
            switch (c) {
                case '+': {
                    if (expIndex >= 0) {
                        if (expHasSign) {
                            throw new NumberFormatException("Multiple signs in exponent");
                        }
                        expHasSign = true;
                        continue block6;
                    }
                    if (numberHasSign) {
                        throw new NumberFormatException("Multiple signs in number");
                    }
                    numberHasSign = true;
                    numberIndex = i2 + 1;
                    continue block6;
                }
                case '-': {
                    if (expIndex >= 0) {
                        if (expHasSign) {
                            throw new NumberFormatException("Multiple signs in exponent");
                        }
                        expHasSign = true;
                        continue block6;
                    }
                    if (numberHasSign) {
                        throw new NumberFormatException("Multiple signs in number");
                    }
                    numberHasSign = true;
                    negative = true;
                    numberIndex = i2 + 1;
                    continue block6;
                }
                case 'E': 
                case 'e': {
                    if (expIndex >= 0) {
                        throw new NumberFormatException("Multiple exponent markers");
                    }
                    expIndex = i2;
                    continue block6;
                }
                case '.': {
                    if (dotIndex >= 0) {
                        throw new NumberFormatException("Multiple decimal points");
                    }
                    dotIndex = i2;
                    continue block6;
                }
                default: {
                    if (dotIndex < 0 || expIndex != -1) continue block6;
                    ++scale;
                }
            }
        }
        int exp = 0;
        if (expIndex >= 0) {
            numberEndIndex = expIndex;
            String expString = new String(chars, expIndex + 1, len - expIndex - 1);
            exp = Integer.parseInt(expString);
            scale = BigDecimalMath.adjustScale(scale, exp);
        } else {
            numberEndIndex = len;
        }
        if (dotIndex >= 0) {
            int leftLength = dotIndex - numberIndex;
            BigDecimal bigDecimalLeft = BigDecimalMath.toBigDecimalRecursive(chars, numberIndex, leftLength, exp, splitLength);
            int rightLength = numberEndIndex - dotIndex - 1;
            BigDecimal bigDecimalRight = BigDecimalMath.toBigDecimalRecursive(chars, dotIndex + 1, rightLength, exp - rightLength, splitLength);
            result = bigDecimalLeft.add(bigDecimalRight);
        } else {
            result = BigDecimalMath.toBigDecimalRecursive(chars, numberIndex, numberEndIndex - numberIndex, exp, splitLength);
        }
        if (scale != 0) {
            result = result.setScale(scale);
        }
        if (negative) {
            result = result.negate();
        }
        if (mathContext.getPrecision() != 0) {
            result = result.round(mathContext);
        }
        return result;
    }

    private static int adjustScale(int scale, long exp) {
        long adjustedScale = (long)scale - exp;
        if (adjustedScale > Integer.MAX_VALUE || adjustedScale < Integer.MIN_VALUE) {
            throw new NumberFormatException("Scale out of range: " + adjustedScale + " while adjusting scale " + scale + " to exponent " + exp);
        }
        return (int)adjustedScale;
    }

    private static BigDecimal toBigDecimalRecursive(char[] chars, int offset, int length, int scale, int splitLength) {
        if (length > splitLength) {
            int mid = length / 2;
            BigDecimal bigDecimalLeft = BigDecimalMath.toBigDecimalRecursive(chars, offset, mid, scale + length - mid, splitLength);
            BigDecimal bigDecimalRight = BigDecimalMath.toBigDecimalRecursive(chars, offset + mid, length - mid, scale, splitLength);
            return bigDecimalLeft.add(bigDecimalRight);
        }
        if (length == 0) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(chars, offset, length).movePointRight(scale);
    }

    public static boolean isIntValue(BigDecimal value) {
        try {
            value.intValueExact();
            return true;
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
    }

    public static boolean isLongValue(BigDecimal value) {
        try {
            value.longValueExact();
            return true;
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
    }

    public static boolean isDoubleValue(BigDecimal value) {
        if (value.compareTo(DOUBLE_MAX_VALUE) > 0) {
            return false;
        }
        return value.compareTo(DOUBLE_MAX_VALUE.negate()) >= 0;
    }

    public static BigDecimal mantissa(BigDecimal value) {
        int exponent = BigDecimalMath.exponent(value);
        if (exponent == 0) {
            return value;
        }
        return value.movePointLeft(exponent);
    }

    public static int exponent(BigDecimal value) {
        return value.precision() - value.scale() - 1;
    }

    public static int significantDigits(BigDecimal value) {
        BigDecimal stripped = value.stripTrailingZeros();
        if (stripped.scale() >= 0) {
            return stripped.precision();
        }
        return stripped.precision() - stripped.scale();
    }

    public static BigDecimal integralPart(BigDecimal value) {
        return value.setScale(0, 1);
    }

    public static BigDecimal fractionalPart(BigDecimal value) {
        return value.subtract(BigDecimalMath.integralPart(value));
    }

    public static BigDecimal round(BigDecimal value, MathContext mathContext) {
        return value.round(mathContext);
    }

    public static BigDecimal roundWithTrailingZeroes(BigDecimal value, MathContext mathContext) {
        if (value.precision() == mathContext.getPrecision()) {
            return value;
        }
        if (value.signum() == 0) {
            return BigDecimal.ZERO.setScale(mathContext.getPrecision() - 1);
        }
        try {
            BigDecimal stripped = value.stripTrailingZeros();
            int exponentStripped = BigDecimalMath.exponent(stripped);
            BigDecimal zero = exponentStripped < -1 ? BigDecimal.ZERO.setScale(mathContext.getPrecision() - exponentStripped) : BigDecimal.ZERO.setScale(mathContext.getPrecision() + exponentStripped + 1);
            return stripped.add(zero, mathContext);
        }
        catch (ArithmeticException ex) {
            return value.round(mathContext);
        }
    }

    public static BigDecimal reciprocal(BigDecimal x, MathContext mathContext) {
        return BigDecimal.ONE.divide(x, mathContext);
    }

    public static BigDecimal factorial(int n) {
        if (n < 0) {
            throw new ArithmeticException("Illegal factorial(n) for n < 0: n = " + n);
        }
        if (n < factorialCache.length) {
            return factorialCache[n];
        }
        BigDecimal result = factorialCache[factorialCache.length - 1];
        return result.multiply(BigDecimalMath.factorialRecursion(factorialCache.length, n));
    }

    private static BigDecimal factorialLoop(int n1, int n2) {
        long limit = Long.MAX_VALUE / (long)n2;
        long accu = 1L;
        BigDecimal result = BigDecimal.ONE;
        while (n1 <= n2) {
            if (accu <= limit) {
                accu *= (long)n1;
            } else {
                result = result.multiply(BigDecimal.valueOf(accu));
                accu = n1;
            }
            ++n1;
        }
        return result.multiply(BigDecimal.valueOf(accu));
    }

    private static BigDecimal factorialRecursion(int n1, int n2) {
        int threshold;
        int n = threshold = n1 > 200 ? 80 : 150;
        if (n2 - n1 < threshold) {
            return BigDecimalMath.factorialLoop(n1, n2);
        }
        int mid = n1 + n2 >> 1;
        return BigDecimalMath.factorialRecursion(mid + 1, n2).multiply(BigDecimalMath.factorialRecursion(n1, mid));
    }

    public static BigDecimal factorial(BigDecimal x, MathContext mathContext) {
        if (BigDecimalMath.isIntValue(x)) {
            return BigDecimalMath.round(BigDecimalMath.factorial(x.intValueExact()), mathContext);
        }
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() << 1, mathContext.getRoundingMode());
        int a = mathContext.getPrecision() * 13 / 10;
        List<BigDecimal> constants = BigDecimalMath.getSpougeFactorialConstants(a);
        BigDecimal bigA = BigDecimal.valueOf(a);
        boolean negative = false;
        BigDecimal factor = constants.get(0);
        for (int k = 1; k < a; ++k) {
            BigDecimal bigK = BigDecimal.valueOf(k);
            factor = factor.add(constants.get(k).divide(x.add(bigK), mc));
            negative = !negative;
        }
        BigDecimal result = BigDecimalMath.pow(x.add(bigA), x.add(BigDecimal.valueOf(0.5)), mc);
        result = result.multiply(BigDecimalMath.exp(x.negate().subtract(bigA), mc));
        result = result.multiply(factor);
        return BigDecimalMath.round(result, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<BigDecimal> getSpougeFactorialConstants(int a) {
        Object object = spougeFactorialConstantsCacheLock;
        synchronized (object) {
            return spougeFactorialConstantsCache.computeIfAbsent(a, key -> {
                ArrayList<BigDecimal> constants = new ArrayList<BigDecimal>(a);
                MathContext mc = new MathContext(a * 15 / 10);
                BigDecimal c0 = BigDecimalMath.sqrt(BigDecimalMath.pi(mc).multiply(TWO, mc), mc);
                constants.add(c0);
                boolean negative = false;
                for (int k = 1; k < a; ++k) {
                    BigDecimal bigK = BigDecimal.valueOf(k);
                    long deltaAK = (long)a - (long)k;
                    BigDecimal ck = BigDecimalMath.pow(BigDecimal.valueOf(deltaAK), bigK.subtract(ONE_HALF), mc);
                    ck = ck.multiply(BigDecimalMath.exp(BigDecimal.valueOf(deltaAK), mc), mc);
                    ck = ck.divide(BigDecimalMath.factorial(k - 1), mc);
                    if (negative) {
                        ck = ck.negate();
                    }
                    constants.add(ck);
                    negative = !negative;
                }
                return Collections.unmodifiableList(constants);
            });
        }
    }

    public static BigDecimal gamma(BigDecimal x, MathContext mathContext) {
        return BigDecimalMath.factorial(x.subtract(BigDecimal.ONE), mathContext);
    }

    public static BigDecimal bernoulli(int n, MathContext mathContext) {
        if (n < 0) {
            throw new ArithmeticException("Illegal bernoulli(n) for n < 0: n = " + n);
        }
        BigRational b = BigRational.bernoulli(n);
        return b.toBigDecimal(mathContext);
    }

    public static BigDecimal pow(BigDecimal x, BigDecimal y, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        if (x.signum() == 0) {
            switch (y.signum()) {
                case 0: {
                    return BigDecimalMath.round(BigDecimal.ONE, mathContext);
                }
                case 1: {
                    return BigDecimalMath.round(BigDecimal.ZERO, mathContext);
                }
            }
        }
        try {
            long longValue = y.longValueExact();
            return BigDecimalMath.pow(x, longValue, mathContext);
        }
        catch (ArithmeticException longValue) {
            if (BigDecimalMath.fractionalPart(y).signum() == 0) {
                return BigDecimalMath.powInteger(x, y, mathContext);
            }
            MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
            BigDecimal result = BigDecimalMath.exp(y.multiply(BigDecimalMath.log(x, mc), mc), mc);
            return BigDecimalMath.round(result, mathContext);
        }
    }

    public static BigDecimal pow(BigDecimal x, long y, MathContext mathContext) {
        MathContext mc;
        MathContext mathContext2 = mc = mathContext.getPrecision() == 0 ? mathContext : new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        if (y < 0L) {
            BigDecimal value = BigDecimalMath.reciprocal(BigDecimalMath.pow(x, -y, mc), mc);
            return BigDecimalMath.round(value, mathContext);
        }
        BigDecimal result = BigDecimal.ONE;
        while (y > 0L) {
            if ((y & 1L) == 1L) {
                result = result.multiply(x, mc);
                --y;
            }
            if (y > 0L) {
                x = x.multiply(x, mc);
            }
            y >>= 1;
        }
        return BigDecimalMath.round(result, mathContext);
    }

    private static BigDecimal powInteger(BigDecimal x, BigDecimal integerY, MathContext mathContext) {
        if (BigDecimalMath.fractionalPart(integerY).signum() != 0) {
            throw new IllegalArgumentException("Not integer value: " + integerY);
        }
        if (integerY.signum() < 0) {
            return BigDecimal.ONE.divide(BigDecimalMath.powInteger(x, integerY.negate(), mathContext), mathContext);
        }
        MathContext mc = new MathContext(Math.max(mathContext.getPrecision(), -integerY.scale()) + 30, mathContext.getRoundingMode());
        BigDecimal result = BigDecimal.ONE;
        while (integerY.signum() > 0) {
            BigDecimal halfY = integerY.divide(TWO, mc);
            if (BigDecimalMath.fractionalPart(halfY).signum() != 0) {
                result = result.multiply(x, mc);
                integerY = integerY.subtract(BigDecimal.ONE);
                halfY = integerY.divide(TWO, mc);
            }
            if (halfY.signum() > 0) {
                x = x.multiply(x, mc);
            }
            integerY = halfY;
        }
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal sqrt(BigDecimal x, MathContext mathContext) {
        int adaptivePrecision;
        BigDecimal result;
        BigDecimalMath.checkMathContext(mathContext);
        switch (x.signum()) {
            case 0: {
                return BigDecimal.ZERO;
            }
            case -1: {
                throw new ArithmeticException("Illegal sqrt(x) for x < 0: x = " + x);
            }
        }
        int maxPrecision = mathContext.getPrecision() + 6;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        if (BigDecimalMath.isDoubleValue(x)) {
            result = BigDecimal.valueOf(Math.sqrt(x.doubleValue()));
            adaptivePrecision = 15;
        } else {
            result = x.multiply(ONE_HALF, mathContext);
            adaptivePrecision = 1;
        }
        if (adaptivePrecision < maxPrecision) {
            BigDecimal last;
            if (result.multiply(result).compareTo(x) == 0) {
                return BigDecimalMath.round(result, mathContext);
            }
            do {
                last = result;
                if ((adaptivePrecision <<= 1) > maxPrecision) {
                    adaptivePrecision = maxPrecision;
                }
                MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
                result = x.divide(result, mc).add(last).multiply(ONE_HALF, mc);
            } while (adaptivePrecision < maxPrecision || result.subtract(last).abs().compareTo(acceptableError) > 0);
        }
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal root(BigDecimal x, BigDecimal n, MathContext mathContext) {
        BigDecimal step;
        BigDecimalMath.checkMathContext(mathContext);
        switch (x.signum()) {
            case 0: {
                return BigDecimal.ZERO;
            }
            case -1: {
                throw new ArithmeticException("Illegal root(x) for x < 0: x = " + x);
            }
        }
        if (n.compareTo(BigDecimal.ONE) <= 0) {
            MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
            return BigDecimalMath.pow(x, BigDecimal.ONE.divide(n, mc), mathContext);
        }
        int maxPrecision = mathContext.getPrecision() + 4;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        BigDecimal nMinus1 = n.subtract(BigDecimal.ONE);
        BigDecimal result = x.divide(TWO, MathContext.DECIMAL32);
        int adaptivePrecision = 2;
        do {
            if ((adaptivePrecision *= 3) > maxPrecision) {
                adaptivePrecision = maxPrecision;
            }
            MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
            step = x.divide(BigDecimalMath.pow(result, nMinus1, mc), mc).subtract(result).divide(n, mc);
            result = result.add(step);
        } while (adaptivePrecision < maxPrecision || step.abs().compareTo(acceptableError) > 0);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal log(BigDecimal x, MathContext mathContext) {
        BigDecimal result;
        BigDecimalMath.checkMathContext(mathContext);
        if (x.signum() <= 0) {
            throw new ArithmeticException("Illegal log(x) for x <= 0: x = " + x);
        }
        if (x.compareTo(BigDecimal.ONE) == 0) {
            return BigDecimal.ZERO;
        }
        switch (x.compareTo(BigDecimal.TEN)) {
            case 0: {
                result = BigDecimalMath.logTen(mathContext);
                break;
            }
            case 1: {
                result = BigDecimalMath.logUsingExponent(x, mathContext);
                break;
            }
            default: {
                result = BigDecimalMath.logUsingTwoThree(x, mathContext);
            }
        }
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal log2(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x, mc).divide(BigDecimalMath.logTwo(mc), mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal log10(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 2, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x, mc).divide(BigDecimalMath.logTen(mc), mc);
        return BigDecimalMath.round(result, mathContext);
    }

    private static BigDecimal logUsingNewton(BigDecimal x, MathContext mathContext) {
        BigDecimal step;
        int adaptivePrecision;
        BigDecimal result;
        int maxPrecision = mathContext.getPrecision() + 20;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        double doubleX = x.doubleValue();
        if (doubleX > 0.0 && BigDecimalMath.isDoubleValue(x)) {
            result = BigDecimal.valueOf(Math.log(doubleX));
            adaptivePrecision = 15;
        } else {
            result = x.divide(TWO, mathContext);
            adaptivePrecision = 1;
        }
        do {
            if ((adaptivePrecision *= 3) > maxPrecision) {
                adaptivePrecision = maxPrecision;
            }
            MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
            BigDecimal expY = BigDecimalMath.exp(result, mc);
            step = TWO.multiply(x.subtract(expY)).divide(x.add(expY), mc);
            result = result.add(step);
        } while (adaptivePrecision < maxPrecision || step.abs().compareTo(acceptableError) > 0);
        return result;
    }

    private static BigDecimal logUsingExponent(BigDecimal x, MathContext mathContext) {
        MathContext mcDouble = new MathContext(mathContext.getPrecision() << 1, mathContext.getRoundingMode());
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        int exponent = BigDecimalMath.exponent(x);
        BigDecimal mantissa = BigDecimalMath.mantissa(x);
        BigDecimal result = BigDecimalMath.logUsingTwoThree(mantissa, mc);
        if (exponent != 0) {
            result = result.add(BigDecimal.valueOf(exponent).multiply(BigDecimalMath.logTen(mcDouble), mc));
        }
        return result;
    }

    private static BigDecimal logUsingTwoThree(BigDecimal x, MathContext mathContext) {
        MathContext mcDouble = new MathContext(mathContext.getPrecision() << 1, mathContext.getRoundingMode());
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        int factorOfTwo = 0;
        int powerOfTwo = 1;
        int factorOfThree = 0;
        int powerOfThree = 1;
        double value = x.doubleValue();
        if (!(value < 0.01)) {
            if (value < 0.1) {
                while (value < 0.6) {
                    value *= 2.0;
                    --factorOfTwo;
                    powerOfTwo <<= 1;
                }
            } else if (value < 0.115) {
                factorOfThree = -2;
                powerOfThree = 9;
            } else if (value < 0.14) {
                factorOfTwo = -3;
                powerOfTwo = 8;
            } else if (value < 0.2) {
                factorOfTwo = -1;
                powerOfTwo = 2;
                factorOfThree = -1;
                powerOfThree = 3;
            } else if (value < 0.3) {
                factorOfTwo = -2;
                powerOfTwo = 4;
            } else if (value < 0.42) {
                factorOfThree = -1;
                powerOfThree = 3;
            } else if (value < 0.7) {
                factorOfTwo = -1;
                powerOfTwo = 2;
            } else if (!(value < 1.4)) {
                if (value < 2.5) {
                    factorOfTwo = 1;
                    powerOfTwo = 2;
                } else if (value < 3.5) {
                    factorOfThree = 1;
                    powerOfThree = 3;
                } else if (value < 5.0) {
                    factorOfTwo = 2;
                    powerOfTwo = 4;
                } else if (value < 7.0) {
                    factorOfThree = 1;
                    powerOfThree = 3;
                    factorOfTwo = 1;
                    powerOfTwo = 2;
                } else if (value < 8.5) {
                    factorOfTwo = 3;
                    powerOfTwo = 8;
                } else if (value < 10.0) {
                    factorOfThree = 2;
                    powerOfThree = 9;
                } else {
                    while (value > 1.4) {
                        value /= 2.0;
                        ++factorOfTwo;
                        powerOfTwo <<= 1;
                    }
                }
            }
        }
        BigDecimal correctedX = x;
        BigDecimal result = BigDecimal.ZERO;
        if (factorOfTwo > 0) {
            correctedX = correctedX.divide(BigDecimal.valueOf(powerOfTwo), mc);
            result = result.add(BigDecimalMath.logTwo(mcDouble).multiply(BigDecimal.valueOf(factorOfTwo), mc));
        } else if (factorOfTwo < 0) {
            correctedX = correctedX.multiply(BigDecimal.valueOf(powerOfTwo), mc);
            result = result.subtract(BigDecimalMath.logTwo(mcDouble).multiply(BigDecimal.valueOf(-factorOfTwo), mc));
        }
        if (factorOfThree > 0) {
            correctedX = correctedX.divide(BigDecimal.valueOf(powerOfThree), mc);
            result = result.add(BigDecimalMath.logThree(mcDouble).multiply(BigDecimal.valueOf(factorOfThree), mc));
        } else if (factorOfThree < 0) {
            correctedX = correctedX.multiply(BigDecimal.valueOf(powerOfThree), mc);
            result = result.subtract(BigDecimalMath.logThree(mcDouble).multiply(BigDecimal.valueOf(-factorOfThree), mc));
        }
        if (x == correctedX && result == BigDecimal.ZERO) {
            return BigDecimalMath.logUsingNewton(x, mathContext);
        }
        result = result.add(BigDecimalMath.logUsingNewton(correctedX, mc), mc);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal pi(MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        BigDecimal result = null;
        Object object = piCacheLock;
        synchronized (object) {
            if (piCache == null || mathContext.getPrecision() > piCache.precision()) {
                piCache = BigDecimalMath.piChudnovski(mathContext);
                return piCache;
            }
            result = piCache;
        }
        return BigDecimalMath.round(result, mathContext);
    }

    private static BigDecimal piChudnovski(MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        BigDecimal value24 = BigDecimal.valueOf(24L);
        BigDecimal value640320 = BigDecimal.valueOf(640320L);
        BigDecimal value13591409 = BigDecimal.valueOf(13591409L);
        BigDecimal value545140134 = BigDecimal.valueOf(545140134L);
        BigDecimal valueDivisor = value640320.pow(3).divide(value24, mc);
        BigDecimal sumA = BigDecimal.ONE;
        BigDecimal sumB = BigDecimal.ZERO;
        BigDecimal a = BigDecimal.ONE;
        long dividendTerm1 = 5L;
        long dividendTerm2 = -1L;
        long dividendTerm3 = -1L;
        BigDecimal kPower3 = BigDecimal.ZERO;
        long iterationCount = (mc.getPrecision() + 13) / 14;
        for (long k = 1L; k <= iterationCount; ++k) {
            BigDecimal valueK = BigDecimal.valueOf(k);
            BigDecimal dividend = BigDecimal.valueOf(dividendTerm1 += -6L).multiply(BigDecimal.valueOf(dividendTerm2 += 2L)).multiply(BigDecimal.valueOf(dividendTerm3 += 6L));
            kPower3 = valueK.pow(3);
            BigDecimal divisor = kPower3.multiply(valueDivisor, mc);
            a = a.multiply(dividend).divide(divisor, mc);
            BigDecimal b = valueK.multiply(a, mc);
            sumA = sumA.add(a);
            sumB = sumB.add(b);
        }
        BigDecimal value426880 = BigDecimal.valueOf(426880L);
        BigDecimal value10005 = BigDecimal.valueOf(10005L);
        BigDecimal factor = value426880.multiply(BigDecimalMath.sqrt(value10005, mc));
        BigDecimal pi = factor.divide(value13591409.multiply(sumA, mc).add(value545140134.multiply(sumB, mc)), mc);
        return BigDecimalMath.round(pi, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal e(MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        BigDecimal result = null;
        Object object = eCacheLock;
        synchronized (object) {
            if (eCache == null || mathContext.getPrecision() > eCache.precision()) {
                eCache = BigDecimalMath.exp(BigDecimal.ONE, mathContext);
                return eCache;
            }
            result = eCache;
        }
        return BigDecimalMath.round(result, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logTen(MathContext mathContext) {
        BigDecimal result = null;
        Object object = log10CacheLock;
        synchronized (object) {
            if (log10Cache == null || mathContext.getPrecision() > log10Cache.precision()) {
                log10Cache = BigDecimalMath.logUsingNewton(BigDecimal.TEN, mathContext);
                return log10Cache;
            }
            result = log10Cache;
        }
        return BigDecimalMath.round(result, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logTwo(MathContext mathContext) {
        BigDecimal result = null;
        Object object = log2CacheLock;
        synchronized (object) {
            if (log2Cache == null || mathContext.getPrecision() > log2Cache.precision()) {
                log2Cache = BigDecimalMath.logUsingNewton(TWO, mathContext);
                return log2Cache;
            }
            result = log2Cache;
        }
        return BigDecimalMath.round(result, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logThree(MathContext mathContext) {
        BigDecimal result = null;
        Object object = log3CacheLock;
        synchronized (object) {
            if (log3Cache == null || mathContext.getPrecision() > log3Cache.precision()) {
                log3Cache = BigDecimalMath.logUsingNewton(THREE, mathContext);
                return log3Cache;
            }
            result = log3Cache;
        }
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal exp(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        if (x.signum() == 0) {
            return BigDecimal.ONE;
        }
        return BigDecimalMath.expIntegralFractional(x, mathContext);
    }

    private static BigDecimal expIntegralFractional(BigDecimal x, MathContext mathContext) {
        BigDecimal integralPart = BigDecimalMath.integralPart(x);
        if (integralPart.signum() == 0) {
            return BigDecimalMath.expTaylor(x, mathContext);
        }
        BigDecimal fractionalPart = x.subtract(integralPart);
        MathContext mc = new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        BigDecimal z = BigDecimal.ONE.add(fractionalPart.divide(integralPart, mc));
        BigDecimal t2 = BigDecimalMath.expTaylor(z, mc);
        BigDecimal result = BigDecimalMath.pow(t2, integralPart.intValueExact(), mc);
        return BigDecimalMath.round(result, mathContext);
    }

    private static BigDecimal expTaylor(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        x = x.divide(BigDecimal.valueOf(256L), mc);
        BigDecimal result = ExpCalculator.INSTANCE.calculate(x, mc);
        result = BigDecimalMath.pow(result, 256L, mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal sin(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        if (x.abs().compareTo(ROUGHLY_TWO_PI) > 0) {
            MathContext mc2 = new MathContext(mc.getPrecision() + 4, mathContext.getRoundingMode());
            BigDecimal twoPi = TWO.multiply(BigDecimalMath.pi(mc2));
            x = x.remainder(twoPi, mc2);
        }
        BigDecimal result = SinCalculator.INSTANCE.calculate(x, mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal asin(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        if (x.compareTo(BigDecimal.ONE) > 0) {
            throw new ArithmeticException("Illegal asin(x) for x > 1: x = " + x);
        }
        if (x.compareTo(MINUS_ONE) < 0) {
            throw new ArithmeticException("Illegal asin(x) for x < -1: x = " + x);
        }
        if (x.signum() == -1) {
            return BigDecimalMath.asin(x.negate(), mathContext).negate();
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        if (x.compareTo(BigDecimal.valueOf(0.707107)) >= 0) {
            BigDecimal xTransformed = BigDecimalMath.sqrt(BigDecimal.ONE.subtract(x.multiply(x)), mc);
            return BigDecimalMath.acos(xTransformed, mathContext);
        }
        BigDecimal result = AsinCalculator.INSTANCE.calculate(x, mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal cos(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        if (x.abs().compareTo(ROUGHLY_TWO_PI) > 0) {
            MathContext mc2 = new MathContext(mc.getPrecision() + 4, mathContext.getRoundingMode());
            BigDecimal twoPi = TWO.multiply(BigDecimalMath.pi(mc2), mc2);
            x = x.remainder(twoPi, mc2);
        }
        BigDecimal result = CosCalculator.INSTANCE.calculate(x, mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal acos(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        if (x.compareTo(BigDecimal.ONE) > 0) {
            throw new ArithmeticException("Illegal acos(x) for x > 1: x = " + x);
        }
        if (x.compareTo(MINUS_ONE) < 0) {
            throw new ArithmeticException("Illegal acos(x) for x < -1: x = " + x);
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.pi(mc).divide(TWO, mc).subtract(BigDecimalMath.asin(x, mc));
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal tan(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        if (x.signum() == 0) {
            return BigDecimal.ZERO;
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.sin(x, mc).divide(BigDecimalMath.cos(x, mc), mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal atan(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        x = x.divide(BigDecimalMath.sqrt(BigDecimal.ONE.add(x.multiply(x, mc)), mc), mc);
        BigDecimal result = BigDecimalMath.asin(x, mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal atan2(BigDecimal y, BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 3, mathContext.getRoundingMode());
        if (x.signum() > 0) {
            return BigDecimalMath.atan(y.divide(x, mc), mathContext);
        }
        if (x.signum() < 0) {
            if (y.signum() > 0) {
                return BigDecimalMath.atan(y.divide(x, mc), mc).add(BigDecimalMath.pi(mc), mathContext);
            }
            if (y.signum() < 0) {
                return BigDecimalMath.atan(y.divide(x, mc), mc).subtract(BigDecimalMath.pi(mc), mathContext);
            }
            return BigDecimalMath.pi(mathContext);
        }
        if (y.signum() > 0) {
            return BigDecimalMath.pi(mc).divide(TWO, mathContext);
        }
        if (y.signum() < 0) {
            return BigDecimalMath.pi(mc).divide(TWO, mathContext).negate();
        }
        throw new ArithmeticException("Illegal atan2(y, x) for x = 0; y = 0");
    }

    public static BigDecimal cot(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        if (x.signum() == 0) {
            throw new ArithmeticException("Illegal cot(x) for x = 0");
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.cos(x, mc).divide(BigDecimalMath.sin(x, mc), mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal acot(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.pi(mc).divide(TWO, mc).subtract(BigDecimalMath.atan(x, mc));
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal sinh(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = SinhCalculator.INSTANCE.calculate(x, mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal cosh(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = CoshCalculator.INSTANCE.calculate(x, mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal tanh(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.sinh(x, mc).divide(BigDecimalMath.cosh(x, mc), mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal coth(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.cosh(x, mc).divide(BigDecimalMath.sinh(x, mc), mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal asinh(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x.add(BigDecimalMath.sqrt(x.multiply(x, mc).add(BigDecimal.ONE, mc), mc)), mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal acosh(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x.add(BigDecimalMath.sqrt(x.multiply(x).subtract(BigDecimal.ONE), mc)), mc);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal atanh(BigDecimal x, MathContext mathContext) {
        if (x.compareTo(BigDecimal.ONE) >= 0) {
            throw new ArithmeticException("Illegal atanh(x) for x >= 1: x = " + x);
        }
        if (x.compareTo(MINUS_ONE) <= 0) {
            throw new ArithmeticException("Illegal atanh(x) for x <= -1: x = " + x);
        }
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(BigDecimal.ONE.add(x).divide(BigDecimal.ONE.subtract(x), mc), mc).multiply(ONE_HALF);
        return BigDecimalMath.round(result, mathContext);
    }

    public static BigDecimal acoth(BigDecimal x, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x.add(BigDecimal.ONE).divide(x.subtract(BigDecimal.ONE), mc), mc).multiply(ONE_HALF);
        return BigDecimalMath.round(result, mathContext);
    }

    private static void checkMathContext(MathContext mathContext) {
        if (mathContext.getPrecision() == 0) {
            throw new UnsupportedOperationException("Unlimited MathContext not supported");
        }
    }

    static {
        BigDecimal result;
        TWO = BigDecimal.valueOf(2L);
        THREE = BigDecimal.valueOf(3L);
        MINUS_ONE = BigDecimal.valueOf(-1L);
        ONE_HALF = BigDecimal.valueOf(0.5);
        DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
        log2CacheLock = new Object();
        log3CacheLock = new Object();
        log10CacheLock = new Object();
        piCacheLock = new Object();
        eCacheLock = new Object();
        ROUGHLY_TWO_PI = new BigDecimal("3.141592653589793").multiply(TWO);
        factorialCache = new BigDecimal[100];
        BigDecimalMath.factorialCache[0] = result = BigDecimal.ONE;
        for (int i2 = 1; i2 < factorialCache.length; ++i2) {
            BigDecimalMath.factorialCache[i2] = result = result.multiply(BigDecimal.valueOf(i2));
        }
        spougeFactorialConstantsCache = new HashMap<Integer, List<BigDecimal>>();
        spougeFactorialConstantsCacheLock = new Object();
    }
}

