/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.blackbird.ser.OptimizedBeanPropertyWriter;
import com.fasterxml.jackson.module.blackbird.ser.ToBooleanFunction;

final class BooleanPropertyWriter
extends OptimizedBeanPropertyWriter<BooleanPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final boolean _suppressableSet;
    private final boolean _suppressableBoolean;
    private final ToBooleanFunction _acc;

    public BooleanPropertyWriter(BeanPropertyWriter src, ToBooleanFunction acc, JsonSerializer<Object> ser) {
        super(src, ser);
        this._acc = acc;
        if (this._suppressableValue instanceof Boolean) {
            this._suppressableBoolean = (Boolean)this._suppressableValue;
            this._suppressableSet = true;
        } else {
            this._suppressableBoolean = false;
            this._suppressableSet = false;
        }
    }

    protected BooleanPropertyWriter(BooleanPropertyWriter base, PropertyName name) {
        super(base, name);
        this._suppressableSet = base._suppressableSet;
        this._suppressableBoolean = base._suppressableBoolean;
        this._acc = base._acc;
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new BooleanPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new BooleanPropertyWriter(this, this._acc, ser);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        boolean value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, gen, prov);
            return;
        }
        try {
            value = this._acc.applyAsBoolean(bean);
        }
        catch (Throwable t2) {
            this._handleProblem(bean, gen, prov, t2, false);
            return;
        }
        if (!this._suppressableSet || this._suppressableBoolean != value) {
            gen.writeFieldName(this._fastName);
            gen.writeBoolean(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        boolean value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, gen, prov);
            return;
        }
        try {
            value = this._acc.applyAsBoolean(bean);
        }
        catch (Throwable t2) {
            this._handleProblem(bean, gen, prov, t2, true);
            return;
        }
        if (!this._suppressableSet || this._suppressableBoolean != value) {
            gen.writeBoolean(value);
        } else {
            this.serializeAsPlaceholder(bean, gen, prov);
        }
    }
}

