/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core;

import gov.cms.fiss.pricers.common.api.InternalPricerException;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.ClaimProcessor;
import gov.cms.fiss.pricers.common.application.PricerDispatch;
import gov.cms.fiss.pricers.irf.IrfPricerConfiguration;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimData;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.core.Irf2015RulePricer;
import gov.cms.fiss.pricers.irf.core.Irf2016RulePricer;
import gov.cms.fiss.pricers.irf.core.Irf2017RulePricer;
import gov.cms.fiss.pricers.irf.core.Irf2018RulePricer;
import gov.cms.fiss.pricers.irf.core.Irf2019RulePricer;
import gov.cms.fiss.pricers.irf.core.Irf2020RulePricer;
import gov.cms.fiss.pricers.irf.core.Irf2021RulePricer;
import gov.cms.fiss.pricers.irf.core.Irf2022RulePricer;
import gov.cms.fiss.pricers.irf.core.Irf2023RulePricer;
import gov.cms.fiss.pricers.irf.core.Irf2024RulePricer;
import gov.cms.fiss.pricers.irf.core.Irf2025RulePricer;
import gov.cms.fiss.pricers.irf.core.Irf2026RulePricer;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import gov.cms.fiss.pricers.irf.core.tables.DataTables;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrfPricerDispatch
extends PricerDispatch<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerConfiguration> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(IrfPricerDispatch.class);

    public IrfPricerDispatch(IrfPricerConfiguration pricerConfiguration) {
        super(pricerConfiguration, o -> o.getReturnCodeData().getCode());
    }

    @Override
    protected void initializeReferences(IrfPricerConfiguration pricerConfiguration) {
        DataTables.loadDataTables(pricerConfiguration);
        for (int supportedYear : pricerConfiguration.getSupportedYears()) {
            switch (supportedYear) {
                case 2015: {
                    this.yearReference.register(supportedYear, Irf2015RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2016: {
                    this.yearReference.register(supportedYear, Irf2016RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2017: {
                    this.yearReference.register(supportedYear, Irf2017RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2018: {
                    this.yearReference.register(supportedYear, Irf2018RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2019: {
                    this.yearReference.register(supportedYear, Irf2019RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2020: {
                    this.yearReference.register(supportedYear, Irf2020RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2021: {
                    this.yearReference.register(supportedYear, Irf2021RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2022: {
                    this.yearReference.register(supportedYear, Irf2022RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2023: {
                    this.yearReference.register(supportedYear, Irf2023RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2024: {
                    this.yearReference.register(supportedYear, Irf2024RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2025: {
                    this.yearReference.register(supportedYear, Irf2025RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2026: {
                    this.yearReference.register(supportedYear, Irf2026RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
            }
        }
    }

    @Override
    protected ClaimProcessor<IrfClaimPricingRequest, IrfClaimPricingResponse> getProcessor(IrfClaimPricingRequest input) throws YearNotImplementedException, InternalPricerException {
        return this.yearReference.fromFiscalYear(((IrfClaimData)input.getClaimData()).getDischargeDate(), "dischargeDate");
    }

    @Override
    protected boolean isErrorOutput(IrfClaimPricingResponse output) {
        int code = Integer.parseInt(output.getReturnCodeData().getCode());
        return ResultCode.fromCode(code).isError();
    }
}

