/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import gov.cms.fiss.pricers.irf.core.tables.CbsaWageIndexEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class ApplySupplementalWageIndex
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00) && StringUtils.equals(calculationContext.getProviderData().getSupplementalWageIndexIndicator(), "1");
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        if (null == providerData.getSupplementalWageIndex() || BigDecimalUtils.isZero(providerData.getSupplementalWageIndex())) {
            calculationContext.applyResultCode(ResultCode.INVALID_WAGE_INDEX_52, ResultCode.INVALID_WAGE_INDEX_52.getDescription(), "Supplemental wage index required");
            return;
        }
        if (!LocalDateUtils.inRange(calculationContext.getProviderEffectiveDate(), calculationContext.getFiscalYearStart(), calculationContext.getFiscalYearEnd())) {
            calculationContext.applyResultCode(ResultCode.INVALID_WAGE_INDEX_52, ResultCode.INVALID_WAGE_INDEX_52.getDescription(), "Supplemental wage index not within fiscal year");
            return;
        }
        CbsaWageIndexEntry cbsaWageIndex = calculationContext.getCbsaWageIndexEntry();
        this.capWageIndexDecrease(cbsaWageIndex, calculationContext);
        paymentData.setFinalCbsa(calculationContext.getCbsaWageIndexEntry().getCbsa());
        paymentData.setFinalWageIndex(calculationContext.getCbsaWageIndexEntry().getGeographicWageIndex().setScale(4, RoundingMode.HALF_UP));
    }

    private void capWageIndexDecrease(CbsaWageIndexEntry cbsaTableEntry, IrfPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        BigDecimal wageIndexPercentReduction = cbsaTableEntry.getGeographicWageIndex().subtract(providerData.getSupplementalWageIndex()).divide(providerData.getSupplementalWageIndex(), RoundingMode.HALF_UP);
        if (BigDecimalUtils.isLessThan(wageIndexPercentReduction, calculationContext.getWageIndexPercentReductionCap())) {
            CbsaWageIndexEntry entryCopy = cbsaTableEntry.copyBuilder().geographicWageIndex(providerData.getSupplementalWageIndex().multiply(calculationContext.getWageIndexPercentAdjustment())).build();
            calculationContext.setCbsaWageIndexEntry(entryCopy);
        }
    }
}

