/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateFederalPaymentAmount
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal laborPortion = BigDecimalUtils.truncateDecimals(paymentData.getStandardPayment().multiply(paymentData.getNationalLaborPercent()).multiply(paymentData.getFinalWageIndex()), 6).setScale(6, RoundingMode.HALF_UP);
        BigDecimal nonLaborPortion = BigDecimalUtils.truncateDecimals(paymentData.getStandardPayment().multiply(paymentData.getNationalNonLaborPercent()), 6).setScale(6, RoundingMode.HALF_UP);
        paymentData.setFederalPaymentAmount(laborPortion.add(nonLaborPortion).multiply(paymentData.getRuralAdjustmentPercent()).setScale(2, RoundingMode.HALF_UP));
    }
}

