/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import gov.cms.fiss.pricers.irf.core.tables.CmgTableEntry;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class DefaultCmgReview
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        String cmgCode = paymentData.getSubmittedCaseMixGroupCode();
        if (cmgCode.length() < 5) {
            calculationContext.applyResultCode(ResultCode.CMG_ON_CLAIM_NOT_IN_TABLE_54);
            return;
        }
        String cmgNumeric = cmgCode.substring(1, 5);
        if (!cmgNumeric.equals("9999") && !cmgNumeric.equals("5001") && cmgNumeric.compareTo("2103") >= 0) {
            calculationContext.applyResultCode(ResultCode.CMG_ON_CLAIM_NOT_IN_TABLE_54, ResultCode.CMG_ON_CLAIM_NOT_IN_TABLE_54.getDescription(), "PPS case mix group is not numeric or greater than 2102");
            return;
        }
        CmgTableEntry cmgEntry = calculationContext.getCmgEntry(cmgNumeric);
        if (cmgEntry == null) {
            calculationContext.applyResultCode(ResultCode.CMG_ON_CLAIM_NOT_IN_TABLE_54);
        } else {
            this.findValue(calculationContext, paymentData, cmgEntry);
        }
    }

    protected void findValue(IrfPricerContext calculationContext, IrfPaymentData paymentData, CmgTableEntry cmgEntry) {
        switch (StringUtils.left(paymentData.getSubmittedCaseMixGroupCode(), 1)) {
            case "A": {
                paymentData.setCaseMixGroupRelativeWeight(cmgEntry.getARelativeWeight().setScale(4, RoundingMode.HALF_UP));
                paymentData.setAverageLengthOfStay(cmgEntry.getAAvgLengthOfStay());
                break;
            }
            case "B": {
                paymentData.setCaseMixGroupRelativeWeight(cmgEntry.getBRelativeWeight().setScale(4, RoundingMode.HALF_UP));
                paymentData.setAverageLengthOfStay(cmgEntry.getBAvgLengthOfStay());
                break;
            }
            case "C": {
                paymentData.setCaseMixGroupRelativeWeight(cmgEntry.getCRelativeWeight().setScale(4, RoundingMode.HALF_UP));
                paymentData.setAverageLengthOfStay(cmgEntry.getCAvgLengthOfStay());
                break;
            }
            case "D": {
                paymentData.setCaseMixGroupRelativeWeight(cmgEntry.getDRelativeWeight().setScale(4, RoundingMode.HALF_UP));
                paymentData.setAverageLengthOfStay(cmgEntry.getDAvgLengthOfStay());
                break;
            }
            default: {
                calculationContext.applyResultCode(ResultCode.CMG_ON_CLAIM_NOT_IN_TABLE_54, ResultCode.CMG_ON_CLAIM_NOT_IN_TABLE_54.getDescription(), "CMG provided in claim doesn't have a valid severity level");
            }
        }
    }
}

